unit LogoMain;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, Grids, DBGrids, swmodule,
  swkey, swvskey, swtxtdsp;

type
    TSwordAppForm = class(TForm)
        MainMenu: TMainMenu;
        FileMenu: TMenuItem;
        FileExitItem: TMenuItem;
        Help1: TMenuItem;
        AboutItem: TMenuItem;
    pnlToolbar: TPanel;
        StatusBar: TStatusBar;
        BookCB: TComboBox;
        CHBox: TEdit;
        VSBox: TEdit;
        Label1: TLabel;
    btnLookup: TSpeedButton;
    lblTextKeyText: TLabel;
    PopupMenu1: TPopupMenu;
    EastonsBibleDictionary1: TMenuItem;
    VinesBibleDictionary1: TMenuItem;
    mrtWebster: TSWModule;
    mrcMHC: TSWModule;
    mrldEastons: TSWModule;
    mrldVines: TSWModule;
    vkCommonKey: TSWVerseKey;
    DblClkWordRtClkMouse1: TMenuItem;
    Search1: TMenuItem;
    NewSearchWindow1: TMenuItem;
    Bevel1: TBevel;
    pnlMain: TPanel;
    pnlText: TPanel;
    lblTextTitle: TLabel;
    pnlCommentary: TPanel;
    lblCommentTitle: TLabel;
    edCommentBox: TRichEdit;
    pnlVSplitter: TPanel;
    pnlHSplitter: TPanel;
    pnlDictionary: TPanel;
    edLDBox: TRichEdit;
    pnlDcitionaryTitle: TPanel;
    Label2: TLabel;
    lblLDTitle: TLabel;
    btnPreviousVerse: TButton;
    btnNextVerse: TButton;
    lblLDKeyText: TLabel;
    edTextBox: TSWTextDisp;
        procedure FormCreate(Sender: TObject);
        procedure FileExit(Sender: TObject);
        procedure Lookup(Sender: TObject);
        procedure About(Sender: TObject);
        procedure ShowHint(Sender: TObject);
    procedure EastonsBibleDictionary1Click(Sender: TObject);
    procedure edTextBoxEnter(Sender: TObject);
    procedure VinesBibleDictionary1Click(Sender: TObject);
    procedure btnPreviousVerseClick(Sender: TObject);
    procedure btnNextVerseClick(Sender: TObject);
    procedure NewSearchWindow1Click(Sender: TObject);
    private
        curedit: TRichEdit;
  public
    { Public declarations }
  end;

var
  SwordAppForm: TSwordAppForm;

implementation

uses SysUtils, Mapi, About, searchdlg;

{$R *.DFM}
procedure TSwordAppForm.FormCreate(Sender: TObject);
var
	s1: string;
begin
  Application.OnHint := ShowHint;

	vkCommonKey.Text := 'Genesis 1:1';
	while (vkCommonKey.Error = 0) do
	begin
		s1 := vkCommonKey.Text;
		SetLength(s1, (Length(s1) - 4));
		BookCB.Items.Add(s1);
    vkCommonKey.Book := vkCommonKey.Book + 1;
  end;
end;


procedure TSwordAppForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TSwordAppForm.Lookup(Sender: TObject);
var
  Buffer: PChar;
  s1: AnsiString;
  hkey: integer;
begin
	if ((StrToInt(CHBox.Text) = 0) or (StrToInt(VSBox.Text) = 0)) then
		vkCommonKey.AutoNormalize := false;

	vkCommonKey.Text       := BookCB.Text + ' ' + CHBox.Text + ':' + VSBox.Text;
        lblTextKeyText.Caption := vkCommonKey.Text;
	edTextBox.Display;
	edCommentBox.Text      := mrcMHC.Text;

        vkCommonKey.AutoNormalize := true;
end;

procedure TSwordAppForm.About(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TSwordAppForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TSwordAppForm.EastonsBibleDictionary1Click(Sender: TObject);
begin
		 mrldEastons.KeyText := Trim(curedit.SelText); { we use .KeyText instead of Key.Text because we don't care about accessing the actual key in Eastons (in fact, it may even not be allocated yet).  We just want to set Eastons with the text and let Eastons worry about allocating keys.}
		 edLDBox.Text := mrldEastons.Text;
		 lblLDKeyText.Caption := mrldEastons.KeyText;
		 lblLDTitle.Caption := mrldEastons.Description;
end;

procedure TSwordAppForm.edTextBoxEnter(Sender: TObject);
begin
		 curedit := TRichEdit(Sender);
end;

procedure TSwordAppForm.VinesBibleDictionary1Click(Sender: TObject);
begin
		 mrldVines.KeyText := Trim(curedit.SelText); { we use .KeyText instead of Key.Text because we don't care about accessing the actual key in Vines (in fact, it may even not be allocated yet).  We just want to set Vines with the text and let Vines worry about allocating keys.}
		 edLDBox.Text := mrldVines.Text;
		 lblLDKeyText.Caption := mrldVines.KeyText;
		 lblLDTitle.Caption := mrldVines.Description;
end;

procedure TSwordAppForm.btnPreviousVerseClick(Sender: TObject);
begin
  vkCommonKey.Dec;
	lblTextKeyText.Caption := vkCommonKey.Text;
	edTextBox.Display;
	edCommentBox.Text     := mrcMHC.Text;
end;

procedure TSwordAppForm.btnNextVerseClick(Sender: TObject);
begin
	vkCommonKey.Inc;
	lblTextKeyText.Caption := vkCommonKey.Text;
	edTextBox.Display;
	edCommentBox.Text     := mrcMHC.Text;
end;

procedure TSwordAppForm.NewSearchWindow1Click(Sender: TObject);
begin
	SearchForm.Show;
end;

end.

