# RPM spec file for Sympa.
# Generated by: sympa.spec.pl 

Name:     sympa
Version:  6.2.16
Release:  1%{?dist}
Summary(fr): Sympa est un gestionnaire de listes électroniques
Summary:  Sympa is a powerful multilingual List Manager
License:  GPL
Group:    System Environment/Daemons
URL:      http://www.sympa.org/
Source:   http://www.sympa.org/distribution/%{name}-%{version}.tar.gz

Requires: smtpdaemon
Requires: perl >= 5.008
Requires: perl(Archive::Zip) >= 1.05
#Requires: perl(AuthCAS) >= 1.4
Requires: perl(CGI) >= 3.51
#Requires: perl(CGI::Fast) >= 1.08
Requires: perl(Class::Singleton) >= 1.03
#Requires: perl(Crypt::CipherSaber) >= 0.50
#Requires: perl(Crypt::OpenSSL::X509) >= 1.800.1
#Requires: perl(Crypt::SMIME) >= 0.15
#Requires: perl(Data::Password) >= 1.07
Requires: perl(DateTime::Format::Mail) >= 0.28
Requires: perl(DateTime::TimeZone) >= 0.59
#Requires: perl(DBD::CSV)
#Requires: perl(DBD::mysql) >= 4.008
#Requires: perl(DBD::ODBC)
#Requires: perl(DBD::Oracle) >= 1.02
#Requires: perl(DBD::Pg) >= 2.00
#Requires: perl(DBD::SQLite) >= 1.31
#Requires: perl(DBD::Sybase) >= 0.90
Requires: perl(DBI) >= 1.48
Requires: perl(Digest::MD5) >= 2.00
Requires: perl(Encode)
#Requires: perl(Encode::Locale) >= 1.02
#Requires: perl(FCGI) >= 0.67
Requires: perl(File::Copy::Recursive) >= 0.36
Requires: perl(File::NFSLock)
Requires: perl(File::Path) >= 2.08
Requires: perl(HTML::FormatText)
Requires: perl(HTML::StripScripts::Parser) >= 1.03
Requires: perl(HTML::TreeBuilder)
Requires: perl(IO::File) >= 1.10
Requires: perl(IO::Scalar)
#Requires: perl(IO::Socket::SSL) >= 0.90
Requires: perl(List::Util::XS) >= 1.20
Requires: perl(Locale::Messages) >= 1.20
Requires: perl(LWP::UserAgent)
Requires: perl(Mail::Address) >= 1.70
#Requires: perl(Mail::DKIM::Verifier) >= 0.37
Requires: perl(MIME::Base64) >= 3.03
Requires: perl(MIME::Charset) >= 1.011.3
Requires: perl(MIME::EncWords) >= 1.014
Requires: perl(MIME::Lite::HTML) >= 1.23
Requires: perl(MIME::Tools) >= 5.423
Requires: perl(Net::CIDR) >= 0.16
#Requires: perl(Net::DNS) >= 0.65
#Requires: perl(Net::LDAP) >= 0.40
#Requires: perl(Net::SMTP)
#Requires: perl(SOAP::Lite) >= 0.712
Requires: perl(Sys::Syslog) >= 0.03
Requires: perl(Template) >= 2.21
Requires: perl(Term::ProgressBar) >= 2.09
Requires: perl(Text::LineFold) >= 2011.05
Requires: perl(Time::HiRes) >= 1.29
Requires: perl(Unicode::CaseFold) >= 0.02
Requires: perl(URI::Escape) >= 3.28
Requires: perl(XML::LibXML) >= 1.70
Requires: mhonarc >= 2.6.18
Requires: webserver
Requires(pre): /usr/sbin/useradd
Requires(pre): /usr/sbin/groupadd

BuildRoot: %{_tmppath}/%{name}-%{version}

%description
Sympa is scalable and highly customizable mailing list manager. It can cope
with big lists (200,000 subscribers) and comes with a complete (user and admin)
Web interface. It is internationalized, and supports the us, fr, de, es, it,
fi, and chinese locales. A scripting language allows you to extend the behavior
of commands. Sympa can be linked to an LDAP directory or an RDBMS to create
dynamic mailing lists. Sympa provides S/MIME-based authentication and
encryption.

%prep
%setup -q

%build
# Give install "-p" preserving mtime to prevent unexpected update of CSS.
# Give DESTDIR to cancel workaround in Makefile getting previous version.
%configure \
    --enable-fhs \
    --prefix=%{_prefix} \
    --docdir=%{_docdir}/%{name} \
    --libexecdir=%{_libexecdir}/sympa \
    --localstatedir=%{_localstatedir} \
    --sysconfdir=%{_sysconfdir}/sympa \
    --with-cgidir=%{_libexecdir}/sympa \
    --with-confdir=%{_sysconfdir}/sympa \
%if 0%{?use_systemd}
    --without-initdir \
    --with-unitsdir=%{_unitdir} \
%else
    --with-initdir=%{_initrddir} \
%endif
    --with-smrshdir=%{_sysconfdir}/smrsh \
    INSTALL_DATA='install -c -p -m 644'
make DESTDIR=%{buildroot}

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}
mv %{buildroot}%{_docdir}/%{name} __doc
cp -p AUTHORS ChangLog COPYING NEWS README __doc/

%check
%if 0%{?do_check}
make check
make authorcheck || true
%endif

%clean
rm -rf %{buildroot}

%pre
# Create "sympa" group if it does not exists
if ! getent group sympa > /dev/null 2>&1; then
  /usr/sbin/groupadd -r sympa
fi

# Create "sympa" user if it does not exists
if ! getent passwd sympa > /dev/null 2>&1; then
  /usr/sbin/useradd -r -g sympa \
      -d %{_localstatedir}/lib/sympa \
      -c "System User for Sympa" \
      -s "/bin/bash" \
      sympa
fi

%files
%defattr(-,root,root)
%doc __doc/*
%attr(-,sympa,sympa) %{_localstatedir}/*/sympa
%{_sbindir}/*
%dir %{_libexecdir}/sympa
%attr(-,sympa,sympa) %{_libexecdir}/sympa/bouncequeue
%attr(-,sympa,sympa) %{_libexecdir}/sympa/familyqueue
%attr(-,sympa,sympa) %{_libexecdir}/sympa/queue
%attr(-,root,sympa) %{_libexecdir}/sympa/sympa_newaliases-wrapper
%attr(-,sympa,sympa) %{_libexecdir}/sympa/sympa_smtpc
%attr(-,sympa,sympa) %{_libexecdir}/sympa/sympa_soap_server-wrapper.fcgi
%{_libexecdir}/sympa/sympa_soap_server.fcgi
%attr(-,sympa,sympa) %{_libexecdir}/sympa/wwsympa-wrapper.fcgi
%{_libexecdir}/sympa/wwsympa.fcgi
%{_mandir}/man1/*
%{_mandir}/man3/*
%{_mandir}/man5/*
%{_mandir}/man8/*
%{_datadir}/sympa
%{_datadir}/locale/*/*/*
%{_sysconfdir}/smrsh/*
%dir %attr(-,sympa,sympa) %{_sysconfdir}/sympa
%config(noreplace,missingok) %attr(-,sympa,sympa) %{_sysconfdir}/sympa/*
%if 0%{?use_systemd}
%{_unitdir}/sympa.service
%{_unitdir}/sympa-outgoing.service
%{_unitdir}/sympa-archive.service
%{_unitdir}/sympa-bounce.service
%{_unitdir}/sympa-task.service
%else
%{_initrddir}/sympa
%endif
