#========================================================================
#
# Xpdf Makefile
#
# Copyright 1996 Derek B. Noonburg
#
#========================================================================
INCLUDE=$(INCLUDE);../../../win32

!include <make/paths.mak>
!include <make/common.mak>
!include <make/library.mak>
!include <make/programs.mak>

CFLAGS = $(CFLAGS) -I. -I$(kpathsea_srcdir)

c_auto_h_dir = $(kpathsea_srcdir)

GOO = $(srcdir)\..\goo
LIBGOO = $(GOO)\$(objdir)\libGoo.lib

DEFS = $(DEFS) -I$(GOO) -I$(PNGLIBDIR)                \
	-DUSE_ZLIB -I$(ZLIBDIR)                       \
	-DHAVE_POPEN -DUSE_GZIP			      \
	-UKPSE_DLL				      \
	-DA4_PAPER -DJAPANESE_SUPPORT		      \
	-DCHINESE_GB_SUPPORT -DCHINESE_CNS_SUPPORT    \
	-DOPI_SUPPORT 

!IFDEF XPDF_DLL
LIBXPDF=$(objdir)\libxpdf.lib $(objdir)\libxpdf.dll
!ELSE
LIBXPDF=$(objdir)\libxpdf.lib
!ENDIF

LIBXPDF_OBJS = $(objdir)\Array.obj	\
	$(objdir)\Catalog.obj		\
	$(objdir)\Decrypt.obj		\
	$(objdir)\Dict.obj 		\
	$(objdir)\Error.obj 		\
	$(objdir)\FontEncoding.obj	\
	$(objdir)\FontFile.obj		\
	$(objdir)\FormWidget.obj  	\
	$(objdir)\Gfx.obj		\
	$(objdir)\GfxFont.obj		\
	$(objdir)\GfxState.obj		\
	$(objdir)\Lexer.obj		\
	$(objdir)\Link.obj		\
	$(objdir)\Object.obj		\
	$(objdir)\OutputDev.obj		\
	$(objdir)\PDFDoc.obj		\
	$(objdir)\Page.obj		\
	$(objdir)\Params.obj		\
	$(objdir)\Parser.obj		\
	$(objdir)\Stream.obj		\
	$(objdir)\XRef.obj

PDFTOTEXT_OBJS =  $(objdir)\TextOutputDev.obj \
	$(objdir)\pdftotext.obj

PDFTOPS_OBJS = $(objdir)\PSOutputDev.obj   \
	 $(objdir)\pdftops.obj 

PDFINFO_OBJS = $(objdir)\pdfinfo.obj 

PDFIMAGES_OBJS = $(objdir)\ImageOutputDev.obj $(objdir)\pdfimages.obj 

PDFTOPBM_OBJS = $(objdir)\PBMOutputDev.obj $(objdir)\pdftopbm.obj 

programs = $(objdir)\pdftops.exe $(objdir)\pdftotext.exe         \
	$(objdir)\pdfinfo.exe $(objdir)\pdfimages.exe                        \
#	$(objdir)\pdftopbm.exe

all: lib $(programs)

lib: $(objdir) $(LIBXPDF) # libpdftoepdf

libpdftoepdf: $(objdir) $(objdir)\libpdftoepdf.lib

$(objdir)\libpdftoepdf.lib: $(objdir) $(objdir)\pdftoepdf.obj $(LIBXPDF_OBJS) $(LIBGOO)
	$(archive_command) $(objdir)\pdftoepdf.obj $(LIBXPDF_OBJS) $(LIBGOO)

!IFDEF XPDF_DLL
DEFS= $(DEFS) -DXPDF_DLL

$(objdir)\libxpdf.lib: $(objdir) $(LIBXPDF_OBJS) $(LIBGOO) $(zlib) $(win32defdir)\libxpdf.def
	$(archive_command) /DEF:$(win32defdir)/libxpdf.def $(LIBXPDF_OBJS) $(LIBGOO) $(zlib)

$(objdir)\libxpdf.dll: $(objdir) $(LIBXPDF_OBJS) $(objdir)\libxpdf.lib  $(LIBGOO) $(objdir)\libxpdf.res
	$(dll_command) $(LIBXPDF_OBJS)  $(objdir)\libxpdf.exp $(objdir)\libxpdf.res $(LIBGOO) $(LIBS)

!ELSE

$(objdir)\libxpdf.lib: $(objdir) $(LIBXPDF_OBJS) $(LIBGOO) $(zlib)
	$(archive_command) $(LIBXPDF_OBJS) $(LIBGOO) $(zlib)

!ENDIF

$(LIBGOO):
	pushd $(GOO) & $(MAKE) $(common_makeflags) lib & popd

$(objdir)\pdftops.exe: $(objdir) $(PDFTOPS_OBJS) $(objdir)\libxpdf.lib
	$(link_command) /OUT:$@ $(PDFTOPS_OBJS) $(objdir)\libxpdf.lib $(LIBS)

$(objdir)\pdftotext.exe: $(objdir) $(PDFTOTEXT_OBJS) $(objdir)\libxpdf.lib
	$(link_command) /OUT:$@ $(PDFTOTEXT_OBJS) $(objdir)\libxpdf.lib $(LIBS)

$(objdir)\pdfinfo.exe: $(objdir) $(PDFINFO_OBJS) $(objdir)\libxpdf.lib
	$(link_command) /OUT:$@ $(PDFINFO_OBJS) $(objdir)\libxpdf.lib $(LIBS)

$(objdir)\pdftopbm.exe: $(objdir) $(PDFTOPBM_OBJS) $(objdir)\libxpdf.lib
	$(link_command) /OUT:$@ $(PDFTOPBM_OBJS) $(objdir)\libxpdf.lib $(LIBS)

$(objdir)\pdfimages.exe: $(objdir) $(PDFIMAGES_OBJS) $(objdir)\libxpdf.lib
	$(link_command) /OUT:$@ $(PDFIMAGES_OBJS) $(objdir)\libxpdf.lib $(LIBS)

$(objdir)\PSOutputDev.obj: PSOutputdev.cc
	$(compile) /TpPSOutputdev.cc

$(objdir)\pdftops.obj: pdftops.cc
	$(compile) /Tppdftops.cc

$(objdir)\TextOutputDev.obj: TextOutputDev.cc
	$(compile) /TpTextOutputDev.cc

$(objdir)\pdftotext.obj: pdftotext.cc
	$(compile) /Tppdftotext.cc

install:: all 
	$(mktexdir) $(toolsprefix)\include $(toolsprefix)\lib \
	$(toolsprefix)\bin $(bindir)
#	$(CP) epdf.h $(toolsprefix)\include
#	$(CP) $(objdir)\libxpdf.lib $(toolsprefix)\lib
	$(CP) $(objdir)\pdftops.exe $(bindir)
	$(CP) $(objdir)\pdftotext.exe $(bindir)
	$(CP) $(objdir)\pdfinfo.exe $(bindir)
#	$(CP) $(objdir)\pdftopbm.exe $(bindir)
	$(CP) $(objdir)\pdfimages.exe $(bindir)
!IFDEF XPDF_DLL
	$(CP) $(objdir)\libxpdf.dll $(toolsprefix)\bin
	$(CP) $(objdir)\libxpdf.dll $(bindir)
!ENDIF

!include <make/tkpathsea.mak>
!include <make/libsrul.mak>

all_subdirs = $(GOO)

!include <make/man.mak>
!include <make/clean.mak>

clean mostlyclean install::
	-@echo $(verbose) & for %%d in ($(all_subdirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(makeflags) $@ & popd

distclean extraclean maintainer-clean::
	-@echo $(verbose) & for %%i in ($(all_subdirs)) do \
		echo Entering %%i for $@ \
		& pushd %%i & $(MAKE)  $(makeflags) $@ & popd

mostlyclean clean::
	-@$(RM)  $(objdir)\libxpdf.lib  $(objdir)\libxpdf.dll

!include <make/version.mak>
!include <make/rdepend.mak>

!include "./depend.mak"

#
# Local Variables:
# mode: makefile
# End:
