#include <string.h>
#include <stdio.h>
#include "xdvi-config.h"
#include "xdvi.h"
#include "my-vsnprintf.h"

#ifndef HAVE_VSNPRINTF
/*------------------------------------------------------------
 *  my_vsnprintf - reduplication of glibc2.1 vsnprintf, use if
 *		   glibc is not available	
 * 
 *  Arguments:
 *	char *buf	- buffer to print <format> string into
 *	int len		- print only len characters of <format>
 *	char *format	- format string
 *	va_list argp	- variable argument list
 *
 *  Returns:
 *	 int size - number of characters that would have been
 *		    written if enough space had been available
 *		 
 *  Purpose:
 *	Do the `same' (ahem) as GNU's vsnprintf, but in a much
 *      less portable and much slower (but also much easier) manner:
 *	It prints the formatted string to a pipe and reads
 *	back at most len-1 characters, appending a NULL
 *	character.
 *------------------------------------------------------------*/

int
my_vsnprintf(buf, len, format, argp)
    char *buf;
    int len;
    char *format;
    va_list argp;
{
    int pipe_fd[2];
    FILE *fd;
    int size;
#ifdef DEBUG
    printf("=============my_vsnprintf called!\n");
#endif
    len--;	/* for the trailing '\0' */
    if (xpipe(pipe_fd) == -1) {
	perror("my_vsnprintf: pipe");
	exit(1);
    }
    if ((fd = fdopen(pipe_fd[1], "w")) == NULL) {
	perror("my_vsnprintf: fdopen");
	exit(1);
    }

    /*  setvbuf(fd, NULL, _IONBF, BUFSIZ); */
    /*
     * instead of setting fd to non-buffering, flush it explicitely:
     */
    size = vfprintf(fd, format, argp);
    fflush(fd);
    /*
     * correct len in case we wrote less than that
     * (for the following read):
     */
    if (size < len) {
	len = size;
    }
    read(pipe_fd[0], buf, len);
    /* null-terminate string */
    buf[len] = '\0';

    /* close file descriptors */
    fclose(fd);
    close(pipe_fd[0]);
    close(pipe_fd[1]);

    return size;
}

#endif /* HAVE_VSNPRINTF */
