<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup BASE
 * @module acl_show
 * @package acl
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('acl','show');
 loadlayout();

 /**
  * display  permissions
  */
 class acl_show extends layout {
   /**
    *
    */
   Function show($min,$max,$name) {
     global $lang;

     @reset ($this->obj->acl);
     while ( list ($i,$f) = @each ($this->obj->acl) ) {

       if ( ($f < $max) && ($f >= $min) ) {
         $pre = "&nbsp;";
         if ( $i == 0 ) {
           echo $pre . $lang['everybody'] ."<br>\n";
           continue;
         }

         $x = getObject($this->dbconn,$i);
         if ( $x->gettype() == "team" ) {
           $pre .= $lang['team'] ." ";
         }
         echo $pre . $x->getLink() ."<br>\n";
         unset($x);
       }
     }
     echo "&nbsp;";
   }
   /* ---------------------------------------------------------------------------
    *
    */
   Function info() {
     global $lang,$tutos;


     echo $this->DataTableStart();
     echo " <tr><th colspan=\"6\">";
     echo sprintf($lang['AclDetailI'],$lang[$this->obj->getType()] ." ". menulink($this->obj->getURL(),myentities($this->obj->getFullName())));
     echo "</th></tr>\n";

     echo "<tr valign=\"top\">\n";
     echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."</th>\n";
     echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLmodify'] ."</th>\n";
     echo " <th width=\"30%\" colspan=\"2\">". $lang['ACLread'] ."<br>". $lang['ACLmodify'] ."<br>".  $lang['ACLdelete'] ."</th>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <td valign=\"top\" colspan=\"2\" class=\"line1\" nowrap>\n";
     $this->show($tutos[seeok],$tutos[modok],"r");
     echo " </td>\n";
     echo " <td valign=\"top\" colspan=\"2\" class=\"line2\" nowrap>\n";
     $this->show($tutos[modok],$tutos[delok],"m");
     echo " </td>\n";
     echo " <td valign=\"top\" colspan=\"2\" class=\"line1\" nowrap>\n";
     $this->show($tutos[delok],99,"d");
     echo " </td>\n";
     echo "</tr>\n";

     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['AclDetail'];

     if ( ! isset($_GET['id']) ) {
       $msg .= "Missing ID";
       $this->stop = true;
       return;
     }
     $id = $_GET['id'];
     $this->obj = getObject($this->dbconn,$id);

     if ( $this->obj == -1) {
       $msg .= sprintf($lang['Err0040'],"Object");
       $this->stop = true;
     } else if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0023'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
   }
 }

 $l = new acl_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: acl_show.php,v 1.17 2002/11/05 19:57:45 gokohnert Exp $
    $Author: gokohnert $
-->
