<?php
/**
 * Copyright 2000 - 2003 by Gero Kohnert
 *
 *   CVS Info:  $Id: file_show.php,v 1.6.2.2 2003/07/14 17:49:52 gokohnert Exp $
 *   $Author: gokohnert $
 *
 * @modulegroup file
 * @module file_show
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','show');
 loadmodule('file');
 loadlayout();

 /**
  * show a file (info)
  */
 class file_show extends layout {
   /**
    * display the file as thumbnail
    */
   Function info_thumb() {
     global $tutos,$lang;

     if (strstr($_SERVER["HTTP_USER_AGENT"],"MSIE 5") || strstr($_SERVER["HTTP_USER_AGENT"],"MSIE 6") ) {
       Header("Expires:");
       Header("Cache-Control:");
       Header("Pragma:");
       Header("Content-Type: application/octet-stream");
       Header("Connection: close");
       Header("Content-Transfer-Encoding: binary");
     } else {
       if ( ($this->obj->filetype != "") && ($this->obj->version == $this->version) ) {
         Header("Content-type: ". $this->obj->filetype);
       } else {
         Header("Content-type: text/plain");
       }
       Header("Content-Disposition: attachment; filename=\"thumb_". $this->obj->filename ."\"");
     }
     Header("Content-Description: Upload from TUTOS" );
     $this->obj->thumbnail($this->version);
   }
   /**
    * display the file
    */
   Function info_download() {
     global $tutos,$lang;
     // see also
     // http://www.phpbuilder.com/forum/archives/1/2001/3/4/113046
     // http://ppewww.ph.gla.ac.uk/~flavell/www/content-type.html
    // http://msdn.microsoft.com/library/default.asp?url=/workshop/networking/moniker/overview/appendix_a.asp
     if (strstr($_SERVER["HTTP_USER_AGENT"],"MSIE 5") || strstr($_SERVER["HTTP_USER_AGENT"],"MSIE 6") ) {
       Header("Expires:");
       Header("Cache-Control:");
       Header("Pragma:");
       Header("Content-Type: application/octet-stream");
       Header("Connection: close");
       Header("Content-Transfer-Encoding: binary");
     } else {
       if ( ($this->obj->filetype != "") && ($this->obj->version == $this->version) ) {
         Header("Content-type: ". $this->obj->filetype);
       } else {
         Header("Content-type: text/plain");
       }
     }
     Header("Content-Disposition: attachment; filename=\"". $this->obj->filename ."\"");
     Header("Content-Description: Upload from TUTOS" );
     $this->obj->download($this->version);
   }
   /**
    * display the info
    */
   Function info() {
     global $tutos,$lang;

     if ( $this->format == "thumbnail" ) {
       $this->info_thumb();
       return;
     } else if ( $this->format == "show" ) {
       $this->obj->show($this->version);
       return;
     } else if ( $this->format == "download" ) {
       $this->info_download($this->version);
       return;
     }

     echo $this->DataTableStart();
     echo "<tr><th colspan=\"4\">". $lang['FileDetail'] ."</th></tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileNameDoc']);
     echo $this->showdata($this->obj->name,1);
     echo $this->showfield($lang['FileVersion']);
     echo $this->showdata($this->obj->version,1);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileName']);
     echo $this->showdata($this->obj->filename,3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['created']);
     echo $this->showdata($this->obj->creation->getDateTime(),3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileAuthor']);
     echo $this->showdata($this->obj->author->getLink(),3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileReference']);
     if ($this->obj->ref != -1 ) {
       echo $this->showdata($lang[$this->obj->ref->gettype()] ." ". $this->obj->getRefLink(),3);
     } else {
       echo $this->showdata($lang['HistoryDeleted'] ." (". $this->obj->link_id .")",3);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileSize']);
     echo $this->showdata($this->obj->filesize ." Bytes",3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['FileType']);
     echo $this->showdata($this->obj->filetype,3);
     echo "</tr>\n";

     if ( $this->obj->locked > 0 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['FileLockedBy']);
       echo $this->showdata($this->obj->locker->getMailLink(),3);
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfield($lang['FileMore']);
     echo " <td colspan=\"3\" class=\"pre\"><font size=\"-1\"><pre>\n";
     $this->obj->moreinfo();
     echo " </pre></font></td>\n";
     echo "</tr>\n";

     $this->obj->make_vlist();
     @reset($this->obj->vlist);
     if (count($this->obj->vlist) > 0 ) {
       echo "<tr>\n";
       echo $this->showfield($lang['FileOldVersion']);
       echo " <td colspan=\"3\"><font size=\"-1\">\n";
       while ( list ($i,$v) = @each ($this->obj->vlist) ) {
         if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
           echo makelink("file/file_show.php?id=". $this->obj->id ."&format=download&version=".$v, $lang['FileDownload'] ." ". $lang['FileVersion'] ." ". $i , $v);
         } else {
           echo $lang['FileVersion'] ." ". $i ."\n";
         }
         echo "<br>\n";
       }
       echo "</font></td>\n";
       echo "</tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfield($lang['FileLog']);
     echo " <td colspan=\"3\" class=\"pre\"><font size=\"-1\"><pre>\n";
     echo $this->obj->logtxt;
     echo " </pre></font></td>\n";
     echo "</tr>\n";

     # References to modules
     show_module_infolists($this->user,$this->obj,4,$this->format);
     echo $this->obj->getHistoryLink(4);
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->name = $lang['FileDetail'];
     $this->obj = new tutos_file($this->dbconn);

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name .= ": ".$this->obj->getFullName();
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->obj->read_reference();
     }
     if ( ! isset($_GET['version']) ) {
       $this->version = $this->obj->version;
     } else {
       $this->version = $_GET['version'] ;
     }
     # menu
     $m = tutos_file::getSelectLink($this->user,$lang['Search']);
	 $m[category][] = "obj";

     $this->addmenu($m);
     add_module_addlinks($this,$this->obj);


     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "file/file_new.php?id=". $this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['FileModifyI'],$this->obj->getFullName()),
                   category => array("file","mod","obj")
                 );
       $this->addMenu($x);
     }
     if ( ($this->obj->id > 0) && $this->obj->see_ok() ) {
       $x = array( url => $this->obj->getUrl() ."&amp;format=show",
                   text => $lang['FileShow'],
                   info => sprintf($lang['FileShowI'],$this->obj->getFullName()),
                   category => array("file","view")
                 );
       $this->addMenu($x);
       $x = array( url => $this->obj->getUrl() ."&amp;format=download",
                   text => $lang['FileDownload'],
                   info => sprintf($lang['FileDownloadI'],$this->obj->getFullName()),
                   category => array("file","view")
                 );
       $this->addMenu($x);
     }

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }

 $l = new file_show($current_user);
 $l->display();
 $dbconn->Close();
?>
