<?php
/**
 * Copyright 2000 - 2003 by Gero Kohnert
 *
 * @modulegroup note
 * @module note_new
 * @package note
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("note","new");
 loadmodule("note");
 loadlayout();

 /**
  * change/modify a note
  */
 class note_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"notenew\" action=\"note_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"6\">";
     if ( isset ($this->obj->id) && ( $this->obj->id != -1 ) ) {
       echo $lang['NoteMod'];
       echo " </th></tr>\n";
       echo "<tr>\n";
       $this->addhidden("id",$this->obj->id);
       echo " <td colspan=\"5\">". sprintf ($lang['ProdCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td align=\"right\">". acl_link($this->obj) ."</td>";
       echo "</tr>\n";
     } else {
       echo $lang['NoteCreation'];
       echo " </th></tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['NoteName'],1,"name");
     echo " <td colspan=\"5\"><input id=\"name\" size=\"". min($table['note']['name'][size],40) ."\" maxlength=\"". $table['note']['name'][size] ."\" name=\"name\" value=\"". $this->obj->name ."\"></td>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfieldc($lang['NoteReference']);
     echo " <td colspan=\"5\">". $lang[$this->obj->ref->getType()] ." ". $this->obj->getRefLink() ."</td>\n";
     $this->addhidden("link_id",$this->obj->link_id);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['NoteDescription'],1,"note");
     echo " <td colspan=\"5\"><textarea id=\"note\"  rows=\"20\" cols=\"80\" name=\"note\">". $this->obj->note ."</textarea></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['NoteRemember'],0,"remember_d");
     echo " <td colspan=\"5\">\n";
     $this->obj->remember->EnterDate("remember",1);
     echo " </td>\n";
     echo "</tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,6);

     echo "<tr>\n";
     if ( isset($this->obj->id) && ($this->obj->id != -1) ) {
       submit_reset(0,1,2,1,2,0);
     } else {
       submit_reset(0,-1,2,1,2,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("notenew.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new note($this->dbconn);
     if ( isset($_GET['id']) ){
       $this->obj->read($_GET['id']);
       $this->name = $lang['NoteMod'];
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       }
     } else {
       $this->name = $lang['NoteCreation'];
     }
     if ( isset($_GET['link_id']) ){
       $this->obj->link_id = $_GET['link_id'];
     }
     if ( isset($_GET['note']) ){
       $this->obj->note = StripSlashes($_GET['note']);
     }
     if ( isset($_GET['name']) ){
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['remember']) ) {
       $this->obj->remember->setDateTime($_GET['remember']);
     }
     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     $this->obj->read_reference();

     if (($this->obj->id < 0) && !$this->user->feature_ok(usenotes,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if (! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     # menu
     $x = note::getSelectLink($this->user,$lang['Search']);
	 $x[category][] = "obj";
     $this->addmenu($x);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "note/note_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => $lang['NoteDelete'],
                   confirm => true,
                   category => array("note","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new note_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: note_new.php,v 1.18.2.2 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->