<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_new
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';
 include_once 'bug.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","new");
 loadlayout();
 /**
  * display a form to enter/modify a task
  */
 class task_new extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$table;

     echo "<form name=\"taskadd\" action=\"task_ins.php\" method=\"POST\">\n";

     echo $this->DataTableStart();
     echo " <tr><th colspan=\"4\">";
     if ( $this->obj->id != -1 ) {
       echo sprintf($lang['TaskModify'],$this->obj->name);
     } else {
       echo $lang['TaskCreate'];
     }
     echo "</th></tr>\n";
     if ( $this->obj->id > 0 ) {
       $this->addHidden("id", $this->obj->id );
       echo " <tr>\n";
       echo "  <td colspan=\"3\">". sprintf ($lang['TaskCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo "  <td align=\"right\" colspan=\"1\">". acl_link($this->obj) ."</td>\n";
       echo " </tr>\n";
     }
     echo " <tr>\n";
     echo $this->showfieldc($lang['TaskName'],1,"name");
     echo "  <td><input id=\"name\" size=\"". min($table['task']['name'][size],40) ."\" maxlength=\"". $table['task']['name'][size] ."\" name=\"name\" value=\"". $this->obj->name ."\"></td>\n";
     echo $this->showfieldc($lang['TaskState'],0,"state");
     echo "  <td>\n";
     echo "   <select id=\"state\" name=\"state\">\n";
   
     @reset($lang['TaskStates']);
     while ( list ($f,$i) = @each ($lang['TaskStates']) ) {
       echo "    <option value=\"". $f ."\"". ($f == $this->obj->state ? " selected" : "")  .">". $lang['TaskStates'][$f] ."</option>\n";
     }
     echo "   </select>\n";
     echo "  </td>\n";
     echo " </tr>\n";

     # Show no reference for personal tasks
     if ( ($this->obj->parent != -1) && ($this->obj->parent->gettype() != "address") ) {
       echo " <tr>\n";
       echo $this->showfieldc($lang['TaskSubTask']);
       echo "  <td colspan=\"3\">";
#       echo  $this->obj->parent->getLink();
       echo "<select name=\"pid\">\n";
       foreach ($this->obj->plist as $i => $f) {
         echo "<option value=\"". $i ."\"". ($i == $this->obj->parent->id ? " selected>* ":">") . $lang[$f->getType()] .": ". $f->getFullName() ."</option>\n";
       }
       echo "</select>\n";
       echo "  </td>\n";
       echo " </tr>\n";
     } else {
       $this->addHidden("pid", $this->obj->p_id );
     }

     echo " <tr>\n";
     echo $this->showfield($lang['TaskDesc'],1,"desc");
     echo "  <td colspan=\"3\"><textarea id=\"desc\" rows=\"10\" cols=\"80\" name=\"desc\">". $this->obj->desc ."</textarea></td>\n";
     echo " </tr>\n";

     # task workers on 3 rows
     echo " <tr>\n";
     echo "  <td valign=\"top\" rowspan=\"3\" class=\"desc\">". $lang['TaskWorker'] ."<font color=\"red\">(*)</font></td>\n";
     echo "  <td rowspan=\"3\" valign=\"top\">". $this->user->askPeople("worker[]",$this->obj->worker,1) ."</td>\n";

     # on the right, task volumes, 3 rows

     # The planned volume is editable only when in PRE state
     echo $this->showfieldc($lang['TaskVolumeFull'],0,"volume");
     if( $this->obj->state == TASK_PRE ) {
       echo "  <td><input id=\"volume\" size=\"5\" name=\"volume\" value=\"". $this->obj->volume ."\">&nbsp;" . $lang['hours'] ."</td>\n";
     }
     else {
       $this->addHidden("volume", $this->obj->volume);
       echo "  <td> ". $this->obj->volume ."&nbsp;". $lang['hours'] ."</td>";
     }
     echo " </tr>\n";

     # The volume done
     echo " <tr>\n";
     echo $this->showfieldc($lang['TaskVolumeDone'],0,"volume_done");
     # The creator should also be authorized to modify the task volume done
     if ( $this->user->id == $this->obj->creator->id ||
	 array_key_exists((int)$this->user->id, $this->obj->worker)) { 
       echo "  <td><input id=\"volume_done\" size=\"5\" name=\"volume_done\" value=\"". $this->obj->volume_done ."\">&nbsp;". $lang['hours'] ."</td>\n";
       echo " </tr>\n";
     } else {
       $this->addHidden("volume_done", $this->obj->volume_done );
       echo "  <td>". $this->obj->volume_done ."&nbsp;". $lang['hours'] ."</td>\n";
       echo " </tr>\n";
     }

     # And the volume todo, allowing to adjust task planned volume of
     # a running task
     if ( $this->obj->state != TASK_PRE &&
	  ($this->user->id == $this->obj->creator->id ||
	   array_key_exists((int)$this->user->id, $this->obj->worker))) {

       # If the volume todo has never been set, calculate it
       if( $this->obj->volume_todo == -1 )
	 $this->obj->volume_todo =
	   $this->obj->volume - $this->obj->volume_done;
       
       echo " <tr>\n";
       echo $this->showfieldc($lang['TaskVolumeTodo'],0,"volume_todo");
       echo "  <td><input id=\"volume\" size=\"5\" name=\"volume_todo\" value=\"". $this->obj->volume_todo ."\">&nbsp;" . $lang['hours'] ."</td>\n";
       echo " </tr>\n";
     } else {
       $this->addHidden("volume_todo", -1 );
       echo " <tr><td colspan=\"4\">&nbsp;</tr>\n";
     }


     # Now task dates
     echo " <tr>\n";
     echo $this->showfieldc($lang['TaskS_Start'],0,"s_start_d");
     echo "  <td colspan=\"3\">\n";
     $this->obj->s_start->EnterDate("s_start");
     echo "</td>\n";
     echo " </tr>\n";

     echo " <tr>\n";
     echo $this->showfieldc($lang['TaskS_End'],0,"s_end_d");
     echo "  <td colspan=\"3\">\n";
     $this->obj->s_end->EnterDate("s_end");
     echo "</td>\n";
     echo " </tr>\n";

     # References to modules
     module_addforms($this->user,$this->obj,4);

     if ( ($this->obj->mod_ok()) || ($this->obj->id == -1) ) {
       echo "<tr>\n";
       if ( $this->obj->id > 0 ) {
         submit_reset(0,1,1,1,1,0);
       } else {
         submit_reset(0,-1,1,1,1,0);
       }
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("taskadd.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new task($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       $this->name = sprintf($lang['TaskModify'],$this->obj->getFullName());
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       }
     } else {
       $this->name = $lang['TaskCreate'];
     }
     if ( ($this->obj->id < 0) && !$this->user->feature_ok(usetaskmanagement,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true ;
     }

     if ( isset($_GET['name']) ) {
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['desc']) ) {
       $this->obj->desc = StripSlashes($_GET['desc']);
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['volume']) ) {
       $this->obj->volume = StripSlashes($_GET['volume']);
     }
     if ( isset($_GET['volume_done']) ) {
       $this->obj->volume_done = StripSlashes($_GET['volume_done']);
     }
     if ( isset($_GET['volume_todo']) ) {
       $this->obj->volume_todo = StripSlashes($_GET['volume_todo']);
     }
     if ( isset($_GET['worker']) ) {
       foreach ($_GET['worker'] as $i => $f) {
         $this->obj->worker[$f] = new tutos_address($this->dbconn);
         $this->obj->worker[$f]->read($f);
       }
     }
     if ( isset($_GET['s_start']) ) {
       $this->obj->s_start->setDateTime($_GET['s_start']);
     }
     if ( isset($_GET['s_end']) ) {
       $this->obj->s_end->setDateTime($_GET['s_end']);
     }
     if ( isset($_GET['pid']) ) {
       $this->obj->parent = GetObject($this->dbconn,$_GET['pid']);
       if ( $this->obj->parent != -1 ) {
         $this->obj->p_id = $this->obj->parent->id;
       }
     }
     $this->obj->read_relations();
     if ( $this->obj->p_id < 0 ) {
       $msg .= "Sorry we need a parent object <br>";
       $this->stop = true ;
     }
     # menu
     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "task_del.php?id=".$this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['TaskDelete'],$this->obj->getFullname()),
                   category => array("task","del","obj"),
                   confirm => true
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new task_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: task_new.php,v 1.48.2.3 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->