#!/usr/local/bin/perl
# save_auth.cgi
# Save, create or delete an authorized key

require './ssh-lib.pl';
&ReadParse();
@auths = &list_auths();
$auth = $auths[$in{'idx'}] if (!$in{'new'});

if ($in{'delete'}) {
	# Just delete this authorized key
	&delete_auth($auth);
	}
else {
	# Validate inputs
	&error_setup($text{'auth_err'});
	$in{'name'} =~ /^\S+$/ || &error($text{'auth_ename'});
	$auth->{'name'} = $in{'name'};
	$in{'bits'} =~ /^\d+$/ || &error($text{'auth_ebits'});
	$auth->{'bits'} = $in{'bits'};
	$in{'exp'} =~ /^\d+$/ || &error($text{'auth_eexp'});
	$auth->{'exp'} = $in{'exp'};
	$in{'key'} =~ s/\s//g;
	$in{'key'} =~ /^\d+$/ || &error($text{'auth_ekey'});
	$auth->{'key'} = $in{'key'};

	# Validate option inputs
	&parse_options($auth->{'opts'}, \%opts);
	if ($in{'from_def'}) {
		delete($opts{'from'});
		}
	else {
		$opts{'from'} = [ join(",", split(/\s+/, $in{'from'})) ];
		}
	if ($in{'command'}) {
		$opts{'command'} = [ $in{'command'} ];
		}
	else {
		delete($opts{'command'});
		}
	if ($in{'noport'}) { $opts{'no-port-forwarding'} = [ undef ]; }
	else { delete($opts{'no-port-forwarding'}); }
	if ($in{'nox11'}) { $opts{'no-x11-forwarding'} = [ undef ]; }
	else { delete($opts{'no-x11-forwarding'}); }
	if ($in{'noagent'}) { $opts{'no-agent-forwarding'} = [ undef ]; }
	else { delete($opts{'no-agent-forwarding'}); }
	if ($in{'nopty'}) { $opts{'no-pty'} = [ undef ]; }
	else { delete($opts{'no-pty'}); }
	$auth->{'opts'} = &join_options(\%opts);

	# Create or save the authorized key
	if ($in{'new'}) {
		&create_auth($auth);
		}
	else {
		&modify_auth($auth);
		}
	}
&redirect("list_auths.cgi");

