
/* 
 * Lynx-like key binding.
 *
 * modified from original keybind.c by Keisuke Hashimoto
 * <hasimoto@shimada.nuee.nagoya-u.ac.jp>
 * http://www.shimada.nuee.nagoya-u.ac.jp/~hasimoto/
 *
 * further modification by Akinori Ito
 *
 * Date: Tue, 23 Feb 1999 13:14:44 +0900
 */

#include "fm.h"

static KeyTabItem w3mDefaultFuncKeyTab[] = {
  K_SET_FUNC(K_GEN(0, 0x00), FUNCNAME__mark),
  K_SET_FUNC(K_GEN(0, 0x01), FUNCNAME_goLineF),
  K_SET_FUNC(K_GEN(0, 0x02), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, 0x05), FUNCNAME_goLineL),
  K_SET_FUNC(K_GEN(0, 0x06), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, 0x07), FUNCNAME_curlno),
  K_SET_FUNC(K_GEN(0, 0x08), FUNCNAME_ldHist),
  K_SET_FUNC(K_GEN(0, 0x09), FUNCNAME_nextA),
  K_SET_FUNC(K_GEN(0, 0x0A), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, 0x0B), FUNCNAME_cooLst),
  K_SET_FUNC(K_GEN(0, 0x0C), FUNCNAME_rdrwSc),
  K_SET_FUNC(K_GEN(0, 0x0D), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, 0x0E), FUNCNAME_nextA),
  K_SET_FUNC(K_GEN(0, 0x10), FUNCNAME_prevA),
  K_SET_FUNC(K_GEN(0, 0x12), FUNCNAME_reload),
  K_SET_FUNC(K_GEN(0, 0x13), FUNCNAME_srchfor),
  K_SET_FUNC(K_GEN(0, 0x16), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, 0x17), FUNCNAME_rdrwSc),
  K_SET_FUNC(K_GEN(0, 0x1A), FUNCNAME_susp),
  K_SET_FUNC(K_GEN(0, 0x1B), FUNCNAME_escmap),
  K_SET_FUNC(K_GEN(0, 0x20), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, 0x21), FUNCNAME_execsh),
  K_SET_FUNC(K_GEN(0, 0x22), FUNCNAME_reMark),
  K_SET_FUNC(K_GEN(0, 0x23), FUNCNAME_pipesh),
  K_SET_FUNC(K_GEN(0, 0x24), FUNCNAME_linend),
  K_SET_FUNC(K_GEN(0, 0x2B), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, 0x2D), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, 0x2F), FUNCNAME_srchfor),
  K_SET_FUNC(K_GEN(0, 0x3A), FUNCNAME_chkURL),
  K_SET_FUNC(K_GEN(0, 0x3C), FUNCNAME_shiftl),
  K_SET_FUNC(K_GEN(0, 0x3D), FUNCNAME_pginfo),
  K_SET_FUNC(K_GEN(0, 0x3E), FUNCNAME_shiftr),
  K_SET_FUNC(K_GEN(0, 0x3F), FUNCNAME_ldhelp),
  K_SET_FUNC(K_GEN(0, 0x40), FUNCNAME_readsh),
  K_SET_FUNC(K_GEN(0, 0x42), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, 0x45), FUNCNAME_editBf),
  K_SET_FUNC(K_GEN(0, 0x46), FUNCNAME_rFrame),
  K_SET_FUNC(K_GEN(0, 0x47), FUNCNAME_goLine),
  K_SET_FUNC(K_GEN(0, 0x48), FUNCNAME_ldhelp),
  K_SET_FUNC(K_GEN(0, 0x49), FUNCNAME_followI),
  K_SET_FUNC(K_GEN(0, 0x4A), FUNCNAME_lup1),
  K_SET_FUNC(K_GEN(0, 0x4B), FUNCNAME_ldown1),
  K_SET_FUNC(K_GEN(0, 0x4D), FUNCNAME_extbrz),
  K_SET_FUNC(K_GEN(0, 0x4E), FUNCNAME_nextMk),
  K_SET_FUNC(K_GEN(0, 0x50), FUNCNAME_prevMk),
  K_SET_FUNC(K_GEN(0, 0x51), FUNCNAME_quitfm),
  K_SET_FUNC(K_GEN(0, 0x52), FUNCNAME_reload),
  K_SET_FUNC(K_GEN(0, 0x53), FUNCNAME_svBuf),
  K_SET_FUNC(K_GEN(0, 0x55), FUNCNAME_goURL),
  K_SET_FUNC(K_GEN(0, 0x56), FUNCNAME_ldfile),
  K_SET_FUNC(K_GEN(0, 0x5A), FUNCNAME_ctrCsrH),
  K_SET_FUNC(K_GEN(0, 0x5C), FUNCNAME_vwSrc),
  K_SET_FUNC(K_GEN(0, 0x5E), FUNCNAME_linbeg),
  K_SET_FUNC(K_GEN(0, 0x61), FUNCNAME_adBmark),
  K_SET_FUNC(K_GEN(0, 0x62), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, 0x63), FUNCNAME_curURL),
  K_SET_FUNC(K_GEN(0, 0x64), FUNCNAME_svA),
  K_SET_FUNC(K_GEN(0, 0x67), FUNCNAME_goURL),
  K_SET_FUNC(K_GEN(0, 0x68), FUNCNAME_movL),
  K_SET_FUNC(K_GEN(0, 0x69), FUNCNAME_peekIMG),
  K_SET_FUNC(K_GEN(0, 0x6A), FUNCNAME_movD),
  K_SET_FUNC(K_GEN(0, 0x6B), FUNCNAME_movU),
  K_SET_FUNC(K_GEN(0, 0x6C), FUNCNAME_movR),
  K_SET_FUNC(K_GEN(0, 0x6E), FUNCNAME_srchnxt),
  K_SET_FUNC(K_GEN(0, 0x6F), FUNCNAME_ldOpt),
  K_SET_FUNC(K_GEN(0, 0x70), FUNCNAME_svBuf),
  K_SET_FUNC(K_GEN(0, 0x71), FUNCNAME_qquitfm),
  K_SET_FUNC(K_GEN(0, 0x73), FUNCNAME_selMn),
  K_SET_FUNC(K_GEN(0, 0x75), FUNCNAME_peekURL),
  K_SET_FUNC(K_GEN(0, 0x76), FUNCNAME_ldBmark),
  K_SET_FUNC(K_GEN(0, 0x77), FUNCNAME_wrapToggle),
  K_SET_FUNC(K_GEN(0, 0x7A), FUNCNAME_ctrCsrV),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x09), FUNCNAME_prevA),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x0A), FUNCNAME_svA),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x0D), FUNCNAME_svA),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x3A), FUNCNAME_chkNMID),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x49), FUNCNAME_svI),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x4D), FUNCNAME_linkbrz),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x4F), FUNCNAME_escbmap),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x5B), FUNCNAME_escbmap),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x61), FUNCNAME_adBmark),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x62), FUNCNAME_ldBmark),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x65), FUNCNAME_editScr),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x73), FUNCNAME_svSrc),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x75), FUNCNAME_gorURL),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x76), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, K_ESC | 0x78), FUNCNAME_callfunc),
  K_SET_FUNC(K_GEN(0, K_UP), FUNCNAME_prevA),
  K_SET_FUNC(K_GEN(0, K_DOWN), FUNCNAME_nextA),
  K_SET_FUNC(K_GEN(0, K_RIGHT), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_LEFT), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_XTERM_MOUSE), FUNCNAME_mouse),
  K_SET_FUNC(K_GEN(0, K_PAD_HOME), FUNCNAME_goLineF),
  K_SET_FUNC(K_GEN(0, K_PAD_INS), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_PAD_END), FUNCNAME_goLineL),
  K_SET_FUNC(K_GEN(0, K_PAD_PGUP), FUNCNAME_pgBack),
  K_SET_FUNC(K_GEN(0, K_PAD_PGDN), FUNCNAME_pgFore),
  K_SET_FUNC(K_GEN(0, K_PAD_HELP), FUNCNAME_mainMn),
#ifdef USE_MOUSE
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN1_DOWN), FUNCNAME_gotoXY),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN2_DOWN), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN3_DOWN), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN4_DOWN), FUNCNAME_ldown1),
  K_SET_FUNC(K_GEN(0, K_MOUSE(CLICK) + MOUSE_BTN5_DOWN), FUNCNAME_lup1),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DCLICK) + MOUSE_BTN1_DOWN), FUNCNAME_followA),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DCLICK) + MOUSE_BTN2_DOWN), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DCLICK) + MOUSE_BTN3_DOWN), FUNCNAME_mainMn),
  /* K_SET_FUNC(K_GEN(0, K_MOUSE(DRAG) + MOUSE_BTN1_DOWN), FUNCNAME_scrollXY), */
  /* This binding is needless (or even halmfull) once MOUSE-MOVE-n support is included */
  K_SET_FUNC(K_GEN(0, K_MOUSE(DRAG) + MOUSE_BTN2_DOWN), FUNCNAME_backBf),
  K_SET_FUNC(K_GEN(0, K_MOUSE(DRAG) + MOUSE_BTN3_DOWN), FUNCNAME_mainMn),
  K_SET_FUNC(K_GEN(0, K_MOUSE(MOVE) + MOUSE_BTN1_DOWN), FUNCNAME_scrollXY),
#endif
};

KeyTabList w3mDefaultFuncKeyTabList = {
  NULL,
  w3mDefaultFuncKeyTab,
  sizeof(w3mDefaultFuncKeyTab) / sizeof(w3mDefaultFuncKeyTab[0]),
  sizeof(w3mDefaultFuncKeyTab) / sizeof(w3mDefaultFuncKeyTab[0]),
};
