/*
 * Win32 definitions for Windows NT
 *
 * Copyright 1996 Alexandre Julliard
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __WINE_NTSTATUS_H
#define __WINE_NTSTATUS_H

#ifndef WIN32_NO_STATUS

/*
 * Exception codes
 */

#define STATUS_SUCCESS                   0x00000000
#define STATUS_SEVERITY_SUCCESS          0x00000000
#define STATUS_SEVERITY_INFORMATIONAL    0x00000001
#define STATUS_SEVERITY_WARNING          0x00000002
#define STATUS_SEVERITY_ERROR            0x00000003

#define STATUS_WAIT_0                    0x00000000
#define STATUS_WAIT_1                    0x00000001
#define STATUS_WAIT_2                    0x00000002
#define STATUS_WAIT_3                    0x00000003
#define STATUS_WAIT_63                   0x0000003f
#define STATUS_ABANDONED                 0x00000080
#define STATUS_ABANDONED_WAIT_0          0x00000080
#define STATUS_ABANDONED_WAIT_63         0x000000BF
#define STATUS_USER_APC                  0x000000C0
#define STATUS_KERNEL_APC                0x00000100
#define STATUS_ALERTED                   0x00000101
#define STATUS_TIMEOUT                   0x00000102
#define STATUS_PENDING                   0x00000103
#define STATUS_REPARSE                   0x00000104
#define STATUS_MORE_ENTRIES              0x00000105
#define STATUS_NOT_ALL_ASSIGNED          0x00000106
#define STATUS_SOME_NOT_MAPPED           0x00000107
#define STATUS_OPLOCK_BREAK_IN_PROGRESS  0x00000108
#define STATUS_VOLUME_MOUNTED            0x00000109
#define STATUS_RXACT_COMMITTED           0x0000010A
#define STATUS_NOTIFY_CLEANUP            0x0000010B
#define STATUS_NOTIFY_ENUM_DIR           0x0000010C
#define STATUS_NO_QUOTAS_FOR_ACCOUNT     0x0000010D
#define STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED 0x0000010E
#define STATUS_PAGE_FAULT_TRANSITION     0x00000110
#define STATUS_PAGE_FAULT_DEMAND_ZERO    0x00000111
#define STATUS_PAGE_FAULT_COPY_ON_WRITE  0x00000112
#define STATUS_PAGE_FAULT_GUARD_PAGE     0x00000113
#define STATUS_PAGE_FAULT_PAGING_FILE    0x00000114
#define STATUS_CACHE_PAGE_LOCKED         0x00000115
#define STATUS_CRASH_DUMP                0x00000116
#define STATUS_BUFFER_ALL_ZEROS          0x00000117
#define STATUS_REPARSE_OBJECT            0x00000118
#define STATUS_RESOURCE_REQUIREMENTS_CHANGED 0x00000119
#define STATUS_TRANSLATION_COMPLETE      0x00000120
#define STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY  0x00000121
#define STATUS_NOTHING_TO_TERMINATE      0x00000122
#define STATUS_PROCESS_NOT_IN_JOB        0x00000123
#define STATUS_PROCESS_IN_JOB            0x00000124
#define STATUS_VOLSNAP_HIBERNATE_READY   0x00000125
#define STATUS_FSFILTER_OP_COMPLETED_SUCCESSFULLY 0x00000126

#define STATUS_OBJECT_NAME_EXISTS        0x40000000
#define STATUS_THREAD_WAS_SUSPENDED      0x40000001
#define STATUS_WORKING_SET_LIMIT_RANGE   0x40000002
#define STATUS_IMAGE_NOT_AT_BASE         0x40000003
#define STATUS_RXACT_STATE_CREATED       0x40000004
#define STATUS_SEGMENT_NOTIFICATION      0x40000005
#define STATUS_LOCAL_USER_SESSION_KEY    0x40000006
#define STATUS_BAD_CURRENT_DIRECTORY     0x40000007
#define STATUS_SERIAL_MORE_WRITES        0x40000008
#define STATUS_REGISTRY_RECOVERED        0x40000009
#define STATUS_FT_READ_RECOVERY_FROM_BACKUP 0x4000000A
#define STATUS_FT_WRITE_RECOVERY         0x4000000B
#define STATUS_SERIAL_COUNTER_TIMEOUT    0x4000000C
#define STATUS_NULL_LM_PASSWORD          0x4000000D
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH 0x4000000E
#define STATUS_RECEIVE_PARTIAL           0x4000000F
#define STATUS_RECEIVE_EXPEDITED         0x40000010
#define STATUS_RECEIVE_PARTIAL_EXPEDITED 0x40000011
#define STATUS_EVENT_DONE                0x40000012
#define STATUS_EVENT_PENDING             0x40000013
#define STATUS_CHECKING_FILE_SYSTEM      0x40000014
#define STATUS_FATAL_APP_EXIT            0x40000015
#define STATUS_PREDEFINED_HANDLE         0x40000016
#define STATUS_WAS_UNLOCKED              0x40000017
#define STATUS_SERVICE_NOTIFICATION      0x40000018
#define STATUS_WAS_LOCKED                0x40000019
#define STATUS_LOG_HARD_ERROR            0x4000001A
#define STATUS_ALREADY_WIN32             0x4000001B
#define STATUS_WX86_UNSIMULATE           0x4000001C
#define STATUS_WX86_CONTINUE             0x4000001D
#define STATUS_WX86_SINGLE_STEP          0x4000001E
#define STATUS_WX86_BREAKPOINT           0x4000001F
#define STATUS_WX86_EXCEPTION_CONTINUE   0x40000020
#define STATUS_WX86_EXCEPTION_LASTCHANCE 0x40000021
#define STATUS_WX86_EXCEPTION_CHAIN      0x40000022
#define STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE 0x40000023
#define STATUS_NO_YIELD_PERFORMED        0x40000024
#define STATUS_TIMER_RESUME_IGNORED      0x40000025
#define STATUS_ARBITRATION_UNHANDLED     0x40000026
#define STATUS_CARDBUS_NOT_SUPPORTED     0x40000027
#define STATUS_WX86_CREATEWX86TIB        0x40000028
#define STATUS_MP_PROCESSOR_MISMATCH     0x40000029
#define STATUS_HIBERNATED                0x4000002A
#define STATUS_RESUME_HIBERNATION        0x4000002B
#define STATUS_FIRMWARE_UPDATED          0x4000002C
#define STATUS_WAKE_SYSTEM               0x40000294
#define STATUS_DS_SHUTTING_DOWN          0x40000370

#define RPC_NT_UUID_LOCAL_ONLY           0x40020056
#define RPC_NT_SEND_INCOMPLETE           0x400200AF

#define STATUS_CTX_CDM_CONNECT           0x400A0004
#define STATUS_CTX_CDM_DISCONNECT        0x400A0005

#define STATUS_SXS_RELEASE_ACTIVATION_CONTEXT 0x4015000D

#define STATUS_GUARD_PAGE_VIOLATION      0x80000001
#define STATUS_DATATYPE_MISALIGNMENT     0x80000002
#define STATUS_BREAKPOINT                0x80000003
#define STATUS_SINGLE_STEP               0x80000004
#define STATUS_BUFFER_OVERFLOW           0x80000005
#define STATUS_NO_MORE_FILES             0x80000006
#define STATUS_WAKE_SYSTEM_DEBUGGER      0x80000007

#define STATUS_HANDLES_CLOSED            0x8000000A
#define STATUS_NO_INHERITANCE            0x8000000B
#define STATUS_GUID_SUBSTITUTION_MADE    0x8000000C
#define STATUS_PARTIAL_COPY              0x8000000D
#define STATUS_DEVICE_PAPER_EMPTY        0x8000000E
#define STATUS_DEVICE_POWERED_OFF        0x8000000F
#define STATUS_DEVICE_OFF_LINE           0x80000010
#define STATUS_DEVICE_BUSY               0x80000011
#define STATUS_NO_MORE_EAS               0x80000012
#define STATUS_INVALID_EA_NAME           0x80000013
#define STATUS_EA_LIST_INCONSISTENT      0x80000014
#define STATUS_INVALID_EA_FLAG           0x80000015
#define STATUS_VERIFY_REQUIRED           0x80000016
#define STATUS_EXTRANEOUS_INFORMATION    0x80000017
#define STATUS_RXACT_COMMIT_NECESSARY    0x80000018
#define STATUS_NO_MORE_ENTRIES           0x8000001A
#define STATUS_FILEMARK_DETECTED         0x8000001B
#define STATUS_MEDIA_CHANGED             0x8000001C
#define STATUS_BUS_RESET                 0x8000001D
#define STATUS_END_OF_MEDIA              0x8000001E
#define STATUS_BEGINNING_OF_MEDIA        0x8000001F
#define STATUS_MEDIA_CHECK               0x80000020
#define STATUS_SETMARK_DETECTED          0x80000021
#define STATUS_NO_DATA_DETECTED          0x80000022
#define STATUS_REDIRECTOR_HAS_OPEN_HANDLES 0x80000023
#define STATUS_SERVER_HAS_OPEN_HANDLES   0x80000024
#define STATUS_ALREADY_DISCONNECTED      0x80000025
#define STATUS_LONGJUMP                  0x80000026
#define STATUS_CLEANER_CARTRIDGE_INSTALLED      0x80000027
#define STATUS_PLUGPLAY_QUERY_VETOED     0x80000028
#define STATUS_UNWIND_CONSOLIDATE        0x80000029
#define STATUS_REGISTRY_HIVE_RECOVERED   0x8000002A
#define STATUS_DLL_MIGHT_BE_INSECURE     0x8000002B
#define STATUS_DLL_MIGHT_BE_INCOMPATIBLE 0x8000002C

#define STATUS_DEVICE_REQUIRES_CLEANING  0x80000288
#define STATUS_DEVICE_DOOR_OPEN          0x80000289

#define STATUS_CLUSTER_NODE_ALREADY_UP   0x80130001
#define STATUS_CLUSTER_NODE_ALREADY_DOWN 0x80130002
#define STATUS_CLUSTER_NETWORK_ALREADY_ONLINE   0x80130003
#define STATUS_CLUSTER_NETWORK_ALREADY_OFFLINE  0x80130004
#define STATUS_CLUSTER_NODE_ALREADY_MEMBER      0x80130005

#define STATUS_UNSUCCESSFUL              0xC0000001
#define STATUS_NOT_IMPLEMENTED           0xC0000002
#define STATUS_INVALID_INFO_CLASS        0xC0000003
#define STATUS_INFO_LENGTH_MISMATCH      0xC0000004
#define STATUS_ACCESS_VIOLATION          0xC0000005
#define STATUS_IN_PAGE_ERROR             0xC0000006
#define STATUS_PAGEFILE_QUOTA            0xC0000007
#define STATUS_INVALID_HANDLE            0xC0000008
#define STATUS_BAD_INITIAL_STACK         0xC0000009
#define STATUS_BAD_INITIAL_PC            0xC000000A
#define STATUS_INVALID_CID               0xC000000B
#define STATUS_TIMER_NOT_CANCELED        0xC000000C
#define STATUS_INVALID_PARAMETER         0xC000000D
#define STATUS_NO_SUCH_DEVICE            0xC000000E
#define STATUS_NO_SUCH_FILE              0xC000000F
#define STATUS_INVALID_DEVICE_REQUEST    0xC0000010
#define STATUS_END_OF_FILE               0xC0000011
#define STATUS_WRONG_VOLUME              0xC0000012
#define STATUS_NO_MEDIA_IN_DEVICE        0xC0000013
#define STATUS_UNRECOGNIZED_MEDIA        0xC0000014
#define STATUS_NONEXISTENT_SECTOR        0xC0000015
#define STATUS_MORE_PROCESSING_REQUIRED  0xC0000016
#define STATUS_NO_MEMORY                 0xC0000017
#define STATUS_CONFLICTING_ADDRESSES     0xC0000018
#define STATUS_NOT_MAPPED_VIEW           0xC0000019
#define STATUS_UNABLE_TO_FREE_VM         0xC000001A
#define STATUS_UNABLE_TO_DELETE_SECTION  0xC000001B
#define STATUS_INVALID_SYSTEM_SERVICE    0xC000001C
#define STATUS_ILLEGAL_INSTRUCTION       0xC000001D
#define STATUS_INVALID_LOCK_SEQUENCE     0xC000001E
#define STATUS_INVALID_VIEW_SIZE         0xC000001F
#define STATUS_INVALID_FILE_FOR_SECTION  0xC0000020
#define STATUS_ALREADY_COMMITTED         0xC0000021
#define STATUS_ACCESS_DENIED             0xC0000022
#define STATUS_BUFFER_TOO_SMALL          0xC0000023
#define STATUS_OBJECT_TYPE_MISMATCH      0xC0000024
#define STATUS_NONCONTINUABLE_EXCEPTION  0xC0000025
#define STATUS_INVALID_DISPOSITION       0xC0000026
#define STATUS_UNWIND                    0xC0000027
#define STATUS_BAD_STACK                 0xC0000028
#define STATUS_INVALID_UNWIND_TARGET     0xC0000029
#define STATUS_NOT_LOCKED                0xC000002A
#define STATUS_PARITY_ERROR              0xC000002B
#define STATUS_UNABLE_TO_DECOMMIT_VM     0xC000002C
#define STATUS_NOT_COMMITTED             0xC000002D
#define STATUS_INVALID_PORT_ATTRIBUTES   0xC000002E
#define STATUS_PORT_MESSAGE_TOO_LONG     0xC000002F
#define STATUS_INVALID_PARAMETER_MIX     0xC0000030
#define STATUS_INVALID_QUOTA_LOWER       0xC0000031
#define STATUS_DISK_CORRUPT_ERROR        0xC0000032
#define STATUS_OBJECT_NAME_INVALID       0xC0000033
#define STATUS_OBJECT_NAME_NOT_FOUND     0xC0000034
#define STATUS_OBJECT_NAME_COLLISION     0xC0000035
#define STATUS_PORT_DISCONNECTED         0xC0000037
#define STATUS_DEVICE_ALREADY_ATTACHED   0xC0000038
#define STATUS_OBJECT_PATH_INVALID       0xC0000039
#define STATUS_OBJECT_PATH_NOT_FOUND     0xC000003A
#define STATUS_OBJECT_PATH_SYNTAX_BAD    0xC000003B
#define STATUS_DATA_OVERRUN              0xC000003C
#define STATUS_DATA_LATE_ERROR           0xC000003D
#define STATUS_DATA_ERROR                0xC000003E
#define STATUS_CRC_ERROR                 0xC000003F
#define STATUS_SECTION_TOO_BIG           0xC0000040
#define STATUS_PORT_CONNECTION_REFUSED   0xC0000041
#define STATUS_INVALID_PORT_HANDLE       0xC0000042
#define STATUS_SHARING_VIOLATION         0xC0000043
#define STATUS_QUOTA_EXCEEDED            0xC0000044
#define STATUS_INVALID_PAGE_PROTECTION   0xC0000045
#define STATUS_MUTANT_NOT_OWNED          0xC0000046
#define STATUS_SEMAPHORE_LIMIT_EXCEEDED  0xC0000047
#define STATUS_PORT_ALREADY_SET          0xC0000048
#define STATUS_SECTION_NOT_IMAGE         0xC0000049
#define STATUS_SUSPEND_COUNT_EXCEEDED    0xC000004A
#define STATUS_THREAD_IS_TERMINATING     0xC000004B
#define STATUS_BAD_WORKING_SET_LIMIT     0xC000004C
#define STATUS_INCOMPATIBLE_FILE_MAP     0xC000004D
#define STATUS_SECTION_PROTECTION        0xC000004E
#define STATUS_EAS_NOT_SUPPORTED         0xC000004F
#define STATUS_EA_TOO_LARGE              0xC0000050
#define STATUS_NONEXISTENT_EA_ENTRY      0xC0000051
#define STATUS_NO_EAS_ON_FILE            0xC0000052
#define STATUS_EA_CORRUPT_ERROR          0xC0000053
#define STATUS_FILE_LOCK_CONFLICT        0xC0000054
#define STATUS_LOCK_NOT_GRANTED          0xC0000055
#define STATUS_DELETE_PENDING            0xC0000056
#define STATUS_CTL_FILE_NOT_SUPPORTED    0xC0000057
#define STATUS_UNKNOWN_REVISION          0xC0000058
#define STATUS_REVISION_MISMATCH         0xC0000059
#define STATUS_INVALID_OWNER             0xC000005A
#define STATUS_INVALID_PRIMARY_GROUP     0xC000005B
#define STATUS_NO_IMPERSONATION_TOKEN    0xC000005C
#define STATUS_CANT_DISABLE_MANDATORY    0xC000005D
#define STATUS_NO_LOGON_SERVERS          0xC000005E
#define STATUS_NO_SUCH_LOGON_SESSION     0xC000005F
#define STATUS_NO_SUCH_PRIVILEGE         0xC0000060
#define STATUS_PRIVILEGE_NOT_HELD        0xC0000061
#define STATUS_INVALID_ACCOUNT_NAME      0xC0000062
#define STATUS_USER_EXISTS               0xC0000063
#define STATUS_NO_SUCH_USER              0xC0000064
#define STATUS_GROUP_EXISTS              0xC0000065
#define STATUS_NO_SUCH_GROUP             0xC0000066
#define STATUS_MEMBER_IN_GROUP           0xC0000067
#define STATUS_MEMBER_NOT_IN_GROUP       0xC0000068
#define STATUS_LAST_ADMIN                0xC0000069
#define STATUS_WRONG_PASSWORD            0xC000006A
#define STATUS_ILL_FORMED_PASSWORD       0xC000006B
#define STATUS_PASSWORD_RESTRICTION      0xC000006C
#define STATUS_LOGON_FAILURE             0xC000006D
#define STATUS_ACCOUNT_RESTRICTION       0xC000006E
#define STATUS_INVALID_LOGON_HOURS       0xC000006F
#define STATUS_INVALID_WORKSTATION       0xC0000070
#define STATUS_PASSWORD_EXPIRED          0xC0000071
#define STATUS_ACCOUNT_DISABLED          0xC0000072
#define STATUS_NONE_MAPPED               0xC0000073
#define STATUS_TOO_MANY_LUIDS_REQUESTED  0xC0000074
#define STATUS_LUIDS_EXHAUSTED           0xC0000075
#define STATUS_INVALID_SUB_AUTHORITY     0xC0000076
#define STATUS_INVALID_ACL               0xC0000077
#define STATUS_INVALID_SID               0xC0000078
#define STATUS_INVALID_SECURITY_DESCR    0xC0000079
#define STATUS_PROCEDURE_NOT_FOUND       0xC000007A
#define STATUS_INVALID_IMAGE_FORMAT      0xC000007B
#define STATUS_NO_TOKEN                  0xC000007C
#define STATUS_BAD_INHERITANCE_ACL       0xC000007D
#define STATUS_RANGE_NOT_LOCKED          0xC000007E
#define STATUS_DISK_FULL                 0xC000007F
#define STATUS_SERVER_DISABLED           0xC0000080
#define STATUS_SERVER_NOT_DISABLED       0xC0000081
#define STATUS_TOO_MANY_GUIDS_REQUESTED  0xC0000082
#define STATUS_GUIDS_EXHAUSTED           0xC0000083
#define STATUS_INVALID_ID_AUTHORITY      0xC0000084
#define STATUS_AGENTS_EXHAUSTED          0xC0000085
#define STATUS_INVALID_VOLUME_LABEL      0xC0000086
#define STATUS_SECTION_NOT_EXTENDED      0xC0000087
#define STATUS_NOT_MAPPED_DATA           0xC0000088
#define STATUS_RESOURCE_DATA_NOT_FOUND   0xC0000089
#define STATUS_RESOURCE_TYPE_NOT_FOUND   0xC000008A
#define STATUS_RESOURCE_NAME_NOT_FOUND   0xC000008B
#define STATUS_ARRAY_BOUNDS_EXCEEDED     0xC000008C
#define STATUS_FLOAT_DENORMAL_OPERAND    0xC000008D
#define STATUS_FLOAT_DIVIDE_BY_ZERO      0xC000008E
#define STATUS_FLOAT_INEXACT_RESULT      0xC000008F
#define STATUS_FLOAT_INVALID_OPERATION   0xC0000090
#define STATUS_FLOAT_OVERFLOW            0xC0000091
#define STATUS_FLOAT_STACK_CHECK         0xC0000092
#define STATUS_FLOAT_UNDERFLOW           0xC0000093
#define STATUS_INTEGER_DIVIDE_BY_ZERO    0xC0000094
#define STATUS_INTEGER_OVERFLOW          0xC0000095
#define STATUS_PRIVILEGED_INSTRUCTION    0xC0000096
#define STATUS_TOO_MANY_PAGING_FILES     0xC0000097
#define STATUS_FILE_INVALID              0xC0000098
#define STATUS_ALLOTTED_SPACE_EXCEEDED   0xC0000099
#define STATUS_INSUFFICIENT_RESOURCES    0xC000009A
#define STATUS_DFS_EXIT_PATH_FOUND       0xC000009B
#define STATUS_DEVICE_DATA_ERROR         0xC000009C
#define STATUS_DEVICE_NOT_CONNECTED      0xC000009D
#define STATUS_DEVICE_POWER_FAILURE      0xC000009E
#define STATUS_FREE_VM_NOT_AT_BASE       0xC000009F
#define STATUS_MEMORY_NOT_ALLOCATED      0xC00000A0
#define STATUS_WORKING_SET_QUOTA         0xC00000A1
#define STATUS_MEDIA_WRITE_PROTECTED     0xC00000A2
#define STATUS_DEVICE_NOT_READY          0xC00000A3
#define STATUS_INVALID_GROUP_ATTRIBUTES  0xC00000A4
#define STATUS_BAD_IMPERSONATION_LEVEL   0xC00000A5
#define STATUS_CANT_OPEN_ANONYMOUS       0xC00000A6
#define STATUS_BAD_VALIDATION_CLASS      0xC00000A7
#define STATUS_BAD_TOKEN_TYPE            0xC00000A8
#define STATUS_BAD_MASTER_BOOT_RECORD    0xC00000A9
#define STATUS_INSTRUCTION_MISALIGNMENT  0xC00000AA
#define STATUS_INSTANCE_NOT_AVAILABLE    0xC00000AB
#define STATUS_PIPE_NOT_AVAILABLE        0xC00000AC
#define STATUS_INVALID_PIPE_STATE        0xC00000AD
#define STATUS_PIPE_BUSY                 0xC00000AE
#define STATUS_ILLEGAL_FUNCTION          0xC00000AF
#define STATUS_PIPE_DISCONNECTED         0xC00000B0
#define STATUS_PIPE_CLOSING              0xC00000B1
#define STATUS_PIPE_CONNECTED            0xC00000B2
#define STATUS_PIPE_LISTENING            0xC00000B3
#define STATUS_INVALID_READ_MODE         0xC00000B4
#define STATUS_IO_TIMEOUT                0xC00000B5
#define STATUS_FILE_FORCED_CLOSED        0xC00000B6
#define STATUS_PROFILING_NOT_STARTED     0xC00000B7
#define STATUS_PROFILING_NOT_STOPPED     0xC00000B8
#define STATUS_COULD_NOT_INTERPRET       0xC00000B9
#define STATUS_FILE_IS_A_DIRECTORY       0xC00000BA
#define STATUS_NOT_SUPPORTED             0xC00000BB
#define STATUS_REMOTE_NOT_LISTENING      0xC00000BC
#define STATUS_DUPLICATE_NAME            0xC00000BD
#define STATUS_BAD_NETWORK_PATH          0xC00000BE
#define STATUS_NETWORK_BUSY              0xC00000BF
#define STATUS_DEVICE_DOES_NOT_EXIST     0xC00000C0
#define STATUS_TOO_MANY_COMMANDS         0xC00000C1
#define STATUS_ADAPTER_HARDWARE_ERROR    0xC00000C2
#define STATUS_INVALID_NETWORK_RESPONSE  0xC00000C3
#define STATUS_UNEXPECTED_NETWORK_ERROR  0xC00000C4
#define STATUS_BAD_REMOTE_ADAPTER        0xC00000C5
#define STATUS_PRINT_QUEUE_FULL          0xC00000C6
#define STATUS_NO_SPOOL_SPACE            0xC00000C7
#define STATUS_PRINT_CANCELLED           0xC00000C8
#define STATUS_NETWORK_NAME_DELETED      0xC00000C9
#define STATUS_NETWORK_ACCESS_DENIED     0xC00000CA
#define STATUS_BAD_DEVICE_TYPE           0xC00000CB
#define STATUS_BAD_NETWORK_NAME          0xC00000CC
#define STATUS_TOO_MANY_NAMES            0xC00000CD
#define STATUS_TOO_MANY_SESSIONS         0xC00000CE
#define STATUS_SHARING_PAUSED            0xC00000CF
#define STATUS_REQUEST_NOT_ACCEPTED      0xC00000D0
#define STATUS_REDIRECTOR_PAUSED         0xC00000D1
#define STATUS_NET_WRITE_FAULT           0xC00000D2
#define STATUS_PROFILING_AT_LIMIT        0xC00000D3
#define STATUS_NOT_SAME_DEVICE           0xC00000D4
#define STATUS_FILE_RENAMED              0xC00000D5
#define STATUS_VIRTUAL_CIRCUIT_CLOSED    0xC00000D6
#define STATUS_NO_SECURITY_ON_OBJECT     0xC00000D7
#define STATUS_CANT_WAIT                 0xC00000D8
#define STATUS_PIPE_EMPTY                0xC00000D9
#define STATUS_CANT_ACCESS_DOMAIN_INFO   0xC00000DA
#define STATUS_CANT_TERMINATE_SELF       0xC00000DB
#define STATUS_INVALID_SERVER_STATE      0xC00000DC
#define STATUS_INVALID_DOMAIN_STATE      0xC00000DD
#define STATUS_INVALID_DOMAIN_ROLE       0xC00000DE
#define STATUS_NO_SUCH_DOMAIN            0xC00000DF
#define STATUS_DOMAIN_EXISTS             0xC00000E0
#define STATUS_DOMAIN_LIMIT_EXCEEDED     0xC00000E1
#define STATUS_OPLOCK_NOT_GRANTED        0xC00000E2
#define STATUS_INVALID_OPLOCK_PROTOCOL   0xC00000E3
#define STATUS_INTERNAL_DB_CORRUPTION    0xC00000E4
#define STATUS_INTERNAL_ERROR            0xC00000E5
#define STATUS_GENERIC_NOT_MAPPED        0xC00000E6
#define STATUS_BAD_DESCRIPTOR_FORMAT     0xC00000E7
#define STATUS_INVALID_USER_BUFFER       0xC00000E8
#define STATUS_UNEXPECTED_IO_ERROR       0xC00000E9
#define STATUS_UNEXPECTED_MM_CREATE_ERR  0xC00000EA
#define STATUS_UNEXPECTED_MM_MAP_ERROR   0xC00000EB
#define STATUS_UNEXPECTED_MM_EXTEND_ERR  0xC00000EC
#define STATUS_NOT_LOGON_PROCESS         0xC00000ED
#define STATUS_LOGON_SESSION_EXISTS      0xC00000EE
#define STATUS_INVALID_PARAMETER_1       0xC00000EF
#define STATUS_INVALID_PARAMETER_2       0xC00000F0
#define STATUS_INVALID_PARAMETER_3       0xC00000F1
#define STATUS_INVALID_PARAMETER_4       0xC00000F2
#define STATUS_INVALID_PARAMETER_5       0xC00000F3
#define STATUS_INVALID_PARAMETER_6       0xC00000F4
#define STATUS_INVALID_PARAMETER_7       0xC00000F5
#define STATUS_INVALID_PARAMETER_8       0xC00000F6
#define STATUS_INVALID_PARAMETER_9       0xC00000F7
#define STATUS_INVALID_PARAMETER_10      0xC00000F8
#define STATUS_INVALID_PARAMETER_11      0xC00000F9
#define STATUS_INVALID_PARAMETER_12      0xC00000FA
#define STATUS_REDIRECTOR_NOT_STARTED    0xC00000FB
#define STATUS_REDIRECTOR_STARTED        0xC00000FC
#define STATUS_STACK_OVERFLOW            0xC00000FD
#define STATUS_NO_SUCH_PACKAGE           0xC00000FE
#define STATUS_BAD_FUNCTION_TABLE        0xC00000FF
#define STATUS_VARIABLE_NOT_FOUND        0xC0000100
#define STATUS_DIRECTORY_NOT_EMPTY       0xC0000101
#define STATUS_FILE_CORRUPT_ERROR        0xC0000102
#define STATUS_NOT_A_DIRECTORY           0xC0000103
#define STATUS_BAD_LOGON_SESSION_STATE   0xC0000104
#define STATUS_LOGON_SESSION_COLLISION   0xC0000105
#define STATUS_NAME_TOO_LONG             0xC0000106
#define STATUS_FILES_OPEN                0xC0000107
#define STATUS_CONNECTION_IN_USE         0xC0000108
#define STATUS_MESSAGE_NOT_FOUND         0xC0000109
#define STATUS_PROCESS_IS_TERMINATING    0xC000010A
#define STATUS_INVALID_LOGON_TYPE        0xC000010B
#define STATUS_NO_GUID_TRANSLATION       0xC000010C
#define STATUS_CANNOT_IMPERSONATE        0xC000010D
#define STATUS_IMAGE_ALREADY_LOADED      0xC000010E
#define STATUS_ABIOS_NOT_PRESENT         0xC000010F
#define STATUS_ABIOS_LID_NOT_EXIST       0xC0000110
#define STATUS_ABIOS_LID_ALREADY_OWNED   0xC0000111
#define STATUS_ABIOS_NOT_LID_OWNER       0xC0000112
#define STATUS_ABIOS_INVALID_COMMAND     0xC0000113
#define STATUS_ABIOS_INVALID_LID         0xC0000114
#define STATUS_ABIOS_SELECTOR_NOT_AVAILABLE 0xC0000115
#define STATUS_ABIOS_INVALID_SELECTOR    0xC0000116
#define STATUS_NO_LDT                    0xC0000117
#define STATUS_INVALID_LDT_SIZE          0xC0000118
#define STATUS_INVALID_LDT_OFFSET        0xC0000119
#define STATUS_INVALID_LDT_DESCRIPTOR    0xC000011A
#define STATUS_INVALID_IMAGE_NE_FORMAT   0xC000011B
#define STATUS_RXACT_INVALID_STATE       0xC000011C
#define STATUS_RXACT_COMMIT_FAILURE      0xC000011D
#define STATUS_MAPPED_FILE_SIZE_ZERO     0xC000011E
#define STATUS_TOO_MANY_OPENED_FILES     0xC000011F
#define STATUS_CANCELLED                 0xC0000120
#define STATUS_CANNOT_DELETE             0xC0000121
#define STATUS_INVALID_COMPUTER_NAME     0xC0000122
#define STATUS_FILE_DELETED              0xC0000123
#define STATUS_SPECIAL_ACCOUNT           0xC0000124
#define STATUS_SPECIAL_GROUP             0xC0000125
#define STATUS_SPECIAL_USER              0xC0000126
#define STATUS_MEMBERS_PRIMARY_GROUP     0xC0000127
#define STATUS_FILE_CLOSED               0xC0000128
#define STATUS_TOO_MANY_THREADS          0xC0000129
#define STATUS_THREAD_NOT_IN_PROCESS     0xC000012A
#define STATUS_TOKEN_ALREADY_IN_USE      0xC000012B
#define STATUS_PAGEFILE_QUOTA_EXCEEDED   0xC000012C
#define STATUS_COMMITMENT_LIMIT          0xC000012D
#define STATUS_INVALID_IMAGE_LE_FORMAT   0xC000012E
#define STATUS_INVALID_IMAGE_NOT_MZ      0xC000012F
#define STATUS_INVALID_IMAGE_PROTECT     0xC0000130
#define STATUS_INVALID_IMAGE_WIN_16      0xC0000131
#define STATUS_LOGON_SERVER_CONFLICT     0xC0000132
#define STATUS_TIME_DIFFERENCE_AT_DC     0xC0000133
#define STATUS_SYNCHRONIZATION_REQUIRED  0xC0000134
#define STATUS_DLL_NOT_FOUND             0xC0000135
#define STATUS_OPEN_FAILED               0xC0000136
#define STATUS_IO_PRIVILEGE_FAILED       0xC0000137
#define STATUS_ORDINAL_NOT_FOUND         0xC0000138
#define STATUS_ENTRYPOINT_NOT_FOUND      0xC0000139
#define STATUS_CONTROL_C_EXIT            0xC000013A
#define STATUS_LOCAL_DISCONNECT          0xC000013B
#define STATUS_REMOTE_DISCONNECT         0xC000013C
#define STATUS_REMOTE_RESOURCES          0xC000013D
#define STATUS_LINK_FAILED               0xC000013E
#define STATUS_LINK_TIMEOUT              0xC000013F
#define STATUS_INVALID_CONNECTION        0xC0000140
#define STATUS_INVALID_ADDRESS           0xC0000141
#define STATUS_DLL_INIT_FAILED           0xC0000142
#define STATUS_MISSING_SYSTEMFILE        0xC0000143
#define STATUS_UNHANDLED_EXCEPTION       0xC0000144
#define STATUS_APP_INIT_FAILURE          0xC0000145
#define STATUS_PAGEFILE_CREATE_FAILED    0xC0000146
#define STATUS_NO_PAGEFILE               0xC0000147
#define STATUS_INVALID_LEVEL             0xC0000148
#define STATUS_WRONG_PASSWORD_CORE       0xC0000149
#define STATUS_ILLEGAL_FLOAT_CONTEXT     0xC000014A
#define STATUS_PIPE_BROKEN               0xC000014B
#define STATUS_REGISTRY_CORRUPT          0xC000014C
#define STATUS_REGISTRY_IO_FAILED        0xC000014D
#define STATUS_NO_EVENT_PAIR             0xC000014E
#define STATUS_UNRECOGNIZED_VOLUME       0xC000014F
#define STATUS_SERIAL_NO_DEVICE_INITED   0xC0000150
#define STATUS_NO_SUCH_ALIAS             0xC0000151
#define STATUS_MEMBER_NOT_IN_ALIAS       0xC0000152
#define STATUS_MEMBER_IN_ALIAS           0xC0000153
#define STATUS_ALIAS_EXISTS              0xC0000154
#define STATUS_LOGON_NOT_GRANTED         0xC0000155
#define STATUS_TOO_MANY_SECRETS          0xC0000156
#define STATUS_SECRET_TOO_LONG           0xC0000157
#define STATUS_INTERNAL_DB_ERROR         0xC0000158
#define STATUS_FULLSCREEN_MODE           0xC0000159
#define STATUS_TOO_MANY_CONTEXT_IDS      0xC000015A
#define STATUS_LOGON_TYPE_NOT_GRANTED    0xC000015B
#define STATUS_NOT_REGISTRY_FILE         0xC000015C
#define STATUS_NT_CROSS_ENCRYPTION_REQUIRED 0xC000015D
#define STATUS_DOMAIN_CTRLR_CONFIG_ERROR 0xC000015E
#define STATUS_FT_MISSING_MEMBER         0xC000015F
#define STATUS_ILL_FORMED_SERVICE_ENTRY  0xC0000160
#define STATUS_ILLEGAL_CHARACTER         0xC0000161
#define STATUS_UNMAPPABLE_CHARACTER      0xC0000162
#define STATUS_UNDEFINED_CHARACTER       0xC0000163
#define STATUS_FLOPPY_VOLUME             0xC0000164
#define STATUS_FLOPPY_ID_MARK_NOT_FOUND  0xC0000165
#define STATUS_FLOPPY_WRONG_CYLINDER     0xC0000166
#define STATUS_FLOPPY_UNKNOWN_ERROR      0xC0000167
#define STATUS_FLOPPY_BAD_REGISTERS      0xC0000168
#define STATUS_DISK_RECALIBRATE_FAILED   0xC0000169
#define STATUS_DISK_OPERATION_FAILED     0xC000016A
#define STATUS_DISK_RESET_FAILED         0xC000016B
#define STATUS_SHARED_IRQ_BUSY           0xC000016C
#define STATUS_FT_ORPHANING              0xC000016D
#define STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT 0xC000016E

#define STATUS_PARTITION_FAILURE         0xC0000172
#define STATUS_INVALID_BLOCK_LENGTH      0xC0000173
#define STATUS_DEVICE_NOT_PARTITIONED    0xC0000174
#define STATUS_UNABLE_TO_LOCK_MEDIA      0xC0000175
#define STATUS_UNABLE_TO_UNLOAD_MEDIA    0xC0000176
#define STATUS_EOM_OVERFLOW              0xC0000177
#define STATUS_NO_MEDIA                  0xC0000178
#define STATUS_NO_SUCH_MEMBER            0xC000017A
#define STATUS_INVALID_MEMBER            0xC000017B
#define STATUS_KEY_DELETED               0xC000017C
#define STATUS_NO_LOG_SPACE              0xC000017D
#define STATUS_TOO_MANY_SIDS             0xC000017E
#define STATUS_LM_CROSS_ENCRYPTION_REQUIRED 0xC000017F
#define STATUS_KEY_HAS_CHILDREN          0xC0000180
#define STATUS_CHILD_MUST_BE_VOLATILE    0xC0000181
#define STATUS_DEVICE_CONFIGURATION_ERROR 0xC0000182
#define STATUS_DRIVER_INTERNAL_ERROR     0xC0000183
#define STATUS_INVALID_DEVICE_STATE      0xC0000184
#define STATUS_IO_DEVICE_ERROR           0xC0000185
#define STATUS_DEVICE_PROTOCOL_ERROR     0xC0000186
#define STATUS_BACKUP_CONTROLLER         0xC0000187
#define STATUS_LOG_FILE_FULL             0xC0000188
#define STATUS_TOO_LATE                  0xC0000189
#define STATUS_NO_TRUST_LSA_SECRET       0xC000018A
#define STATUS_NO_TRUST_SAM_ACCOUNT      0xC000018B
#define STATUS_TRUSTED_DOMAIN_FAILURE    0xC000018C
#define STATUS_TRUSTED_RELATIONSHIP_FAILURE 0xC000018D
#define STATUS_EVENTLOG_FILE_CORRUPT     0xC000018E
#define STATUS_EVENTLOG_CANT_START       0xC000018F
#define STATUS_TRUST_FAILURE             0xC0000190
#define STATUS_MUTANT_LIMIT_EXCEEDED     0xC0000191
#define STATUS_NETLOGON_NOT_STARTED      0xC0000192
#define STATUS_ACCOUNT_EXPIRED           0xC0000193
#define STATUS_POSSIBLE_DEADLOCK         0xC0000194
#define STATUS_NETWORK_CREDENTIAL_CONFLICT 0xC0000195
#define STATUS_REMOTE_SESSION_LIMIT      0xC0000196
#define STATUS_EVENTLOG_FILE_CHANGED     0xC0000197
#define STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT 0xC0000198
#define STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT 0xC0000199
#define STATUS_NOLOGON_SERVER_TRUST_ACCOUNT 0xC000019A
#define STATUS_DOMAIN_TRUST_INCONSISTENT 0xC000019B
#define STATUS_FS_DRIVER_REQUIRED        0xC000019C
#define STATUS_NO_USER_SESSION_KEY       0xC0000202
#define STATUS_USER_SESSION_DELETED      0xC0000203
#define STATUS_RESOURCE_LANG_NOT_FOUND   0xC0000204
#define STATUS_INSUFF_SERVER_RESOURCES   0xC0000205
#define STATUS_INVALID_BUFFER_SIZE       0xC0000206
#define STATUS_INVALID_ADDRESS_COMPONENT 0xC0000207
#define STATUS_INVALID_ADDRESS_WILDCARD  0xC0000208
#define STATUS_TOO_MANY_ADDRESSES        0xC0000209
#define STATUS_ADDRESS_ALREADY_EXISTS    0xC000020A
#define STATUS_ADDRESS_CLOSED            0xC000020B
#define STATUS_CONNECTION_DISCONNECTED   0xC000020C
#define STATUS_CONNECTION_RESET          0xC000020D
#define STATUS_TOO_MANY_NODES            0xC000020E
#define STATUS_TRANSACTION_ABORTED       0xC000020F
#define STATUS_TRANSACTION_TIMED_OUT     0xC0000210
#define STATUS_TRANSACTION_NO_RELEASE    0xC0000211
#define STATUS_TRANSACTION_NO_MATCH      0xC0000212
#define STATUS_TRANSACTION_RESPONDED     0xC0000213
#define STATUS_TRANSACTION_INVALID_ID    0xC0000214
#define STATUS_TRANSACTION_INVALID_TYPE  0xC0000215
#define STATUS_NOT_SERVER_SESSION        0xC0000216
#define STATUS_NOT_CLIENT_SESSION        0xC0000217
#define STATUS_CANNOT_LOAD_REGISTRY_FILE 0xC0000218
#define STATUS_DEBUG_ATTACH_FAILED       0xC0000219
#define STATUS_SYSTEM_PROCESS_TERMINATED 0xC000021A
#define STATUS_DATA_NOT_ACCEPTED         0xC000021B
#define STATUS_NO_BROWSER_SERVERS_FOUND  0xC000021C
#define STATUS_VDM_HARD_ERROR            0xC000021D
#define STATUS_DRIVER_CANCEL_TIMEOUT     0xC000021E
#define STATUS_REPLY_MESSAGE_MISMATCH    0xC000021F
#define STATUS_MAPPED_ALIGNMENT          0xC0000220
#define STATUS_IMAGE_CHECKSUM_MISMATCH   0xC0000221
#define STATUS_LOST_WRITEBEHIND_DATA     0xC0000222
#define STATUS_CLIENT_SERVER_PARAMETERS_INVALID 0xC0000223
#define STATUS_PASSWORD_MUST_CHANGE      0xC0000224
#define STATUS_NOT_FOUND                 0xC0000225
#define STATUS_NOT_TINY_STREAM           0xC0000226
#define STATUS_RECOVERY_FAILURE          0xC0000227
#define STATUS_STACK_OVERFLOW_READ       0xC0000228
#define STATUS_FAIL_CHECK                0xC0000229
#define STATUS_DUPLICATE_OBJECTID        0xC000022A
#define STATUS_OBJECTID_EXISTS           0xC000022B
#define STATUS_CONVERT_TO_LARGE          0xC000022C
#define STATUS_RETRY                     0xC000022D
#define STATUS_FOUND_OUT_OF_SCOPE        0xC000022E
#define STATUS_ALLOCATE_BUCKET           0xC000022F
#define STATUS_PROPSET_NOT_FOUND         0xC0000230
#define STATUS_MARSHALL_OVERFLOW         0xC0000231
#define STATUS_INVALID_VARIANT           0xC0000232
#define STATUS_DOMAIN_CONTROLLER_NOT_FOUND 0xC0000233
#define STATUS_ACCOUNT_LOCKED_OUT        0xC0000234
#define STATUS_HANDLE_NOT_CLOSABLE       0xC0000235
#define STATUS_CONNECTION_REFUSED        0xC0000236
#define STATUS_GRACEFUL_DISCONNECT       0xC0000237
#define STATUS_ADDRESS_ALREADY_ASSOCIATED 0xC0000238
#define STATUS_ADDRESS_NOT_ASSOCIATED    0xC0000239
#define STATUS_CONNECTION_INVALID        0xC000023A
#define STATUS_CONNECTION_ACTIVE         0xC000023B
#define STATUS_NETWORK_UNREACHABLE       0xC000023C
#define STATUS_HOST_UNREACHABLE          0xC000023D
#define STATUS_PROTOCOL_UNREACHABLE      0xC000023E
#define STATUS_PORT_UNREACHABLE          0xC000023F
#define STATUS_REQUEST_ABORTED           0xC0000240
#define STATUS_CONNECTION_ABORTED        0xC0000241
#define STATUS_BAD_COMPRESSION_BUFFER    0xC0000242
#define STATUS_USER_MAPPED_FILE          0xC0000243
#define STATUS_AUDIT_FAILED              0xC0000244
#define STATUS_TIMER_RESOLUTION_NOT_SET  0xC0000245
#define STATUS_CONNECTION_COUNT_LIMIT    0xC0000246
#define STATUS_LOGIN_TIME_RESTRICTION    0xC0000247
#define STATUS_LOGIN_WKSTA_RESTRICTION   0xC0000248
#define STATUS_IMAGE_MP_UP_MISMATCH      0xC0000249
#define STATUS_INSUFFICIENT_LOGON_INFO   0xC0000250
#define STATUS_BAD_DLL_ENTRYPOINT        0xC0000251
#define STATUS_BAD_SERVICE_ENTRYPOINT    0xC0000252
#define STATUS_LPC_REPLY_LOST            0xC0000253
#define STATUS_IP_ADDRESS_CONFLICT1      0xC0000254
#define STATUS_IP_ADDRESS_CONFLICT2      0xC0000255
#define STATUS_REGISTRY_QUOTA_LIMIT      0xC0000256
#define STATUS_PATH_NOT_COVERED          0xC0000257
#define STATUS_NO_CALLBACK_ACTIVE        0xC0000258
#define STATUS_LICENSE_QUOTA_EXCEEDED    0xC0000259
#define STATUS_PWD_TOO_SHORT             0xC000025A
#define STATUS_PWD_TOO_RECENT            0xC000025B
#define STATUS_PWD_HISTORY_CONFLICT      0xC000025C
#define STATUS_PLUGPLAY_NO_DEVICE        0xC000025E
#define STATUS_UNSUPPORTED_COMPRESSION   0xC000025F
#define STATUS_INVALID_HW_PROFILE        0xC0000260
#define STATUS_INVALID_PLUGPLAY_DEVICE_PATH 0xC0000261
#define STATUS_DRIVER_ORDINAL_NOT_FOUND  0xC0000262
#define STATUS_DRIVER_ENTRYPOINT_NOT_FOUND 0xC0000263
#define STATUS_RESOURCE_NOT_OWNED        0xC0000264
#define STATUS_TOO_MANY_LINKS            0xC0000265
#define STATUS_QUOTA_LIST_INCONSISTENT   0xC0000266
#define STATUS_FILE_IS_OFFLINE           0xC0000267
#define STATUS_EVALUATION_EXPIRATION     0xC0000268
#define STATUS_ILLEGAL_DLL_RELOCATION    0xC0000269
#define STATUS_LICENSE_VIOLATION         0xC000026A
#define STATUS_DLL_INIT_FAILED_LOGOFF    0xC000026B
#define STATUS_DRIVER_UNABLE_TO_LOAD     0xC000026C
#define STATUS_DFS_UNAVAILABLE           0xC000026D
#define STATUS_VOLUME_DISMOUNTED         0xC000026E
#define STATUS_WX86_INTERNAL_ERROR       0xC000026F
#define STATUS_WX86_FLOAT_STACK_CHECK    0xC0000270
#define STATUS_VALIDATE_CONTINUE         0xC0000271
#define STATUS_NO_MATCH                  0xC0000272
#define STATUS_NO_MORE_MATCHES           0xC0000273
#define STATUS_NOT_A_REPARSE_POINT       0xC0000275
#define STATUS_IO_REPARSE_TAG_INVALID    0xC0000276
#define STATUS_IO_REPARSE_TAG_MISMATCH   0xC0000277
#define STATUS_IO_REPARSE_DATA_INVALID   0xC0000278
#define STATUS_IO_REPARSE_TAG_NOT_HANDLED       0xC0000279
#define STATUS_REPARSE_POINT_NOT_RESOLVED       0xC0000280
#define STATUS_DIRECTORY_IS_A_REPARSE_POINT     0xC0000281
#define STATUS_RANGE_LIST_CONFLICT       0xC0000282
#define STATUS_SOURCE_ELEMENT_EMPTY      0xC0000283
#define STATUS_DESTINATION_ELEMENT_FULL  0xC0000284
#define STATUS_ILLEGAL_ELEMENT_ADDRESS   0xC0000285
#define STATUS_MAGAZINE_NOT_PRESENT      0xC0000286
#define STATUS_REINITIALIZATION_NEEDED   0xC0000287
#define STATUS_ENCRYPTION_FAILED         0xC000028A
#define STATUS_DECRYPTION_FAILED         0xC000028B
#define STATUS_RANGE_NOT_FOUND           0xC000028C
#define STATUS_NO_RECOVERY_POLICY        0xC000028D
#define STATUS_NO_EFS                    0xC000028E
#define STATUS_WRONG_EFS                 0xC000028F
#define STATUS_NO_USER_KEYS              0xC0000290
#define STATUS_FILE_NOT_ENCRYPTED        0xC0000291
#define STATUS_NOT_EXPORT_FORMAT         0xC0000292
#define STATUS_FILE_ENCRYPTED            0xC0000293
#define STATUS_WMI_GUID_NOT_FOUND        0xC0000295
#define STATUS_WMI_INSTANCE_NOT_FOUND    0xC0000296
#define STATUS_WMI_ITEMID_NOT_FOUND      0xC0000297
#define STATUS_WMI_TRY_AGAIN             0xC0000298
#define STATUS_SHARED_POLICY             0xC0000299
#define STATUS_POLICY_OBJECT_NOT_FOUND   0xC000029A
#define STATUS_POLICY_ONLY_IN_DS         0xC000029B
#define STATUS_VOLUME_NOT_UPGRADED       0xC000029C
#define STATUS_REMOTE_STORAGE_NOT_ACTIVE 0xC000029D
#define STATUS_REMOTE_STORAGE_MEDIA_ERROR       0xC000029E
#define STATUS_NO_TRACKING_SERVICE       0xC000029F
#define STATUS_SERVER_SID_MISMATCH       0xC00002A0
#define STATUS_DS_NO_ATTRIBUTE_OR_VALUE  0xC00002A1
#define STATUS_DS_INVALID_ATTRIBUTE_SYNTAX      0xC00002A2
#define STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED      0xC00002A3
#define STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS     0xC00002A4
#define STATUS_DS_BUSY                   0xC00002A5
#define STATUS_DS_UNAVAILABLE            0xC00002A6
#define STATUS_DS_NO_RIDS_ALLOCATED      0xC00002A7
#define STATUS_DS_NO_MORE_RIDS           0xC00002A8
#define STATUS_DS_INCORRECT_ROLE_OWNER   0xC00002A9
#define STATUS_DS_RIDMGR_INIT_ERROR      0xC00002AA
#define STATUS_DS_OBJ_CLASS_VIOLATION    0xC00002AB
#define STATUS_DS_CANT_ON_NON_LEAF       0xC00002AC
#define STATUS_DS_CANT_ON_RDN            0xC00002AD
#define STATUS_DS_CANT_MOD_OBJ_CLASS     0xC00002AE
#define STATUS_DS_CROSS_DOM_MOVE_FAILED  0xC00002AF
#define STATUS_DS_GC_NOT_AVAILABLE       0xC00002B0
#define STATUS_DIRECTORY_SERVICE_REQUIRED       0xC00002B1
#define STATUS_REPARSE_ATTRIBUTE_CONFLICT       0xC00002B2
#define STATUS_CANT_ENABLE_DENY_ONLY     0xC00002B3
#define STATUS_FLOAT_MULTIPLE_FAULTS     0xC00002B4
#define STATUS_FLOAT_MULTIPLE_TRAPS      0xC00002B5
#define STATUS_DEVICE_REMOVED            0xC00002B6
#define STATUS_JOURNAL_DELETE_IN_PROGRESS       0xC00002B7
#define STATUS_JOURNAL_NOT_ACTIVE        0xC00002B8
#define STATUS_NOINTERFACE               0xC00002B9
#define STATUS_DS_ADMIN_LIMIT_EXCEEDED   0xC00002C1
#define STATUS_DRIVER_FAILED_SLEEP       0xC00002C2
#define STATUS_MUTUAL_AUTHENTICATION_FAILED     0xC00002C3
#define STATUS_CORRUPT_SYSTEM_FILE       0xC00002C4
#define STATUS_DATATYPE_MISALIGNMENT_ERROR      0xC00002C5
#define STATUS_WMI_READ_ONLY             0xC00002C6
#define STATUS_WMI_SET_FAILURE           0xC00002C7
#define STATUS_COMMITMENT_MINIMUM        0xC00002C8
#define STATUS_REG_NAT_CONSUMPTION       0xC00002C9
#define STATUS_TRANSPORT_FULL            0xC00002CA
#define STATUS_DS_SAM_INIT_FAILURE       0xC00002CB
#define STATUS_ONLY_IF_CONNECTED         0xC00002CC
#define STATUS_DS_SENSITIVE_GROUP_VIOLATION     0xC00002CD
#define STATUS_PNP_RESTART_ENUMERATION   0xC00002CE
#define STATUS_JOURNAL_ENTRY_DELETED     0xC00002CF
#define STATUS_DS_CANT_MOD_PRIMARYGROUPID       0xC00002D0
#define STATUS_SYSTEM_IMAGE_BAD_SIGNATURE 0xC00002D1
#define STATUS_PNP_REBOOT_REQUIRED       0xC00002D2
#define STATUS_POWER_STATE_INVALID       0xC00002D3
#define STATUS_DS_INVALID_GROUP_TYPE     0xC00002D4
#define STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN    0xC00002D5
#define STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN     0xC00002D6
#define STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER 0xC00002D7
#define STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER     0xC00002D8
#define STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER      0xC00002D9
#define STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER   0xC00002DA
#define STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER      0xC00002DB
#define STATUS_DS_HAVE_PRIMARY_MEMBERS   0xC00002DC
#define STATUS_WMI_NOT_SUPPORTED         0xC00002DD
#define STATUS_INSUFFICIENT_POWER        0xC00002DE
#define STATUS_SAM_NEED_BOOTKEY_PASSWORD 0xC00002DF
#define STATUS_SAM_NEED_BOOTKEY_FLOPPY   0xC00002E0
#define STATUS_DS_CANT_START             0xC00002E1
#define STATUS_DS_INIT_FAILURE           0xC00002E2
#define STATUS_SAM_INIT_FAILURE          0xC00002E3
#define STATUS_DS_GC_REQUIRED            0xC00002E4
#define STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY    0xC00002E5
#define STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS    0xC00002E6
#define STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED        0xC00002E7
#define STATUS_MULTIPLE_FAULT_VIOLATION  0xC00002E8
#define STATUS_CURRENT_DOMAIN_NOT_ALLOWED       0xC00002E9
#define STATUS_CANNOT_MAKE               0xC00002EA
#define STATUS_SYSTEM_SHUTDOWN           0xC00002EB
#define STATUS_DS_INIT_FAILURE_CONSOLE   0xC00002EC
#define STATUS_DS_SAM_INIT_FAILURE_CONSOLE      0xC00002ED
#define STATUS_UNFINISHED_CONTEXT_DELETED       0xC00002EE
#define STATUS_NO_TGT_REPLY              0xC00002EF
#define STATUS_OBJECTID_NOT_FOUND        0xC00002F0
#define STATUS_NO_IP_ADDRESSES           0xC00002F1
#define STATUS_WRONG_CREDENTIAL_HANDLE   0xC00002F2
#define STATUS_CRYPTO_SYSTEM_INVALID     0xC00002F3
#define STATUS_MAX_REFERRALS_EXCEEDED    0xC00002F4
#define STATUS_MUST_BE_KDC               0xC00002F5
#define STATUS_STRONG_CRYPTO_NOT_SUPPORTED      0xC00002F6
#define STATUS_TOO_MANY_PRINCIPALS       0xC00002F7
#define STATUS_NO_PA_DATA                0xC00002F8
#define STATUS_PKINIT_NAME_MISMATCH      0xC00002F9
#define STATUS_SMARTCARD_LOGON_REQUIRED  0xC00002FA
#define STATUS_KDC_INVALID_REQUEST       0xC00002FB
#define STATUS_KDC_UNABLE_TO_REFER       0xC00002FC
#define STATUS_KDC_UNKNOWN_ETYPE         0xC00002FD
#define STATUS_SHUTDOWN_IN_PROGRESS      0xC00002FE
#define STATUS_SERVER_SHUTDOWN_IN_PROGRESS      0xC00002FF
#define STATUS_NOT_SUPPORTED_ON_SBS      0xC0000300
#define STATUS_WMI_GUID_DISCONNECTED     0xC0000301
#define STATUS_WMI_ALREADY_DISABLED      0xC0000302
#define STATUS_WMI_ALREADY_ENABLED       0xC0000303
#define STATUS_MFT_TOO_FRAGMENTED        0xC0000304
#define STATUS_COPY_PROTECTION_FAILURE   0xC0000305
#define STATUS_CSS_AUTHENTICATION_FAILURE       0xC0000306
#define STATUS_CSS_KEY_NOT_PRESENT       0xC0000307
#define STATUS_CSS_KEY_NOT_ESTABLISHED   0xC0000308
#define STATUS_CSS_SCRAMBLED_SECTOR      0xC0000309
#define STATUS_CSS_REGION_MISMATCH       0xC000030A
#define STATUS_CSS_RESETS_EXHAUSTED      0xC000030B
#define STATUS_PKINIT_FAILURE            0xC0000320
#define STATUS_SMARTCARD_SUBSYSTEM_FAILURE      0xC0000321
#define STATUS_NO_KERB_KEY               0xC0000322
#define STATUS_HOST_DOWN                 0xC0000350
#define STATUS_UNSUPPORTED_PREAUTH       0xC0000351
#define STATUS_EFS_ALG_BLOB_TOO_BIG      0xC0000352
#define STATUS_PORT_NOT_SET              0xC0000353
#define STATUS_DEBUGGER_INACTIVE         0xC0000354
#define STATUS_DS_VERSION_CHECK_FAILURE  0xC0000355
#define STATUS_AUDITING_DISABLED         0xC0000356
#define STATUS_PRENT4_MACHINE_ACCOUNT    0xC0000357
#define STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER 0xC0000358
#define STATUS_INVALID_IMAGE_WIN_32      0xC0000359
#define STATUS_INVALID_IMAGE_WIN_64      0xC000035A
#define STATUS_BAD_BINDINGS              0xC000035B
#define STATUS_NETWORK_SESSION_EXPIRED   0xC000035C
#define STATUS_APPHELP_BLOCK             0xC000035D
#define STATUS_ALL_SIDS_FILTERED         0xC000035E
#define STATUS_NOT_SAFE_MODE_DRIVER      0xC000035F
#define STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT        0xC0000361
#define STATUS_ACCESS_DISABLED_BY_POLICY_PATH   0xC0000362
#define STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER      0xC0000363
#define STATUS_ACCESS_DISABLED_BY_POLICY_OTHER  0xC0000364
#define STATUS_FAILED_DRIVER_ENTRY       0xC0000365
#define STATUS_DEVICE_ENUMERATION_ERROR  0xC0000366
#define STATUS_WAIT_FOR_OPLOCK           0x00000367
#define STATUS_MOUNT_POINT_NOT_RESOLVED  0xC0000368
#define STATUS_INVALID_DEVICE_OBJECT_PARAMETER 0xC0000369
#define STATUS_MCA_OCCURED               0xC000036A
#define STATUS_DRIVER_BLOCKED_CRITICAL   0xC000036B
#define STATUS_DRIVER_BLOCKED            0xC000036C
#define STATUS_DRIVER_DATABASE_ERROR     0xC000036D
#define STATUS_SYSTEM_HIVE_TOO_LARGE     0xC000036E
#define STATUS_INVALID_IMPORT_OF_NON_DLL 0xC000036F
#define STATUS_SMARTCARD_WRONG_PIN       0xC0000380
#define STATUS_SMARTCARD_CARD_BLOCKED    0xC0000381
#define STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED 0xC0000382
#define STATUS_SMARTCARD_NO_CARD         0xC0000383
#define STATUS_SMARTCARD_NO_KEY_CONTAINER       0xC0000384
#define STATUS_SMARTCARD_NO_CERTIFICATE  0xC0000385
#define STATUS_SMARTCARD_NO_KEYSET       0xC0000386
#define STATUS_SMARTCARD_IO_ERROR        0xC0000387
#define STATUS_DOWNGRADE_DETECTED        0xC0000388
#define STATUS_SMARTCARD_CERT_REVOKED    0xC0000389
#define STATUS_ISSUING_CA_UNTRUSTED      0xC000038A
#define STATUS_REVOCATION_OFFLINE_C      0xC000038B
#define STATUS_PKINIT_CLIENT_FAILURE     0xC000038C
#define STATUS_SMARTCARD_CERT_EXPIRED    0xC000038D
#define STATUS_DRIVER_FAILED_PRIOR_UNLOAD 0xC000038E
#define STATUS_SMARTCARD_SILENT_CONTEXT  0xC000038F
#define STATUS_PER_USER_TRUST_QUOTA_EXCEEDED 0xC0000401
#define STATUS_ALL_USER_TRUST_QUOTA_EXCEEDED 0xC0000402
#define STATUS_USER_DELETE_TRUST_QUOTA_EXCEEDED 0xC0000403
#define STATUS_DS_NAME_NOT_UNIQUE        0xC0000404
#define STATUS_DS_DUPLICATE_ID_FOUND     0xC0000405
#define STATUS_DS_GROUP_CONVERSION_ERROR 0xC0000406
#define STATUS_VOLSNAP_PREPARE_HIBERNATE 0xC0000407
#define STATUS_USER2USER_REQUIRED        0xC0000408
#define STATUS_STACK_BUFFER_OVERRUN      0xC0000409
#define STATUS_NO_S4U_PROT_SUPPORT       0xC000040A
#define STATUS_CROSSREALM_DELEGATION_FAILURE 0xC000040B
#define STATUS_REVOCATION_OFFLINE_KDC    0xC000040C
#define STATUS_ISSUING_CA_UNTRUSTED_KDC  0xC000040D
#define STATUS_KDC_CERT_EXPIRED          0xC000040E
#define STATUS_KDC_CERT_REVOKED          0xC000040F
#define STATUS_PARAMETER_QUOTA_EXCEEDED  0xC0000410
#define STATUS_HIBERNATION_FAILURE       0xC0000411
#define STATUS_DELAY_LOAD_FAILED         0xC0000412
#define STATUS_AUTHENTICATION_FIREWALL_FAILED 0xC0000413
#define STATUS_VDM_DISALLOWED            0xC0000414
#define STATUS_HUNG_DISPLAY_DRIVER_THREAD 0xC0000415
#define STATUS_WOW_ASSERTION             0xC0009898

#define RPC_NT_INVALID_STRING_BINDING    0xC0020001
#define RPC_NT_WRONG_KIND_OF_BINDING     0xC0020002
#define RPC_NT_INVALID_BINDING           0xC0020003
#define RPC_NT_PROTSEQ_NOT_SUPPORTED     0xC0020004
#define RPC_NT_INVALID_RPC_PROTSEQ       0xC0020005
#define RPC_NT_INVALID_STRING_UUID       0xC0020006
#define RPC_NT_INVALID_ENDPOINT_FORMAT   0xC0020007
#define RPC_NT_INVALID_NET_ADDR          0xC0020008
#define RPC_NT_NO_ENDPOINT_FOUND         0xC0020009
#define RPC_NT_INVALID_TIMEOUT           0xC002000A
#define RPC_NT_OBJECT_NOT_FOUND          0xC002000B
#define RPC_NT_ALREADY_REGISTERED        0xC002000C
#define RPC_NT_TYPE_ALREADY_REGISTERED   0xC002000D
#define RPC_NT_ALREADY_LISTENING         0xC002000E
#define RPC_NT_NO_PROTSEQS_REGISTERED    0xC002000F
#define RPC_NT_NOT_LISTENING             0xC0020010
#define RPC_NT_UNKNOWN_MGR_TYPE          0xC0020011
#define RPC_NT_UNKNOWN_IF                0xC0020012
#define RPC_NT_NO_BINDINGS               0xC0020013
#define RPC_NT_NO_PROTSEQS               0xC0020014
#define RPC_NT_CANT_CREATE_ENDPOINT      0xC0020015
#define RPC_NT_OUT_OF_RESOURCES          0xC0020016
#define RPC_NT_SERVER_UNAVAILABLE        0xC0020017
#define RPC_NT_SERVER_TOO_BUSY           0xC0020018
#define RPC_NT_INVALID_NETWORK_OPTIONS   0xC0020019
#define RPC_NT_NO_CALL_ACTIVE            0xC002001A
#define RPC_NT_CALL_FAILED               0xC002001B
#define RPC_NT_CALL_FAILED_DNE           0xC002001C
#define RPC_NT_PROTOCOL_ERROR            0xC002001D
#define RPC_NT_UNSUPPORTED_TRANS_SYN     0xC002001F
#define RPC_NT_UNSUPPORTED_TYPE          0xC0020021
#define RPC_NT_INVALID_TAG               0xC0020022
#define RPC_NT_INVALID_BOUND             0xC0020023
#define RPC_NT_NO_ENTRY_NAME             0xC0020024
#define RPC_NT_INVALID_NAME_SYNTAX       0xC0020025
#define RPC_NT_UNSUPPORTED_NAME_SYNTAX   0xC0020026
#define RPC_NT_UUID_NO_ADDRESS           0xC0020028
#define RPC_NT_DUPLICATE_ENDPOINT        0xC0020029
#define RPC_NT_UNKNOWN_AUTHN_TYPE        0xC002002A
#define RPC_NT_MAX_CALLS_TOO_SMALL       0xC002002B
#define RPC_NT_STRING_TOO_LONG           0xC002002C
#define RPC_NT_PROTSEQ_NOT_FOUND         0xC002002D
#define RPC_NT_PROCNUM_OUT_OF_RANGE      0xC002002E
#define RPC_NT_BINDING_HAS_NO_AUTH       0xC002002F
#define RPC_NT_UNKNOWN_AUTHN_SERVICE     0xC0020030
#define RPC_NT_UNKNOWN_AUTHN_LEVEL       0xC0020031
#define RPC_NT_INVALID_AUTH_IDENTITY     0xC0020032
#define RPC_NT_UNKNOWN_AUTHZ_SERVICE     0xC0020033
#define EPT_NT_INVALID_ENTRY             0xC0020034
#define EPT_NT_CANT_PERFORM_OP           0xC0020035
#define EPT_NT_NOT_REGISTERED            0xC0020036
#define RPC_NT_NOTHING_TO_EXPORT         0xC0020037
#define RPC_NT_INCOMPLETE_NAME           0xC0020038
#define RPC_NT_INVALID_VERS_OPTION       0xC0020039
#define RPC_NT_NO_MORE_MEMBERS           0xC002003A
#define RPC_NT_NOT_ALL_OBJS_UNEXPORTED   0xC002003B
#define RPC_NT_INTERFACE_NOT_FOUND       0xC002003C
#define RPC_NT_ENTRY_ALREADY_EXISTS      0xC002003D
#define RPC_NT_ENTRY_NOT_FOUND           0xC002003E
#define RPC_NT_NAME_SERVICE_UNAVAILABLE  0xC002003F
#define RPC_NT_INVALID_NAF_ID            0xC0020040
#define RPC_NT_CANNOT_SUPPORT            0xC0020041
#define RPC_NT_NO_CONTEXT_AVAILABLE      0xC0020042
#define RPC_NT_INTERNAL_ERROR            0xC0020043
#define RPC_NT_ZERO_DIVIDE               0xC0020044
#define RPC_NT_ADDRESS_ERROR             0xC0020045
#define RPC_NT_FP_DIV_ZERO               0xC0020046
#define RPC_NT_FP_UNDERFLOW              0xC0020047
#define RPC_NT_FP_OVERFLOW               0xC0020048
#define RPC_NT_CALL_IN_PROGRESS          0xC0020049
#define RPC_NT_NO_MORE_BINDINGS          0xC002004A
#define RPC_NT_GROUP_MEMBER_NOT_FOUND    0xC002004B
#define EPT_NT_CANT_CREATE               0xC002004C
#define RPC_NT_INVALID_OBJECT            0xC002004D
#define RPC_NT_NO_INTERFACES             0xC002004F
#define RPC_NT_CALL_CANCELLED            0xC0020050
#define RPC_NT_BINDING_INCOMPLETE        0xC0020051
#define RPC_NT_COMM_FAILURE              0xC0020052
#define RPC_NT_UNSUPPORTED_AUTHN_LEVEL   0xC0020053
#define RPC_NT_NO_PRINC_NAME             0xC0020054
#define RPC_NT_NOT_RPC_ERROR             0xC0020055
#define RPC_NT_SEC_PKG_ERROR             0xC0020057
#define RPC_NT_NOT_CANCELLED             0xC0020058
#define RPC_NT_INVALID_ASYNC_HANDLE      0xC0020062
#define RPC_NT_INVALID_ASYNC_CALL        0xC0020063

#define RPC_NT_NO_MORE_ENTRIES           0xC0030001
#define RPC_NT_SS_CHAR_TRANS_OPEN_FAIL   0xC0030002
#define RPC_NT_SS_CHAR_TRANS_SHORT_FILE  0xC0030003
#define RPC_NT_SS_IN_NULL_CONTEXT        0xC0030004
#define RPC_NT_SS_CONTEXT_MISMATCH       0xC0030005
#define RPC_NT_SS_CONTEXT_DAMAGED        0xC0030006
#define RPC_NT_SS_HANDLES_MISMATCH       0xC0030007
#define RPC_NT_SS_CANNOT_GET_CALL_HANDLE 0xC0030008
#define RPC_NT_NULL_REF_POINTER          0xC0030009
#define RPC_NT_ENUM_VALUE_OUT_OF_RANGE   0xC003000A
#define RPC_NT_BYTE_COUNT_TOO_SMALL      0xC003000B
#define RPC_NT_BAD_STUB_DATA             0xC003000C
#define RPC_NT_INVALID_ES_ACTION         0xC0030059
#define RPC_NT_WRONG_ES_VERSION          0xC003005A
#define RPC_NT_WRONG_STUB_VERSION        0xC003005B
#define RPC_NT_INVALID_PIPE_OBJECT       0xC003005C
#define RPC_NT_INVALID_PIPE_OPERATION    0xC003005D
#define RPC_NT_WRONG_PIPE_VERSION        0xC003005E
#define RPC_NT_PIPE_CLOSED               0xC003005F
#define RPC_NT_PIPE_DISCIPLINE_ERROR     0xC0030060
#define RPC_NT_PIPE_EMPTY                0xC0030061

#define STATUS_PNP_BAD_MPS_TABLE         0xC0040035
#define STATUS_PNP_TRANSLATION_FAILED    0xC0040036
#define STATUS_PNP_IRQ_TRANSLATION_FAILED 0xC0040037
#define STATUS_PNP_INVALID_ID            0xC0040038

#define STATUS_CTX_WINSTATION_NAME_INVALID      0xC00A0001
#define STATUS_CTX_INVALID_PD            0xC00A0002
#define STATUS_CTX_PD_NOT_FOUND          0xC00A0003
#define STATUS_CTX_CLOSE_PENDING         0xC00A0006
#define STATUS_CTX_NO_OUTBUF             0xC00A0007
#define STATUS_CTX_MODEM_INF_NOT_FOUND   0xC00A0008
#define STATUS_CTX_INVALID_MODEMNAME     0xC00A0009
#define STATUS_CTX_RESPONSE_ERROR        0xC00A000A
#define STATUS_CTX_MODEM_RESPONSE_TIMEOUT       0xC00A000B
#define STATUS_CTX_MODEM_RESPONSE_NO_CARRIER    0xC00A000C
#define STATUS_CTX_MODEM_RESPONSE_NO_DIALTONE   0xC00A000D
#define STATUS_CTX_MODEM_RESPONSE_BUSY   0xC00A000E
#define STATUS_CTX_MODEM_RESPONSE_VOICE  0xC00A000F
#define STATUS_CTX_TD_ERROR              0xC00A0010
#define STATUS_CTX_LICENSE_CLIENT_INVALID       0xC00A0012
#define STATUS_CTX_LICENSE_NOT_AVAILABLE 0xC00A0013
#define STATUS_CTX_LICENSE_EXPIRED       0xC00A0014
#define STATUS_CTX_WINSTATION_NOT_FOUND  0xC00A0015
#define STATUS_CTX_WINSTATION_NAME_COLLISION    0xC00A0016
#define STATUS_CTX_WINSTATION_BUSY       0xC00A0017
#define STATUS_CTX_BAD_VIDEO_MODE        0xC00A0018
#define STATUS_CTX_GRAPHICS_INVALID      0xC00A0022
#define STATUS_CTX_NOT_CONSOLE           0xC00A0024
#define STATUS_CTX_CLIENT_QUERY_TIMEOUT  0xC00A0026
#define STATUS_CTX_CONSOLE_DISCONNECT    0xC00A0027
#define STATUS_CTX_CONSOLE_CONNECT       0xC00A0028
#define STATUS_CTX_SHADOW_DENIED         0xC00A002A
#define STATUS_CTX_WINSTATION_ACCESS_DENIED     0xC00A002B
#define STATUS_CTX_INVALID_WD            0xC00A002E
#define STATUS_CTX_WD_NOT_FOUND          0xC00A002F
#define STATUS_CTX_SHADOW_INVALID        0xC00A0030
#define STATUS_CTX_SHADOW_DISABLED       0xC00A0031
#define STATUS_RDP_PROTOCOL_ERROR        0xC00A0032
#define STATUS_CTX_CLIENT_LICENSE_NOT_SET       0xC00A0033
#define STATUS_CTX_CLIENT_LICENSE_IN_USE 0xC00A0034
#define STATUS_CTX_SHADOW_ENDED_BY_MODE_CHANGE  0xC00A0035
#define STATUS_CTX_SHADOW_NOT_RUNNING    0xC00A0036

#define STATUS_CLUSTER_INVALID_NODE      0xC0130001
#define STATUS_CLUSTER_NODE_EXISTS       0xC0130002
#define STATUS_CLUSTER_JOIN_IN_PROGRESS  0xC0130003
#define STATUS_CLUSTER_NODE_NOT_FOUND    0xC0130004
#define STATUS_CLUSTER_LOCAL_NODE_NOT_FOUND     0xC0130005
#define STATUS_CLUSTER_NETWORK_EXISTS    0xC0130006
#define STATUS_CLUSTER_NETWORK_NOT_FOUND 0xC0130007
#define STATUS_CLUSTER_NETINTERFACE_EXISTS      0xC0130008
#define STATUS_CLUSTER_NETINTERFACE_NOT_FOUND   0xC0130009
#define STATUS_CLUSTER_INVALID_REQUEST   0xC013000A
#define STATUS_CLUSTER_INVALID_NETWORK_PROVIDER 0xC013000B
#define STATUS_CLUSTER_NODE_DOWN         0xC013000C
#define STATUS_CLUSTER_NODE_UNREACHABLE  0xC013000D
#define STATUS_CLUSTER_NODE_NOT_MEMBER   0xC013000E
#define STATUS_CLUSTER_JOIN_NOT_IN_PROGRESS     0xC013000F
#define STATUS_CLUSTER_INVALID_NETWORK   0xC0130010
#define STATUS_CLUSTER_NO_NET_ADAPTERS   0xC0130011
#define STATUS_CLUSTER_NODE_UP           0xC0130012
#define STATUS_CLUSTER_NODE_PAUSED       0xC0130013
#define STATUS_CLUSTER_NODE_NOT_PAUSED   0xC0130014
#define STATUS_CLUSTER_NO_SECURITY_CONTEXT      0xC0130015
#define STATUS_CLUSTER_NETWORK_NOT_INTERNAL     0xC0130016
#define STATUS_CLUSTER_POISONED          0xC0130017

#define STATUS_SXS_SECTION_NOT_FOUND     0xC0150001
#define STATUS_SXS_CANT_GEN_ACTCTX       0xC0150002
#define STATUS_SXS_INVALID_ACTCTXDATA_FORMAT    0xC0150003
#define STATUS_SXS_ASSEMBLY_NOT_FOUND    0xC0150004
#define STATUS_SXS_MANIFEST_FORMAT_ERROR 0xC0150005
#define STATUS_SXS_MANIFEST_PARSE_ERROR  0xC0150006
#define STATUS_SXS_ACTIVATION_CONTEXT_DISABLED  0xC0150007
#define STATUS_SXS_KEY_NOT_FOUND         0xC0150008
#define STATUS_SXS_VERSION_CONFLICT      0xC0150009
#define STATUS_SXS_WRONG_SECTION_TYPE    0xC015000A
#define STATUS_SXS_THREAD_QUERIES_DISABLED      0xC015000B
#define STATUS_SXS_ASSEMBLY_MISSING      0xC015000C
#define STATUS_SXS_PROCESS_DEFAULT_ALREADY_SET  0xC015000E
#define STATUS_SXS_EARLY_DEACTIVATION    0xC015000F
#define STATUS_SXS_INVALID_DEACTIVATION  0xC0150010
#define STATUS_SXS_MULTIPLE_DEACTIVATION 0xC0150011
#define STATUS_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY 0xC0150012
#define STATUS_SXS_PROCESS_TERMINATION_REQUESTED 0xC0150013
#define STATUS_SXS_CORRUPT_ACTIVATION_STACK 0xC0150014
#define STATUS_SXS_CORRUPTION            0xC0150015

#endif /* WIN32_NO_STATUS */

#endif /* __WINE_NTSTATUS_H */
