/*
 *  Constants, used in resources.
 *
 *  Copyright 2002 Sylvain Petreolle <spetreolle@yahoo.fr>
 *  Copyright 2002 Andriy Palamarchuk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define MAIN_MENU               0x201
#define DIALOG_PAGESETUP        0x202
#define ID_ACCEL                0x203

/* Commands */
#define CMD_NEW                 0x100
#define CMD_OPEN                0x101
#define CMD_SAVE                0x102
#define CMD_SAVE_AS             0x103
#define CMD_PRINT               0x104
#define CMD_PAGE_SETUP          0x105
#define CMD_PRINTER_SETUP       0x106
#define CMD_EXIT                0x108

#define CMD_UNDO                0x110
#define CMD_CUT                 0x111
#define CMD_COPY                0x112
#define CMD_PASTE               0x113
#define CMD_DELETE              0x114
#define CMD_SELECT_ALL          0x116
#define CMD_TIME_DATE           0x117

#define CMD_SEARCH              0x120
#define CMD_SEARCH_NEXT         0x121

#define CMD_WRAP                0x119
#define CMD_FONT                0x140

#define CMD_HELP_CONTENTS       0x130
#define CMD_HELP_SEARCH         0x131
#define CMD_HELP_ON_HELP        0x132
#define CMD_LICENSE             0x135
#define CMD_NO_WARRANTY         0x136
#define CMD_ABOUT_WINE          0x137

/* Strings */
#define STRING_PAGESETUP_HEADERVALUE 0x160
#define STRING_PAGESETUP_FOOTERVALUE 0x161
#define STRING_PAGESETUP_LEFTVALUE 0x162
#define STRING_PAGESETUP_RIGHTVALUE 0x163
#define STRING_PAGESETUP_TOPVALUE 0x164
#define STRING_PAGESETUP_BOTTOMVALUE 0x165

#define STRING_NOTEPAD 0x170
#define STRING_ERROR 0x171
#define STRING_WARNING 0x172
#define STRING_INFO 0x173
#define STRING_UNTITLED 0x174
#define STRING_ALL_FILES 0x175
#define STRING_TEXT_FILES_TXT 0x176
#define STRING_TOOLARGE 0x177
#define STRING_NOTEXT 0x178
#define STRING_DOESNOTEXIST 0x179
#define STRING_NOTSAVED 0x17A

#define STRING_NOTFOUND 0x17B
#define STRING_OUT_OF_MEMORY 0x17C
