W               [ \t\r\n]
Q               [\"\']
NQ              [^\"\']
F               [-a-z0-9$_.!*(),%;/?:@&=+~|]

%x ENTITY ENTITY_URL
%x DOCTYPE DOCTYPE_URL
%x COMMENT

%{
/***************************************
  $Header: /home/amb/wwwoffle/RCS/xml.l 1.4 1999/07/11 10:16:23 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.5.
  Parse the XML and look for external references.
  ******************/ /******************
  Written by Walter Pfannenmueller

  This file Copyright 1997,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include "wwwoffle.h"
#include "errors.h"
#include "document.h"

extern int xml_yylex(void);
#define xml_yywrap() 1

/*+ The file descriptor that we are reading from. +*/
static int xml_yyfd=-1;

/*++++++++++++++++++++++++++++++++++++++
  Parse the XML and look for references.

  int fd The file descriptor of the file to parse.

  URL *Url The reference URL to use.
  ++++++++++++++++++++++++++++++++++++++*/

void ParseXML(int fd,URL *Url)
{
 static int first=1;

 PrintMessage(Debug,"Parsing document using XML parser.");

 xml_yyfd=fd;
 if(!first)
    xml_yyrestart(NULL);
 BEGIN(INITIAL);
 xml_yylex();

 first=0;
}

/*+ A macro to read data that can be used by the lexer. +*/
#define YY_INPUT(buf,result,max_size) \
        if((result=read_data(xml_yyfd,buf,max_size))==-1) \
           result=0;

%}

%%

 /*
	Just doctypes and external entities are handled so far.
 */

[^<]+                 { }
"<!--"                { BEGIN(COMMENT); }
"<!ENTITY"            { BEGIN(ENTITY); }
"<!DOCTYPE"           { BEGIN(DOCTYPE); }
.|\r|\n               { }

 /* ENTITIES */
<ENTITY>{W}*           { }
<ENTITY>"SYSTEM"{W}+{Q} { BEGIN(ENTITY_URL); }
<ENTITY>"PUBLIC"{W}+{Q}{NQ}*{Q}{W}*{Q} { BEGIN(ENTITY_URL); }
<ENTITY>">"            { BEGIN(INITIAL); }
<ENTITY>.              { }

 /* Urls from entities. */
<ENTITY_URL>{F}+       { AddReference(xml_yytext,RefInlineObject); 
                         BEGIN(INITIAL);}

 /* DOCTYPE */
<DOCTYPE>{W}*           { }
<DOCTYPE>"SYSTEM"{W}+{Q} { BEGIN(ENTITY_URL); }
<DOCTYPE>">"            { BEGIN(INITIAL); }
<DOCTYPE>.              { }

 /* Urls from entities. */
<DOCTYPE_URL>{F}+       { AddReference(xml_yytext,RefInlineObject); 
                         BEGIN(INITIAL);}
 /* Comments */

<COMMENT>[^->]+         { }
<COMMENT>"-->"          { BEGIN(INITIAL); }
<COMMENT>.|\r|\n        { }

%%
