/*
 * wzdftpd - a modular and cool ftp server
 * Copyright (C) 2002-2004  Pierre Chifflier
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * As a special exemption, Pierre Chifflier
 * and other respective copyright holders give permission to link this program
 * with OpenSSL, and distribute the resulting executable, without including
 * the source code for OpenSSL in the source distribution.
 */

#ifndef __WZD_CONFIGLOADER__
#define __WZD_CONFIGLOADER__

/** \file wzd_configloader.h
 * \brief Load config file from wzd_configfile_t to memory
 */

/** \brief Initialize a wzd_config_t
 */
void cfg_init(wzd_config_t * cfg);

/** \brief Frees a wzd_config_t (using wzd_free() )
 */
void cfg_free(wzd_config_t * cfg);

/** \brief Load a \a wzd_configfile_t into a \a wzd_config_t
 */
wzd_config_t * cfg_store(wzd_configfile_t * file, int * error);

#endif /* __WZD_CONFIGLOADER__ */
