#define _USE_BSD
#include <ctype.h>
#include <config.h>
#include "pty.h"
#include "xwin.h"
#include "main.h"
#include "utmp_write.h"

extern char pty_name[12];
extern char *tty;
pid_t pid;
pid_t pid2;

response_struct *send_line_for_pattern_match (char *buf2, node * patterns)
    {
    char buffer_s[MAX_PATTERN];
    regexp *r;
    response_struct *buffer;
    int j = 0;
    node *patterns_t = patterns;

    while (patterns_t)
        {
        istrncpy (buffer_s, patterns_t->pattern, MAX_PATTERN-1);
        r = nregcomp (buffer_s);
        if (r == NULL)
            {
            fprintf (stderr, "regcomp failure\n");
            return (NULL);
            }

        j = nregexec (r, buf2);
        if (j == 1)
            {
            buffer = (response_struct *) malloc (sizeof (response_struct));
            if (buffer == NULL)
                {
                fprintf (stderr, "Panic, no memory\n");
                return (NULL);
                }
            buffer->command = examine_command (patterns_t->command, r);
            buffer->title = (char *) malloc (strlen (patterns_t->title) + 1);
            buffer->soundclip = (char *) malloc (strlen (patterns_t->soundclip) + 1);
            strcpy (buffer->title, patterns_t->title);
            strcpy (buffer->soundclip, patterns_t->soundclip);

            free ((char *) r);

            buffer->use_bitmap = patterns_t->use_bitmap;
            buffer->bitmap = patterns_t->bitmap;
            return (buffer);
            }
        free ((char *) r);

        patterns_t = patterns_t->next;
        }

    return (NULL);
    }

RETSIGTYPE reaper (int ignored)
    {
#ifdef MUST_REINSTALL_SIGHANDLERS
    signal_handle (SIGCHLD, reaper);
#endif

    while (WAITPID (-1, 0, WNOHANG) > 0)
        ;

    }

RETSIGTYPE write_user_outof_utmp_and_quit (int ignored)
    {
    write_user_outof_utmp ();
    kill (pid, SIGTERM);
    kill (pid2, SIGTERM);
    exit (0);
    }

char *examine_command (char *command, regexp * r)
    {
    char *solution;
    int i = 0, j = 0, index, sol_index = 0;
    char *pointer;
    char buffer[BIT_BUCKET];

    solution = (char *) malloc (MAX_COMMAND);
    if (solution == NULL)
        {
        fprintf (stderr, "Panic no memory!!\n");
        return (NULL);
        }

    while (i < strlen (command))
        {
        if (command[i] == '%')
            {
            i++;
            if (command[i] == '(')
                {
                i++;
                while (isdigit (command[i]) || (command[i] == '-'))
                    {
                    buffer[j] = command[i];
                    i++;
                    j++;
                    }
				buffer[j] = '\0';
                if ((command[i] == ')') && (j != 0))
                    {
                    i++;
                    index = atoi (buffer);
					if (index==-1)
						{
						/*insert magic pty device name*/
						pointer = pty_name;
                        while (pointer != pty_name+strlen(pty_name))
							{
							if (sol_index < MAX_COMMAND - 1)
								{
								solution[sol_index] = *pointer;
								/* strip the white space out might cause
								* trouble */
								if (!(isspace (solution[sol_index])))
								sol_index++;
								}
							pointer++;
							}
						}
                    else if (r->startp[index] != NULL && r->endp[index] != NULL)
                        {
                        pointer = r->startp[index];
                        while (pointer != r->endp[index])
                            {
                            if (sol_index < MAX_COMMAND - 1)
                                {
                                solution[sol_index] = *pointer;
                                /* strip the white space out might cause
                                 * trouble */
                                if (!(isspace (solution[sol_index])))
                                    sol_index++;
                                }
                            pointer++;
                            }
                        }
                    else
                        fprintf (stderr, "no data to fill in variable %d in %s\n", index, command);
                    }
                j = 0;
                }
            }
        if (sol_index < MAX_COMMAND - 1)
            solution[sol_index++] = command[i];
        i++;
        }
    solution[sol_index] = '\0';
    return (solution);
    /* you gotta free that yourself later */
    }



char *examine_determined (char *command, char *user, char *tty)
    {
    char *solution;
    int i = 0, j = 0, index, sol_index = 0;
    char buffer[BIT_BUCKET];

    solution = (char *) malloc (MAX_COMMAND);
    if (solution == NULL)
        {
        fprintf (stderr, "Panic no memory!!\n");
        return (NULL);
        }

    while (i < strlen (command))
        {
        if (command[i] == '%')
            {
            i++;
            if (command[i] == '(')
                {
                i++;
                while (isalpha (command[i]))
                    {
                    buffer[j] = command[i];
                    i++;
                    j++;
                    }
                if ((command[i] == ')') && (j != 0))
                    {
                    i++;
                    index = buffer[0];
                    if ((index != 'u') && (index != 't'))
                        {
                        fprintf (stderr, "used match above 2, in name/tty match\n");
                        return (NULL);
                        }
                    if (index == 'u')
                        {
                        if (user != NULL)
                            for (j = 0; j < strlen (user); j++)
                                solution[sol_index++] = user[j];
                        }
                    else if (index == 't')
                        {
                        if (tty != NULL)
                            for (j = 0; j < strlen (tty); j++)
                                solution[sol_index++] = tty[j];
                        }
                    }
                j = 0;
                }
            }
        if (sol_index < MAX_COMMAND - 1)
            solution[sol_index++] = command[i];
        i++;
        }
    solution[sol_index] = '\0';
    return (solution);
    /* you gotta free that yourself later */
    }

void signal_handle (int sig, SigHandler * handler)
    {
    struct sigaction act, oact;

    act.sa_handler = handler;
    act.sa_flags = 0 | SA_NOCLDSTOP | SA_RESTART;
    sigemptyset (&act.sa_mask);
    sigemptyset (&oact.sa_mask);
    sigaction (sig, &act, &oact);
    }

void istrncpy(char *out,const char *in,int num)
    {
    strncpy(out,in,num);
    out[num] = '\0';
    }

char *process_for_variables(char *line,int max)
	{
	int i=0,j=0;
	char *solution;
	char *pointer;
	int index,sol_index=0;
	char buffer[BIT_BUCKET];
	solution = (char *) malloc (max);
    if (solution == NULL)
        {
        fprintf (stderr, "Panic no memory!!\n");
        return (NULL);
        }

	while (i < strlen (line))
        {
        if (line[i] == '%')
            {
            i++;
            if (line[i] == '(')
                {
                i++;
                while (isdigit (line[i]) || (line[i] == '-'))
                    {
                    buffer[j] = line[i];
                    i++;
                    j++;
                    }
                if ((line[i] == ')') && (j != 0))
                    {
                    i++;
                    index = atoi (buffer);
                    if (index==-1)
                        {
                        /*insert magic pty device name*/
						pointer = pty_name;
                        while (pointer != pty_name+strlen(pty_name))
                            {
                            if (sol_index < max - 1)
                                {
                                solution[sol_index] = *pointer;
                                /* strip the white space out might cause
                                * trouble */
                                if (!(isspace (solution[sol_index])))
                                sol_index++;
                                }
                            pointer++;
                            }
						}
					else
						fprintf(stderr,"xitalk: invalid variable number %d asked for\n",index);
					}
				j=0;
				}
			}
     if (sol_index < MAX_COMMAND - 1)
            solution[sol_index++] = line[i];
        i++;
        }
    solution[sol_index] = '\0';
    return (solution);
    /* you gotta free that yourself later */


		
	}
