/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/

/*
 * Copyright (C) 1999 Francesco P. Lovergine. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 * 4. Any modification to the program, as well as redistribution in binary
 *    or derived source form must be advertised to the author.
 *
 * THIS SOFTWARE IS PROVIDED `AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

static char rcsid[] = "$Id: log.c,v 1.3 2001/01/08 18:49:41 kiavik Exp $";

#include "yard.h"
#include "global.h"

/*************************************************************************
 *
 *	Function: log_info
 *
 *	Purpose: Log the info message
 *
 *************************************************************************/

void log_info(char * fmt, ...)
{
	va_list	args;

	va_start(args, fmt);
	log_msg(LOG_INFO, fmt, args);
	va_end(args);
}

/*************************************************************************
 *
 *	Function: log_err
 *
 *	Purpose: Log the error message
 *
 *************************************************************************/

void log_err(char * fmt, ...)
{
	va_list	args;

	va_start(args, fmt);
	log_msg(LOG_ERR, fmt, args);
	va_end(args);
}

/*************************************************************************
 *
 *	Function: log_debug
 *
 *	Purpose: Log the debug message
 *
 *************************************************************************/

void log_debug(char * fmt, ...)
{
	va_list	args;
	
	va_start(args, fmt);
	log_msg(LOG_DEBUG, fmt, args);
	va_end(args);
}

/*************************************************************************
 *
 *	Function: log_msg
 *
 *	Purpose: Log the priority message
 *
 *************************************************************************/

void log_msg(int priority,char *fmt, va_list args)
{
	FILE	*msgfd;
	time_t	timeval;
	char buffer[1024];

	if (radius_log) {
		/*
		 * use users option logfile [-l <logfile>]
		 */
		if((msgfd = fopen(radius_log, "a")) == NULL) {
			fprintf(stderr, "%s: could not open %s for logging\n",
					progname, radius_log);
			return;
		}
		timeval = time(0);
		fprintf(msgfd, "%-24.24s: [%d] ", ctime(&timeval),getpid());
		vfprintf(msgfd, fmt, args);
		fflush(msgfd);
		fclose(msgfd);
	} else {
		/*
		 * use syslog
		 */
		openlog("radius", LOG_PID | LOG_CONS | LOG_NOWAIT, LOG_AUTH);
#if !defined(HAVE_VSYSLOG)
		vsnprintf(buffer,1024,fmt, args);
#if defined(HAVE_SYSLOG)
		syslog(priority, buffer);
#else
#error "Cannot call syslog() or vsyslog() to talk with the syslog daemon"
#endif
#else 
		vsyslog(priority, fmt, args);
#endif
		closelog();
	}
	return;
}
