.\" Copyright (c) 1991-94 Lectra-Systemes
.\" $Id: xteld.man,v 1.3 1995/03/07 14:07:45 pierre Exp $
.TH XTELD n "Lectra-Systemes" "01/95"
.UC 5
.SH NOM
xteld \- demon de l'emulateur Minitel XTEL
.SH SYNOPSIS
xteld
.SH DESCRIPTION
.I xteld
est lance par le super-demon \fIinetd\fP en cas d'utilisation de l'emulateur 
minitel \fIxtel\fP . Si XTEL n'utilise pas le reseau (option NO_NETWORK a la 
compilation), le demon \fIxteld\fP doit etre lance lors de l'initialisation du 
systeme.
.LP
\fIxteld\fP utilise le fichier \fB"/usr/lib/X11/xtel/xtel\.services"\fP
qui contient la liste des services disponibles sous la forme :
.sp
.I "[Nom du device,]"
.I "Nom de l'entree du menu"
,
.I "Numero de telephone du service"
[,
.I "login1[:login2...]"
]
.sp
a raison d'une ligne par service. Le premier champ (nom du device) definit un 
nom symbolique (ou \fIdevice\fP) pour les connexions a un standard donne 
(V.23, V32bis, TVR). Chaque
device est associe a une configuration particuliere de la ligne physique (vitesse,
nombre de bits, parite) qui sera definie dans \fIxtel.lignes\fP. Si le premier
champ a la valeur \fI@pipe\fP, cela signifie que l'acces au service se fait
au travers d'une commande locale (dont le chemin absolu est precise dans le
dernier champ) par \fIpipe\fP Unix.
.PP
Ce premier champ est \fBoptionnel\fP ce qui permet en particulier de supporter
l'ancienne syntaxe. A ce moment la, les fichier \fIxtel.services\fP et 
\fIxtel.lignes\fP \fBne doivent pas\fP utiliser la nouvelle syntaxe (pas de 
melange possible).
.PP
Si le dernier champ est absent, la connection au service est permise a tous 
les utilisateurs,
sinon elle est limitee a ceux dont les noms de login sont
specifies. On peut utiliser des caracteres 8 bits pour le nom du service (1er
champ), si le caractere ne peut etre saisi directement, on pourra le representer
sous la forme d'un code octal \\xyz . 
.sp
.B "Exemple :"
.sp
.in +10
.nf
v23,Annuaire electronique,11
v23,Teletel1,3613
v23,Teletel2,3614
tvr,Teletel TVR,3623
v23,Teletel3,3615,user1:user2:user3
v23,Direct,0
.fi
.in -10
.LP
La derniere ligne definit une possibilite de numero de telephone 
.I direct
(mot\-cle \fIDirect\fP), l'utilisateur saisira directement le numero lors de la 
composition dans \fIxtel\fP.
.LP
On utilise egalement le fichier \fB"/usr/lib/X11/xtel/xtel\.lignes"\fP
qui definit les lignes disponibles et la procedure de composition. Ce fichier est de
la forme :
.sp
.I "[Nom du device,]"
.I "Nom de la ligne"
,
.I "[Vitesse en bauds,]"
.I "[Nombre de bits,]"
.I "[Parite,]"
.I "chat-script avec le modem"
,
.I "delai maxi de reponse du modem en secondes."
.sp
Et ce pour chaque ligne utilisable.
.sp
Si la ligne commence par le caractere "/", on considere que l'\fBancienne\fP
syntaxe est utilisee.
.sp
Les valeurs de vitesse possibles sont :
\fB 50, 75 110, 134, 150, 200, 300, 600, 1200, 1800, 2400, 4800, 9600, 
19200, 38400\fP,
les valeurs de tailles de caracteres sont : \fB5, 6, 7, 8\fP, les valeurs de parite
sont : \fBE, O, N\fP.
.sp
Un "chat-script" est une suite de paires chaine_emise/chaine_attendu entre un 
processus et un modem (voir UUCP).
.sp
Si le chat-script est remplace par la chaine \fIminitel2\fP, la ligne est definie
comme utilisant un \fBMinitel 2\fP comme modem.
.sp
Si le chat-script est remplace par la chaine \fIminitel1\fP, la ligne est definie
comme utilisant un \fBMinitel 1/1B\fI comme modem. A ce moment la, le menu "Services"
ne sera pas affiche dans xtel et l'utilisateur devra composer son numero a la main
(le M1/M1B ne sachant theoriquement pas composer de numero).
.sp 2
.B "Exemples :"
.in +10
.nf
/dev/tty01,at\\r OK atdt\\T\\r CONNECT,30
v23,/dev/tty01,1200,7,E,at\\r OK atdt\\T\\r CONNECT,30
.fi
.in -10
.sp
Ce fichier definit la ligne
.I "/dev/tty01"
sur laquelle on deroule le chat-script suivant :
.sp
.in +5
.nf
	at\\r OK		  On emet at + CR et on attend OK
	at\\T\\r CONNECT	  On emet at + le numero + CR et on attend
				  CONNECT
.fi
.in -5
.sp
Le delai de reponse du modem est de
.I 30
secondes maxi. Si le delai est depasse, \fIxteld\fP essayera sur la ligne suivante du fichier
jusqu'a un succes ou la fin du fichier.
.sp
.B "Remarque :"
.sp
Le format du chat-script accepte les sequences suivantes :
.sp
.in +5
.nf
\\n		envoie LF
\\r		envoie CR
\\t		envoie VT
\\d		tempo de 1 s
\\T		envoie le numero de telephone
\\abc		envoie le caractere code en DECIMAL par abc (3 digits obligatoires)
\\xab		envoie le caractere code en HEXADECIMAL par ab (2 digits)
.fi
.in -5
.LP
Dans le cas d'un fonctionnement en reseau, \fIxteld\fP utilise a priori le port 
TCP numero 1313 defini dans le fichier "/etc/services" 
.SH "VOIR AUSSI"
xtel inetd 
.SH FICHIERS
.in +7
.nf
/usr/lib/X11/xtel/xtel.lignes
/usr/lib/X11/xtel/xtel.services
/usr/lib/X11/xtel/xtel.log
/etc/services
/usr/etc/inetd.conf
.fi
.in -7
.SH COPYRIGHT
Copyright 1992-95, LECTRA-SYSTEMES
.SH AUTEUR
Pierre FICHEUX	  LECTRA-SYSTEMES ZI Marticot 33610 Cestas FRANCE



