#!	/bin/sh
# Boot Disk maker. Bruce Perens, July-September 1995
# This is free software under the GNU General Public License.

# Abort on any non-zero return.
set -e

# Verbose shell execution.
set -v

(modprobe msdos floppy; exit 0)

if [ $# != 3 ]; then
echo "Usage: "$0" kernel-package floppy-drive blocks" 1>&2
	cat 1>&2 << EOF

	kernel-package: the Debian package containing the kernel.
	floppy-drive: the block device file for the floppy drive.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.

	/mnt must be available for mounting the floppy disk.

EOF

	exit -1
fi

if [ ! -f $1 ]; then
	echo "Error: "$1": not a file. Should be the kernel package." 1>&2
	exit -1
fi

if [ ! -b $2 ]; then
	echo "Error: "$2": not a block device. Should be the floppy disk device." \
		1>&2
	exit -1
fi

# Try to unmount anything that should not be mounted.
(umount /mnt; umount $2; true)2>/dev/null >/dev/null

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
echo dd if=/dev/zero of=$2 bs=1k count=$3

# Make a MS/DOS filesystem with SysLinux installed, and mount it.
gunzip < /usr/lib/syslinux/img$3k.gz >$2

# Mount the disk.
mount -t msdos $2 /mnt

# Create the necessary files.
cp /usr/lib/syslinux/syslinux.exe /mnt/syslinux.exe
cp /usr/lib/syslinux/readme /mnt/syslinux.txt
(rm -f -r /var/tmp/extract-tmp-$$;true)
mkdir /var/tmp/extract-tmp-$$
dpkg-deb --extract $1 /var/tmp/extract-tmp-$$

# Copy the kernel, system.map, and modules to the floppy.
cp /var/tmp/extract-tmp-$$/boot/vmlinuz-*.*.* /mnt/linux
gzip -best < /var/tmp/extract-tmp-$$/boot/System.map-*.*.* > /mnt/sys_map.gz
(cd /var/tmp/extract-tmp-$$; tar clf /var/tmp/modules.$$ lib)
gzip -best < /var/tmp/modules.$$ >/mnt/modules.tgz
rm -f /var/tmp/modules.$$ &


# Set the kernel up to run normal VGA, with the ram disk loaded
# from /dev/fd0 starting at block 0. The root will be mounted
# read-only, it remounts itself read-write.
rdev -R /mnt/linux 1
rdev -r /mnt/linux 49152
rdev -v /mnt/linux -1
rdev /mnt/linux /dev/fd0

# Get the kernel version from its package name.
j=${1##*/kernel-image-}
VERSION=${j%%-[0-9]*.deb}

# Install the greeting and help messages
for i in debian.txt kernel.txt f1.txt f10.txt f2.txt f3.txt \
 f4.txt f5.txt f6.txt f7.txt f8.txt f9.txt syslinux.cfg ; do
	sed s/--version--/$VERSION/ <scripts/bootdisk/$i |utilities/crlf>/mnt/$i
done

cp scripts/bootdisk/rdev.sh /mnt/rdev.sh
sed s/--version--/$VERSION/ <scripts/bootdisk/install.sh >/mnt/install.sh
chmod 777 /mnt/install.sh

# Umount the floppy and copy it to a compressed raw disk image file.
umount $2
(rm -f -r /var/tmp/extract-tmp-$$ boot$3.bin;true)
dd if=$2 of=boot$3.bin bs=1k count=$3
ls -l boot$3.bin
exit 0
