activate_swap () {
	if [ ! -z "$Swap" -a "$Swap" != "None" ]; then
		yesNoBox \
"You have already activated $Swap as your swap partition. If you
choose to activate another swap partition, $Swap will be de-activated
as your swap partition. If you wish to have multiple swap partitions,
you can set them up after you've installed the system - this installer
can only handle one at a time. Answer \"no\" to the following question
if you wish to keep your present swap partition active.

Activate a new swap partition?" "Activate Another Swap Partition?"
		if [ $? -ne 0 ]; then return 1; fi
		swapoff $partition
		Swap=""
	fi

	local partition=`select_partition \
"Please select the partition to activate as a swap device." "Linux swap"`
	if [ $? -ne 0 -o -z "$partition" ]; then return 1; fi
	yesNoBox \
"You have chosen to activate $partition as a swap device. This
will permanently erase any data on this disk partition. Are
you sure you want to do this?" "Are You Sure?"
	if [ $? -ne 0 ]; then return 1; fi
	echo $clear$bold"Activating swap partition..."$norm
	echo ""
	swapon $partition
	if [ $? -ne 0 ]; then
		write_it_down
		msgBox \
"The swap partion was not activated." "Problem"
		return 1
	fi
	Swap=$partition
	return 0
}
