install_kernel () {
	local device="$1"
	echo $clear$bold"Installing the kernel..."$norm
	echo ""
	mount -o ro -t msdos $device /floppy
	if [ $? -ne 0 ]; then return 1; fi
	cd /floppy
	if [ $? -ne 0 ]; then cd /Install; umount /floppy; return 1; fi
	./install.sh /target
	local status=$?
	cd /Install
	umount /floppy 2>/dev/null
	if [ $status -ne 0 ]; then return 1; fi
	rdev /target/vmlinuz $Root
	rdev -R /target/vmlinuz 1
	rdev -v /target/vmlinuz -1
	if [ $? -ne 0 ]; then return 1; fi
	# The code to make /lib/modules/current and invoke "depmod -a"
	# is redundant with the boot floppy install script. Remove it
	# once I'm sure all of the boot floppies are up to date.
	echo $bold"Determining module dependencies..."$norm
	if [ ! -d /target/lib/modules/current ]; then
		(cd /target/lib/modules; ln -s $(third `cat /proc/version`) current)
	fi
	depmod -a
}

extract_kernel () {
	require_root
	if [ $? -ne 0 ]; then return 1; fi

	umount /floppy 2>/dev/null
	cat > $TempFile <<EOF
	menu \\
"Please select the floppy drive from which to read the
Debian Linux Boot Disk you used to start the system.
Unless this is a special installation for a memory-limited
system, you'll be using the first floppy drive." \\
	 "Select Disk Drive" \\
EOF
	if [ $InstallationRootDevice != /dev/fd0 ]; then
		echo "\"/dev/fd0\" \"First floppy drive\"" \\>>$TempFile
	fi
	if [ $InstallationRootDevice != /dev/fd1 ]; then
		echo "\"/dev/fd1\" \"Second floppy drive\"" \\>>$TempFile
	fi
	echo "" >>$TempFile
	local device="`. $TempFile`"
	local status=$?
	rm -f $TempFile
	if [ $status -ne 0 -o -z "$device" ]; then return 1; fi

	local designation=""

	case $device in
	/dev/fd0)
		designation="first"
		;;
	/dev/fd1)
		designation="second"
		;;
	esac

	msgBox \
"Please insert the Debian Linux Boot Disk in the $designation
floppy drive." "Please Insert Disk"
	if [ $? -ne 0 ]; then return 1; fi

	fdflush $device
	echo -n $clear

	install_kernel "$device"
	local status=$?
	if [ $status -ne 0 ]; then
		write_it_down
		msgBox \
"The attempt to install the kernel failed." "Problem"
		return 1
	fi

	return 0
}
