select_drive () {
	
	local drives="`tryopen -w /dev/hd[a-z] /dev/sd[a-z] 2>/dev/null`"
	if [ -z "$drives" ]; then
		msgBox \
"No hard disk drives could be found. Make sure they are cabled
correctly and are turned on before the system is started. You
may have to change driver settings when you start the system
with a command at the \"boot:\" prompt, or you may have to load
a driver that is in a loadable module to solve this problem." "Problem"
		return 1;
	fi
cat >$TempFile <<EOF
	menu \\
"Select the drive to partition. SCSI drives are listed in disk ID
number order. Only drives that were connected and operating when
the system was started will show up in this display. CD-ROM drives
may be mis-identified as writable disk drives by this menu." \\
	"Select Disk Drive" \\
EOF
	local index=0
	for d in $drives; do
		index=`math $index 1 add`
		echo -n $d" " >>$TempFile
		local description=""
		case $d in
		/dev/hda)
			description="First drive on primary controller (not SCSI)."
			;;
		/dev/hdb)
			description="Second drive on primary controller (not SCSI)."
			;;
		/dev/hdc)
			description="First drive on secondary controller (not SCSI)."
			;;
		/dev/hdd)
			description="Second drive on secondary controller (not SCSI)."
			;;
		/dev/sda)
			description="Lowest-numbered SCSI drive."
			;;
		/dev/sdb)
			description="Second-lowest-numbered SCSI drive."
			;;
		/dev/sdc)
			description="Third-lowest-numbered SCSI drive."
			;;
		/dev/sdd)
			description="Fourth-lowest-numbered SCSI drive."
			;;
		/dev/sde)
			description="Fifth-lowest-numbered SCSI drive."
			;;
		/dev/sdf)
			description="Sixth-lowest-numbered SCSI drive."
			;;
		/dev/sdg)
			description="Seventh-lowest-numbered SCSI drive."
			;;
		/dev/sdh)
			description="Eigth-lowest-numbered SCSI drive."
			;;
		esac
		echo " \"$description\" \\" >>$TempFile
	done
	echo "">>$TempFile
	. $TempFile
	local status=$?
	rm -f $TempFile
	if [ $status -ne 0 ]; then return 1; fi
}
