// $Id: BoxGraphN.C,v 1.6 1996/01/04 16:28:23 zeller Exp $
// BoxGraphNode class: RegionGraphNode with box

// Copyright (C) 1995 Technische Universitaet Braunschweig, Germany.
// Written by Andreas Zeller (zeller@ips.cs.tu-bs.de).
// 
// This file is part of the DDD Library.
// 
// The DDD Library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// The DDD Library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// See the GNU Library General Public License for more details.
// 
// You should have received a copy of the GNU Library General Public
// License along with the DDD Library -- see the file COPYING.LIB.
// If not, write to the Free Software Foundation, Inc.,
// 675 Mass Ave, Cambridge, MA 02139, USA.
// 
// DDD is the data display debugger.
// For details, see the DDD World-Wide-Web page, 
// `http://www.cs.tu-bs.de/softech/ddd/',
// or send a mail to the DDD developers at `ddd@ips.cs.tu-bs.de'.

char BoxGraphNode_rcsid[] = 
    "$Id: BoxGraphN.C,v 1.6 1996/01/04 16:28:23 zeller Exp $";

#ifdef __GNUG__
#pragma implementation
#endif

#include "BoxGraphN.h"
#include "printBox.h"
#include "CompositeB.h"


DEFINE_TYPE_INFO_1(BoxGraphNode, RegionGraphNode)

// Draw a BoxGraphNode
void BoxGraphNode::forceDraw(Widget w, 
			     const BoxRegion&, 
			     const GraphGC& gc) const
{
    // We do not check for exposures here --
    // boxes are usually small and partial display
    // doesn't work well with scrolling

    box()->draw(w, region(gc), region(gc), gc.nodeGC, false);
}


// mark the following objects as one XFIG compound object
static void startCompound(ostream& os, BoxRegion region)
{
    BoxPoint origin = region.origin();
    BoxPoint width = region.space();

    os << CMPHEAD;
    os << origin[X] + width[X] + 1 << " " << origin[Y] - 1 << " ";
    os << origin[X] - 1 << " " << origin[Y] + width[Y] + 1 << "\n";
}

static void endCompound(ostream& os)
{
    os << CMPTAIL;
}


// Print a BoxGraphNode
void BoxGraphNode::_print(ostream& os, const GraphGC& gc) const
{
    if (gc.printGC->isFig())
	startCompound(os, region(gc));

    RegionGraphNode::_print(os, gc);
    box()->_print(os, (BoxRegion&)region(gc), *gc.printGC);

    if (gc.printGC->isFig())
	endCompound(os);
}

// MARK is a MarkBox in SRC.  Find equivalent box in DUP.
MarkBox *BoxGraphNode::find_mark(Box *dup, Box *src, Box *mark)
{
    if (mark == 0)
	return 0;

    if (src == mark)
    {
	MarkBox *dup_mb = ptr_cast(MarkBox, dup);
	assert(dup_mb != 0);
	return dup_mb;
    }

    // Try Composite children
    CompositeBox *src_cb = ptr_cast(CompositeBox, src);
    if (src_cb != 0)
    {
	CompositeBox *dup_cb = ptr_cast(CompositeBox, dup);
	assert(dup_cb != 0);
	assert(src_cb->nchildren() == dup_cb->nchildren());

	for (int i = 0; i < src_cb->nchildren(); i++)
	{
	    MarkBox *mb = 
		find_mark((*dup_cb)[i], (*src_cb)[i], mark);
	    if (mb)
		return mb;
	}

	return 0;
    }

    // Try HatBox child
    HatBox *src_hb = ptr_cast(HatBox, src);
    if (src_hb != 0)
    {
	HatBox *dup_hb = ptr_cast(HatBox, dup);
	assert(dup_hb != 0);

	return find_mark(dup_hb->box(), src_hb->box(), mark);
    }

    return 0;
}
	

// Copy Constructor
BoxGraphNode::BoxGraphNode(const BoxGraphNode& node):
    RegionGraphNode(node),
    _box(node._box->dup()),
    _highlight(find_mark(_box, node._box, node._highlight))
{}
