'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" 
.so man.macros
.TH open n 7.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
open \- Open a file
.SH SYNOPSIS
.VS
\fBopen \fIfileName\fR ?\fIaccess\fR? ?\fIpermissions\fR?
.VE
.BE

.SH DESCRIPTION
.PP
This command opens a file and returns an identifier
that may be used in future invocations
of commands like \fBread\fR, \fBputs\fR, and \fBclose\fR.
\fIFileName\fR gives the name of the file to open; if it starts with
a tilde then tilde substitution is performed as described for
\fBTcl_TildeSubst\fR.
If the first character of \fIfileName\fR is ``|'' then the
remaining characters of \fIfileName\fR are treated as a command
pipeline to invoke, in the same style as for \fBexec\fR.
In this case, the identifier returned by \fBopen\fR may be used
to write to the command's input pipe or read from its output pipe.
.PP
The \fIaccess\fR argument indicates the way in which the file
(or command pipeline) is to be accessed.
.VS
It may take two forms, either a string in the form that would be
passed to the \fBfopen\fR library procedure or a list of POSIX
access flags.
It defaults to ``\fBr\fR''.
In the first form \fIaccess\fR may have any of the following values:
.VE
.TP 15
\fBr\fR
Open the file for reading only; the file must already exist.
.TP 15
\fBr+\fR
Open the file for both reading and writing; the file must
already exist.
.TP 15
\fBw\fR
Open the file for writing only.  Truncate it if it exists.  If it doesn't
exist, create a new file.
.TP 15
\fBw+\fR
Open the file for reading and writing.  Truncate it if it exists.
If it doesn't exist, create a new file.
.TP 15
\fBa\fR
Open the file for writing only.  The file must already exist, and the file
is positioned so that new data is appended to the file.
.TP 15
\fBa+\fR
Open the file for reading and writing.  If the file doesn't exist,
create a new empty file.
Set the initial access position  to the end of the file.
.PP
In the second form, \fIaccess\fR consists of a list of any of the
.VS
following flags, all of which have the standard POSIX meanings.
One of the flags must be either \fBRDONLY\fR, \fBWRONLY\fR or \fBRDWR\fR.
.TP 15
\fBRDONLY\fR
Open the file for reading only.
.TP 15
\fBWRONLY\fR
Open the file for writing only.
.TP 15
\fBRDWR\fR
Open the file for both reading and writing.
.TP 15
\fBAPPEND\fR
Set the file pointer to the end of the file prior to each write.
.TP 15
\fBCREAT\fR
Create the file if it doesn't already exist (without this flag it
is an error for the file not to exist).
.TP 15
\fBEXCL\fR
If \fBCREAT\fR is also specified, an error is returned if the
file already exists.
.TP 15
\fBNOCTTY\fR
If the file is a terminal device, this flag prevents the file from
becoming the controlling terminal of the process.
.TP 15
\fBNONBLOCK\fR
Prevents the process from blocking while opening the file.
For details refer to your system documentation on the \fBopen\fR system
call's \fBO_NONBLOCK\fR flag.
.TP 15
\fBTRUNC\fR
If the file exists it is truncated to zero length.
.PP
If a new file is created as part of opening it, \fIpermissions\fR
(an integer) is used to set the permissions for the new file in
conjunction with the process's file mode creation mask.
\fIPermissions\fR defaults to 0666.
.VE
.PP
If a file is opened for both reading and writing then \fBseek\fR
must be invoked between a read and a write, or vice versa (this
restriction does not apply to command pipelines opened with \fBopen\fR).
When \fIfileName\fR specifies a command pipeline and a write-only access
is used, then standard output from the pipeline is directed to the
current standard output unless overridden by the command.
When \fIfileName\fR specifies a command pipeline and a read-only access
is used, then standard input from the pipeline is taken from the
current standard input unless overridden by the command.

.SH KEYWORDS
access mode, append, controlling terminal, create, file,
non-blocking, open, permissions, pipeline, process
