;;;; 	Copyright (C) 1995 Free Software Foundation, Inc.
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; 



;;; 				STARTUP CODE FOR GUILE
;;;
;;; This file contains code that must be loaded at run-time (as opposed
;;; to compiled staticly).
;;;
;;; There should be less code in this file. 



;;; {Macros}
;;;

;; actually....hobbit might be able to hack these with a little
;; coaxing
;;

(defmacro define-macro (first . rest)
  (let ((name (if (symbol? first) first (car first)))
	(transformer
	 (if (symbol? first)
	     (car rest)
	     `(lambda ,(cdr first) ,@rest))))
    `(define ,name (defmacro:transformer ,transformer))))


(defmacro define-syntax-macro (first . rest)
  (let ((name (if (symbol? first) first (car first)))
	(transformer
	 (if (symbol? first)
	     (car rest)
	     `(lambda ,(cdr first) ,@rest))))
    `(define ,name (defmacro:syntax-transformer ,transformer))))




(define (gscm-create-top-level) #f)
(define (gscm-destroy-top-level it) #f)


(define load-module-system
  (let ((didit #f))
    (lambda ()
      (for-each load '(modops
		       extlibs
		       libguile
		       slibhooks
		       require
		       init-state))
      (set! didit #t))))




(define batch? #f)

;; Do a very small amount of argument parsing.
;; Grab the initial options -q and -b.  "-b filename"
;; means execute the contents of the named file
;; and then exit.  This is useful in a script
;; that begins:
;;
;; #! guile -qb
;;

(dynamic-wind
 (lambda () #t)

 (lambda ()
   (set! program-arguments
	 (let* ((prog-name (car (program-arguments)))
		(remaining-argv
		 (let loop ((argv (cdr (program-arguments))))
		   (get-option argv
			       '(:q)
			       '(:b)
			       (lambda (opt arg argv)
				 (case opt
				   ((:q)	(assert-load-verbosity #f)
						(verbose 0)
						(loop argv))
				   ((:b)	(set! batch? #t)
						(load-module-system)
						(set! program-arguments (lambda () (cons prog-name argv)))
						(load arg)
						(set! argv (cdr (program-arguments)))
						(loop argv))
				   (else argv))))))
		(args (cons prog-name remaining-argv)))
	   (lambda () args))))

 (lambda () (if batch? (quit))))



(load-module-system)

