/* classes: h_files */

#ifndef DEBUGH
#define DEBUGH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */

#include "__scm.h"



struct scm_mode_flag
{
  char *name;
  int val;
  SCM sym;
};




#ifdef __STDC__
extern SCM scm_debug_mode (SCM new_mode);
extern SCM scm_read_mode (SCM new_mode);
extern SCM scm_print_mode (SCM new_mode);
extern SCM scm_expr_stack (void);
extern SCM scm_procedure_name (SCM proc);
extern SCM scm_object_properties (SCM obj);
extern SCM scm_set_object_properties_x (SCM obj, SCM plist);
extern SCM scm_object_property (SCM obj, SCM key);
extern SCM scm_set_object_property_x (SCM obj, SCM key, SCM val);
extern SCM _scm_make_srcprops (int line, int col, SCM filename, SCM copy);
extern SCM scm_srcprops2plist (SCM obj);
extern SCM scm_source_properties (SCM obj);
extern SCM scm_set_source_properties_x (SCM obj, SCM plist);
extern SCM scm_source_property (SCM obj, SCM key);
extern void scm_init_debug (void);

#else /* STDC */
extern SCM scm_debug_mode ();
extern SCM scm_read_mode ();
extern SCM scm_print_mode ();
extern SCM scm_expr_stack ();
extern SCM scm_procedure_name ();
extern SCM scm_object_properties ();
extern SCM scm_set_object_properties_x ();
extern SCM scm_object_property ();
extern SCM scm_set_object_property_x ();
extern SCM _scm_make_srcprops ();
extern SCM scm_srcprops2plist ();
extern SCM scm_source_properties ();
extern SCM scm_set_source_properties_x ();
extern SCM scm_source_property ();
extern void scm_init_debug ();

#endif /* STDC */





#endif  /* DEBUGH */
