/* classes: h_files */

#ifndef REPLH
#define REPLH
/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include "__scm.h"



extern unsigned char scm_upcase[];
extern unsigned char scm_downcase[];

extern SCM *scm_loc_loadpath;
extern long scm_linum;
extern SCM scm_exitval;
extern SCM scm_filename;
extern long scm_linum;
extern long scm_colnum;

extern int scm_verbose;




#ifdef __STDC__
extern void scm_tables_prehistory (void);
extern void scm_intprint (long n, int radix, SCM port);
extern void scm_ipruk (char *hdr, SCM ptr, SCM port);
extern void scm_iprlist (char *hdr, SCM exp, char tlr, SCM port, int writing);
extern void scm_iprin1 (SCM exp, SCM port, int writing);
extern SCM scm_char_ready_p (SCM port);
extern SCM scm_eof_object_p (SCM x);
extern void scm_fflush (SCM port);
extern SCM scm_force_output (SCM port);
extern SCM scm_write (SCM obj, SCM port);
extern SCM scm_display (SCM obj, SCM port);
extern SCM scm_newline(SCM port);
extern SCM scm_write_char (SCM chr, SCM port);
extern SCM scm_trans_on (SCM fil);
extern SCM scm_trans_off (void);
extern void scm_putc (int c, SCM port);
extern void scm_puts (char *s, SCM port);
extern int scm_lfwrite (char *ptr, sizet size, sizet nitems, SCM port);
extern int scm_lgetc (SCM port);
extern void scm_lungetc (int c, SCM port);
extern SCM scm_read_char (SCM port);
extern SCM scm_peek_char (SCM port);
extern char * scm_grow_tok_buf (SCM tok_buf);
extern SCM scm_read (SCM port, SCM casep);
extern SCM scm_sys_try_load (SCM filename);
extern SCM scm_quit (SCM n);
extern SCM scm_abort (void);
extern SCM scm_restart (void);
extern SCM scm_with_dynamic_root (SCM thunk, SCM error_thunk);
extern SCM scm_app_wdr (SCM proc, SCM a1, SCM args, SCM error);
extern int scm_ldfile(char *path);
extern int scm_ldprog(char *path);
extern SCM scm_eval_string(SCM str);
extern SCM scm_evstr(char *str);
extern SCM scm_load_string(SCM str);
extern void scm_ldstr(char *str);
extern SCM scm_repl_driver (char *initpath);
extern SCM scm_line_number (void);
extern SCM scm_column_num (void);
extern SCM scm_program_arguments (void);
extern void scm_growth_mon (char *obj, long size, char *units);
extern void scm_gc_start (char *what);
extern void scm_gc_end (void);
extern SCM scm_repl_report_reset (void);
extern SCM scm_repl_report_start_timing (void);
extern SCM scm_room (SCM args);
extern void scm_heap_report (void);
extern void scm_exit_report (void);
extern SCM scm_prolixity (SCM arg);
extern SCM scm_repl (SCM prompt, SCM env);
extern SCM scm_current_input_port (void);
extern SCM scm_current_output_port (void);
extern SCM scm_current_error_port (void);
extern SCM scm_set_current_input_port (SCM port);
extern SCM scm_set_current_output_port (SCM port);
extern SCM scm_set_current_error_port (SCM port);
extern SCM scm_compiled_library_path (void);
extern void scm_final_repl (void);
extern void scm_init_repl (int iverbose);

#else /* STDC */
extern void scm_tables_prehistory ();
extern void scm_intprint ();
extern void scm_ipruk ();
extern void scm_iprlist ();
extern void scm_iprin1 ();
extern SCM scm_char_ready_p ();
extern SCM scm_eof_object_p ();
extern void scm_fflush ();
extern SCM scm_force_output ();
extern SCM scm_write ();
extern SCM scm_display ();
extern SCM scm_newline();
extern SCM scm_write_char ();
extern SCM scm_trans_on ();
extern SCM scm_trans_off ();
extern void scm_putc ();
extern void scm_puts ();
extern int scm_lfwrite ();
extern int scm_lgetc ();
extern void scm_lungetc ();
extern SCM scm_read_char ();
extern SCM scm_peek_char ();
extern char * scm_grow_tok_buf ();
extern SCM scm_read ();
extern SCM scm_sys_try_load ();
extern SCM scm_quit ();
extern SCM scm_abort ();
extern SCM scm_restart ();
extern SCM scm_with_dynamic_root ();
extern SCM scm_app_wdr ();
extern int scm_ldfile();
extern int scm_ldprog();
extern SCM scm_eval_string();
extern SCM scm_evstr();
extern SCM scm_load_string();
extern void scm_ldstr();
extern SCM scm_repl_driver ();
extern SCM scm_line_number ();
extern SCM scm_column_num ();
extern SCM scm_program_arguments ();
extern void scm_growth_mon ();
extern void scm_gc_start ();
extern void scm_gc_end ();
extern SCM scm_repl_report_reset ();
extern SCM scm_repl_report_start_timing ();
extern SCM scm_room ();
extern void scm_heap_report ();
extern void scm_exit_report ();
extern SCM scm_prolixity ();
extern SCM scm_repl ();
extern SCM scm_current_input_port ();
extern SCM scm_current_output_port ();
extern SCM scm_current_error_port ();
extern SCM scm_set_current_input_port ();
extern SCM scm_set_current_output_port ();
extern SCM scm_set_current_error_port ();
extern SCM scm_compiled_library_path ();
extern void scm_final_repl ();
extern void scm_init_repl ();

#endif /* STDC */

















#endif  /* REPLH */
