/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>
#include "_scm.h"



/* {Stack Checking}
 */

#ifdef STACK_LIMIT
#ifdef __STDC__
void 
scm_stack_check (void)
#else
void 
scm_stack_check ()
#endif
{
  STACKITEM *start = BASE (rootcont);
  STACKITEM stack;
#ifdef STACK_GROWS_UP
  if (&stack - start > STACK_LIMIT * sizeof (STACKITEM))
#else
  if (start - &stack > STACK_LIMIT * sizeof (STACKITEM))
#endif /* def STACK_GROWS_UP */
    scm_wta (SCM_UNDEFINED, (char *) SEGV_SIGNAL, "stack");
}

#endif
#ifdef __STDC__
long 
scm_stack_size (SCM_STACKITEM *start)
#else
long 
scm_stack_size (start)
     SCM_STACKITEM *start;
#endif
{
  STACKITEM stack;
#ifdef STACK_GROWS_UP
  return &stack - start;
#else
  return start - &stack;
#endif /* def STACK_GROWS_UP */
}

#ifdef __STDC__
void 
scm_stack_report (void)
#else
void 
scm_stack_report ()
#endif
{
  STACKITEM stack;
  scm_intprint (scm_stack_size (BASE (rootcont)) * sizeof (STACKITEM),
		16, cur_errp);
  scm_puts (" of stack: 0x", cur_errp);
  scm_intprint ((long) BASE (rootcont), 16, cur_errp);
  scm_puts (" - 0x", cur_errp);
  scm_intprint ((long) &stack, 16, cur_errp);
  scm_puts ("\n", cur_errp);
}



#ifdef __STDC__
void
scm_init_stackchk (void)
#else
void
scm_init_stackchk ()
#endif
{
#include "stackchk.x"
}

