/* dsrv.c */
/* Last edited by Mike Spreitzer July 17, 1995 1:50 pm PDT */

#include <stdio.h>

#include "Dialog.h"

Dialog_String
server_Dialog_T_M(Dialog_T t, Dialog_String s1, ILU_C_ENVIRONMENT * Env)
{
  char            buf[1000], *ans;
  ilu_cardinal    len;
  printf("Caller sez: '%s'\n", s1);
  printf("Reply: ");
  ans = fgets(buf, 1000, stdin);
  if (ans != buf) {
    fprintf(stderr, "Error reading reply!\n");
    exit(1);
  }
  len = strlen(buf);
  ans = (char *) malloc(len);
  if (ans == NULL) {
    fprintf(stderr, "Unable to malloc reply!\n");
    exit(1);
  }
  strcpy(ans, buf);
  return (unsigned char *) ans;
}

int
main(int argc, char **argv)
{
  ilu_Server      s;
  Dialog_T        t;
  ilu_string      sbh, mstid;
  Dialog__InitializeServer();
  s = ILU_C_InitializeServer("DialogTest-Server", NULL, NULL, NULL, ilu_TRUE);
  if (s == NULL) {
    fprintf(stderr, "Unable to create ILU server!\n");
    exit(1);
  }
  t = Dialog_T__CreateTrue("it", s, NULL);
  if (t == NULL) {
    fprintf(stderr, "Unable to create ILU object!\n");
    exit(1);
  }
  sbh = ILU_C_SBHOfObject(t);
  printf("SBH = '%s'\n", sbh);
  ILU_C_Run();
}
