/* $Id: clnt.c,v 1.15 1996/02/12 07:39:05 spreitze Exp $ */
/* Last edited by Mike Spreitzer February 11, 1996 11:22 pm PST */

#include <stdio.h>
#include <stdlib.h>

#include "Test1.h"
#include "Test2.h"
#include "Test3.h" 

static void Print_CSS(Test1_CSS css)
{
  int             i;
  printf("<");
  for (i = 0; i < css._length; i++)
    printf("%s\"%s\"", (i ? ", " : ""), css._buffer[i]);
  printf(">");
}

static void Print_R(Test1_R r)
{
  printf("[%lu, ", (long unsigned) r.i);
  Print_CSS(r.css);
  printf(", <\"%s\", \"%s\", \"%s\">]",
	 r.a[0], r.a[1], r.a[2]);
}

static void Print_RO (Test1_RO ro)
{
  if (ro != ILU_NIL)
    Print_R(*ro);
  else
    printf("nil");
}

static void Print_U(Test1_U u)
{
  switch (u._d) {
  case Test1_TheU__R:
    printf("R");
    Print_R(u._u.R);
    break;
  case Test1_TheU__RO:
    printf("RO ");
    Print_RO(u._u.RO);
    break;
  case Test1_TheU__CSS:
    printf("CSS");
    Print_CSS(u._u.CSS);
    break;
  case Test1_TheU__O1:
    printf("O1[%s]", ILU_C_SBHOfObject(u._u.O1));
    break;
  case Test1_TheU__OO:
    if (u._u.OO == ILU_NIL)
      printf("OO[NIL]");
    else
      printf("OO[%p]", ILU_C_SBHOfObject(u._u.OO));
    break;
  case Test1_TheU__boolean:
    printf("BOOLEAN[%s]", u._u.boolean ? "TRUE" : "FALSE");
    break;
  default:
    printf("invalid tag %d", u._d);
  }
}

int main(int ac, char **av)
{
  Test1_O1        handle;
  Test1_O2        o2;
  Test1_O3        o3;
  float           f;
  ILU_C_ENVIRONMENT s = {0};
  Test1_U         u;
  Test1_CSS       css;
  Test1_ScS       scs[3];
  Test1_RO        ro;
  Test1_R         r;
  ilu_byte       *ap;

  Test1__Initialize();
  Test3__Initialize();

#if 0
#if (defined(SECURE_TRANSPORT) && defined(INCLUDE_SSL_SECMECH))
  _gss_scm_ssl_init();
#endif
#endif

  if ((handle = ILU_C_LookupObject("Test1-Server", "Test1_Initial_Object",
				   Test1_O1__MSType)) == NULL) {
    fprintf(stderr, "Unable to import object!\n");
    exit(1);
  }
#if 0
  if (ac < 2)
    exit(1);
  if ((handle = Test1_O1__CreateFromSBH(av[1], NULL)) == NULL)
    exit(1);
#endif
  u._d = Test1_U__boolean;
  u._u.boolean = 1;
  scs[0] = (Test1_ScS) "hello world";
  scs[1] = (Test1_ScS) "hello mars";
  css = Test1_CSS_Create(2, scs);
  u = Test1_O1_U_CSS_to_U(handle, &u, &css, &s);
  printf("Test1.O1.U-CSS-to-U() => ");
  Print_U(u);
  printf("\n");
  ro = Test1_O1_f_CSS_to_RO(handle, &css, &s);
  printf("Test1.O1.f-CSS-to-RO() => ");
  Print_RO(ro);
  printf("\n");

  f = Test1_O1_R_ScS_to_F(handle, ro, scs[0], &s);
  if (ILU_C_SUCCESSFUL(&s))
    printf("f=%f\n", f);
  else
    printf("Test1.O1.R-ScS-to-F() raises \"%s\"\n", s.returnCode);

  Test1_O1_a_RO(handle, ILU_NIL, &s);

  o2 = Test1_O1_get_O2(handle, &s);
  if (ILU_C_SUCCESSFUL(&s)) {
    Test1_A0        a = {9, 0, 2, 1, 0, 255, 16};
    Test1_A1        a1;
    Test1_I         i = 47;
    Test1_CSS       css2;

    printf("got O2, sbh = %s\n", ILU_C_SBHOfObject(o2));

    css2 = Test1_O2_OO_A0_to_CSS(o2, handle, a, &s);
    if (ILU_C_SUCCESSFUL(&s)) {
      printf("Test1.O2.OO-A0-to-CSS() => ");
      Print_CSS(css2);
      printf("\n");
    } else {
      printf("Test1.O2.OO-A0-to-CSS() raises \"%s\"\n",
	     s.returnCode);
    }

    r.css._length = 0;
    r.css._buffer = NULL;
    r.css._maximum = 0;
    r.i = 12;
    r.a[0] = (Test1_ScS) "this is";
    r.a[1] = (Test1_ScS) "data";
    r.a[2] = (Test1_ScS) "initialization";
    a1[0] = (Test1_ScS) "but this";
    a1[1] = (Test1_ScS) "is";
    a1[2] = (Test1_ScS) "fun";
    ap = Test1_O2_R_I_A1_to_I_A0(o2, &r, &i, a1, &s);
    if (ILU_C_SUCCESSFUL(&s)) {
      int             j;
      printf("O2.R-I-A1-to-I-A0() => i=%lu, res=<",
	     (long unsigned) i);
      for (j = 0; j < 8; j++)
	printf(" %d", ap[j]);
      printf(">\n");
    } else {
      printf("O2.R-I-A1-to-I-A0() raises \"%s\"\n", s.returnCode);
    }
  } else {
    printf("couldn't get an instance of O2.  Exception is \"%s\".\n",
	   s.returnCode);
  }

  o3 = Test1_O1_get_O3(handle, ilu_FALSE, &s);
  if (ILU_C_SUCCESSFUL(&s)) {
    Test1_RS        rs = Test1_RS_Create(0, NULL);
    Test1_IS        i2;

    printf("got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3),
	   ILU_C_ClassName(o3));

    if (ILU_C_ClassRecordOfInstance(o3)
	!= ILU_C_FindILUClassByTypeName("Test1.O3")) {
      printf("instance of class %s received!\n", ILU_C_ClassName(o3));
    } else {
      i2 = Test1_O3_RS_R_to_R_IS(o3, &rs, &r, &s);
      Test1_O3_O1_U_to_U(o3, handle, &u, &s);
      if (ILU_C_SUCCESSFUL(&s)) {
	printf("Test1.O3.O1-U-to-U => ");
	Print_U(u);
	printf("\n");
      } else {
	printf("Test1.O3.O1-U-to-U raises %s\n", s.returnCode);
      }
    }
  } else {
    printf("couldn't get an instance of O3.  Exception is \"%s\".\n",
	   s.returnCode);
  }

  /* this next call should return an instance of Test3.O */
  o3 = Test1_O1_get_O3(handle, ilu_TRUE, &s);
  if (ILU_C_SUCCESSFUL(&s)) {
    Test1_RS        rs = Test1_RS_Create(0, NULL);
    Test1_IS        i2;

    printf("got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3),
	   ILU_C_ClassName(o3));

    i2 = Test1_O3_RS_R_to_R_IS(o3, &rs, &r, &s);
    Test1_O3_O1_U_to_U(o3, handle, &u, &s);
      if (ILU_C_SUCCESSFUL(&s)) {
	printf("Test1.O3.O1-U-to-U => ");
	Print_U(u);
	printf("\n");
      } else {
	printf("Test1.O3.O1-U-to-U raises %s\n", s.returnCode);
      }

    if (ILU_C_ClassRecordOfInstance(o3)
	== ILU_C_FindILUClassByTypeName("Test3.O")) {
      Test1_U         u2;

      u2 = Test3_O_I_to_Test1U(o3, 397, &s);
      if (!ILU_C_SUCCESSFUL(&s)) {
	printf("Test3.O.I-to-Test1U raises \"%s\"\n",
	       s.returnCode);
      } else {
	printf("Test3.O.I-to-Test1U() => ");
	Print_U(u2);
	printf("\n");
      }
    }
  } else {
    printf("couldn't get an instance of O3.  Exception is \"%s\".\n",
	   s.returnCode);
  }

  /* this next call should return an instance of Test1.O4 */
  o3 = Test1_O1_get_O3(handle, ilu_FALSE, &s);
  if (ILU_C_SUCCESSFUL(&s)) {
    printf("got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3),
	   ILU_C_ClassName(o3));

    if (ILU_C_ClassRecordOfInstance(o3)
	== ILU_C_FindILUClassByTypeName("Test1.O4")) {
      ilu_real        r1, r2;

      r2 = Test1_O4_R_to_R(o3, r1 = 12345.6789, &s);
      if (!ILU_C_SUCCESSFUL(&s)) {
	printf("Test1_O2_OO_A0_to_CSS() raises \"%s\"\n",
	       s.returnCode);
      } else
	printf("doubles:  r1 is %.10f, r2 is %.10f\n", r1, r2);
    }
  } else {
    printf("couldn't get an instance of O3.  Exception is \"%s\".\n",
	   s.returnCode);
  }

  exit(0);
}
