/* m_matri2.cc		-*- C++ -*-
 *$Header: /al/acs/src/RCS/m_matri2.cc,v 9.26 95/10/31 16:12:22 al Exp $
 * Sparse matrix package
 * Bump and spike - bordered block diagonal pattern
 */
/* This kluge is because there is something wrong with templates
 * on my system (Next - gcc2.2.2).
 * There is also a problem with recursive includes with SGI's NCC and DCC
 * *** DO NOT *** compile this file directly.  Include it from m_matrix.cc
 * A future release (after I update my compiler) will require working templates
 */
#ifdef BSMATRIX
/*--------------------------------------------------------------------------*/
#include "m_matrix.h"
/*--------------------------------------------------------------------------*/
//template <class T>
void BSMATRIX::uninit()
{
  unallocate();
  delete [] Lownode;
  Lownode = NULL;
}
/*--------------------------------------------------------------------------*/
//template <class T>
void BSMATRIX::init(int s)
{
  Trash = Zero = 0.;
  nzcount = 0;
  Size = s;
  rowptr = colptr = diaptr = NULL;
  space = NULL;
  Lownode = new int[Size+1];
  assert(Lownode);
  int ii;
  for (ii = 0;  ii <= Size;  ++ii)
    Lownode[ii] = ii;
}
/*--------------------------------------------------------------------------*/
/* iwant: indicate that "iwant" to allocate this spot in the matrix
 */
//template <class T>
void BSMATRIX::iwant(int node1, int node2)
{
  assert(Lownode);
  assert(node1 <= Size);
  assert(node2 <= Size);
  if (node1 == 0  ||  node2 == 0){	/* node 0 is ground, and doesn't    */
    ;					/* count as a connection	    */
  }else if (node1 < Lownode[node2]){
    Lownode[node2]=node1;
  }else if (node2 < Lownode[node1]){
    Lownode[node1]=node2;
  }
}
/*--------------------------------------------------------------------------*/
//template <class T>
void BSMATRIX::unallocate()
{
  assert (Zero == 0.);
  delete [] rowptr;
  delete [] colptr;
  delete [] diaptr;
  delete [] space;
  rowptr = colptr = diaptr = NULL;
  space = NULL;
}
/*--------------------------------------------------------------------------*/
/* allocate: really get the space to work
 */
//template <class T>
void BSMATRIX::allocate()
{
  assert(Lownode);
  nzcount = 0;
  int ii;
  for (ii = 0;   ii <= Size;   ++ii)
    nzcount += 2 * (ii - Lownode[ii]) + 1;

  colptr = new T*[Size+1];
  rowptr = new T*[Size+1];
  diaptr = new T*[Size+1];
  space  = new T[nzcount];
  assert(colptr);
  assert(rowptr);
  assert(diaptr);
  zero();

  T* point = space;
  for (ii = 0;   ii <= Size;   ++ii){
    colptr[ii] = point - Lownode[ii];
    rowptr[ii] = colptr[ii] + 2*ii;
    diaptr[ii] = colptr[ii] + ii;
    point += 2 * (ii - Lownode[ii]) + 1;
  }
}
/*--------------------------------------------------------------------------*/
//template <class T>
T& BSMATRIX::s(int row, int col)
{
  assert(Lownode);
  assert(0 <= col);
  assert(col <= Size);
  assert(0 <= row);
  assert(row <= Size);
  if (col == row){
    return d(row,col);
  }else if (col > row){			/* above the diagonal */
    if (row == 0)
      return Trash;
    else if (row < Lownode[col])
      return Zero;
    else
      return u(row,col);
  }else{/* if (col < row) */		/* below the diagonal */
    if (col == 0)
      return Trash;
    else if (col < Lownode[row])
      return Zero;
    else
      return l(row,col);
  }
}
/*--------------------------------------------------------------------------*/
/* zero: wipe the whole array
 */
//template <class T>
void BSMATRIX::zero()
{
  assert(space);
  Trash = Zero = 0.;
  int ii;
  for (ii = 0;  ii < nzcount;  ii++){
    space[ii] = Zero;
  }
}
/*--------------------------------------------------------------------------*/
/* dezero: make sure(?) the diagonal is non-zero
 */
//template <class T>
void BSMATRIX::dezero(T& offset)
{
  int ii;
  for (ii = 1;  ii <= Size;  ii++){
    d(ii,ii) += offset;
  }
}
/*--------------------------------------------------------------------------*/
//template <class T>
double BSMATRIX::density()
{
  if (Size > 0){
    assert(Lownode);
    nzcount = 0;
    int ii;
    for (ii = 0;   ii <= Size;   ++ii)
      nzcount += 2 * (ii - Lownode[ii]) + 1;
    return (double)(nzcount-1)/(Size*Size);
  }else{
    assert(Size == 0);
    return 0;
  }
}
/*--------------------------------------------------------------------------*/
//template <class T>
T& BSMATRIX::SubtractDotProduct(int rr, int cc, int dd)
{
  assert(Lownode);
  int kk = max(Lownode[rr], Lownode[cc]);
  int len = dd - kk;
  T& dot = m(rr, cc);
  if (len > 0){
    T* row = &(l(rr,kk));
    T* col = &(u(kk,cc));
    /* for (ii = kk;   ii < dd;   ii) */
    int ii;
    for (ii = 0;   ii < len;   ++ii){
      dot -= row[-ii] * col[ii];
    }
  }
  return dot;
}
/*--------------------------------------------------------------------------*/
//template <class T>
T& BSMATRIX::SubtractDotProduct(int rr, int cc, int dd, T& in)
{
  assert(Lownode);
  int kk = max(Lownode[rr], Lownode[cc]);
  int len = dd - kk;
  T& dot = m(rr, cc);
  dot = in;
  if (len > 0){
    T* row = &(l(rr,kk));
    T* col = &(u(kk,cc));
    /* for (ii = kk;   ii < dd;   ++ii) */
    int ii;
    for (ii = 0;   ii < len;   ++ii){
      dot -= row[-ii] * col[ii];
    }
  }
  return dot;
}
/*--------------------------------------------------------------------------*/
//template <class T>
void BSMATRIX::lu_decomp()
{
  int ii, jj, mm;
  int bn;
  
  assert(Lownode);
  STATUS::lud.start();
  for (mm = 1;   mm <= Size;   ++mm){
    bn = Lownode[mm];
    if (bn < mm){
      u(bn,mm) /= d(bn,bn);
      for (ii =bn+1;  ii<mm;  ii++){
	/* (m(ii,mm) -= dot(ii,mm,ii)) /= d(ii,ii); */
	SubtractDotProduct(ii,mm,ii) /= d(ii,ii);
      }
      for (jj = bn+1;  jj<mm;  jj++){
	/* m(mm,jj) -= dot(mm,jj,jj); */
	SubtractDotProduct(mm,jj,jj);
      }
      /* jj == mm */{
	/* m(mm,mm) -= dot(mm,mm,mm); then test */
	if (SubtractDotProduct(mm,mm,mm) == 0.){
	  error(bWARNING, "open circuit: node %u\n", mm);
	  d(mm,mm) = OPT::gmin;
	}
      }
    }else{    /* bn == mm */
      if (d(mm,mm)==0.){
	d(mm,mm) = OPT::gmin;
      }
    }
  }
  STATUS::lud.stop();
}
/*--------------------------------------------------------------------------*/
/* fbsub: forward and back sub, shared storage
 * v = right side vector, changed in place to solution vector
 */
//template <class T>
void BSMATRIX::fbsub(T* v)
{
  int jj, ii;
  
  assert(Lownode);
  assert(v);
  STATUS::back.start();
  for (ii = 1; ii <= Size; ++ii){	    /* forward substitution */
    for (jj = Lownode[ii]; jj < ii; ++jj){
      v[ii] -= l(ii,jj) * v[jj];
    }
    v[ii] /= d(ii,ii);
  }
  for (jj = Size; jj > 1; --jj){	    /* back substitution    */
    for (ii = Lownode[jj]; ii < jj; ++ii){
      v[ii] -= u(ii,jj) * v[jj];
    }
  }
  STATUS::back.stop();
}
/*--------------------------------------------------------------------------*/
/* fbsub: forward and back sub, separate storage
 * b = right side vector
 * c = intermediate vector after fwd sub
 * x = solution vector
 */
//template <class T>
void BSMATRIX::fbsub(T* x, const T* b, T* c)
{
  int jj, ii;
  
  assert(Lownode);
  assert(x);
  assert(b);
  assert(c);
  STATUS::back.start();
  if (!c){
    c = x;
    if (!b)
      b = x;
  }
  for (ii = 1; ii <= Size; ++ii){	    /* forward substitution */
    c[ii] = b[ii];
    for (jj = Lownode[ii]; jj < ii; ++jj){
      c[ii] -= l(ii,jj) * c[jj];
    }
    c[ii] /= d(ii,ii);
  }
  for (ii = Size; ii >= 1; --ii){
    x[ii] = c[ii];
    nstat[ii].aiter = STATUS::iter[iTOTAL];
  }
  for (jj = Size; jj > 1; --jj){	    /* back substitution    */
    for (ii = Lownode[jj]; ii < jj; ++ii){
      x[ii] -= u(ii,jj) * x[jj];
    }
  }
  STATUS::back.stop();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
