/* s_ac_swp.cc
 *$Header: /al/acs/src/RCS/s_ac_swp.cc,v 9.25 95/10/29 01:45:35 al Exp $
 * ac sweep control
 */
#include "constant.h"
#include "util.h"
#include "io.h"
#include "s_ac.h"
/*--------------------------------------------------------------------------*/
//	void	AC::sweep();
//	void	AC::first();
//	int	AC::next();
/*--------------------------------------------------------------------------*/
void AC::sweep()
{
  head(start, stop, linswp, "Freq");
  first();
  do {
    jomega = COMPLEX(0., freq * kPIx2);
    solve();
    out(freq);
  } while (next());
}
/*--------------------------------------------------------------------------*/
void AC::first()
{
  freq = start;
}
/*--------------------------------------------------------------------------*/
int AC::next()
{
  double realstop;

  if (IO::whence)
    return TRUE;
  realstop = (linswp)
    ? stop - step/100.
    : stop / pow(step,.01);
  if (!inorder(start, freq, realstop))
    return FALSE;
  freq = (linswp)
    ? freq + step
    : freq * step;
  if (inorder(freq, start, stop))
    return FALSE;
  return TRUE;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
