/* s_dc_set.cc
 *$Header: /al/acs/src/RCS/s_dc_set.cc,v 9.21 95/10/21 18:10:11 al Exp $
 * dc analysis setup
 */
#include "ap.h"
#include "e_card.h"
#include "error.h"
#include "io.h"
#include "u_opt.h"
#include "u_cardst.h"
#include "s_dc.h"
/*--------------------------------------------------------------------------*/
//	void	DCOP::finish(void);
//	void	OP::setup(CS&);
//	void	DC::setup(CS&);
//	void	DCOP::options(CS&);
//	void	DCOP::by(CS&);
//	void	DCOP::decade(CS&);
//	void	DCOP::times(CS&);
/*--------------------------------------------------------------------------*/
static DCOP *This;	/* latest parameters for arg passing and "finish"   */
static CARDSTASH stash[DCNEST]; /* store std values of elements being swept */
/*--------------------------------------------------------------------------*/
void DCOP::finish(void)
{
  int ii;
  if (This){
    for (ii = 0;  ii < DCNEST && exists(This->zap[ii]);  ii++){
      stash[ii].restore();
      This->zap[ii]->expand();		/* BUG: may be redundant */
    }
    This = NULL;
  }
}
/*--------------------------------------------------------------------------*/
void OP::setup(CS& cmd)
{
  zap[0] = (CARD*)NULL;
  sweepval[0] = &temp;
  start[0] = (cmd.is_float()) ? cmd.ctof()-ABS_ZERO : OPT::tempamb;
  stop[0]  = (cmd.is_float()) ? cmd.ctof()-ABS_ZERO : start[0];
  step[0] = 0.;
  genout = 0.;
  options(cmd);
  if (step[0] == 0.){
    step[0] = stop[0] - start[0];
    linswp[0] = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DC::setup(CS& cmd)
{
  CARD *target;

  target = findbranch(cmd, CARD::first(), CARD::last());
  if (exists(target)){			/* sweep a component */
    zap[0] = target;
  }else if (cmd.is_float()){		/* sweep the generator */
    zap[0] = (CARD*)NULL;
  }					/* else leave it alone */
  
  if (cmd.is_float()){			/* set up parameters */
    start[0] = cmd.ctof();
    stop[0] = (cmd.is_float()) ? cmd.ctof() : start[0];
    step[0] = 0.;
  }					/* else leave it alone */
  
  if (exists(zap[0])){
    stash[0] = zap[0];			/* stash the std value */
    zap[0]->x = (generic_t*)NULL;	/* zap out the extensions */
    sweepval[0] = &(zap[0]->val); 	/* point to value to patch */
  }else{
    sweepval[0] = &genout;		/* point to value to patch */
  }
  
  genout = 0.;
  temp = OPT::tempamb;
  options(cmd);
  if (step[0] == 0.){
    step[0] = stop[0] - start[0];
    linswp[0] = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void DCOP::options(CS& cmd)
{
  This = this;
  IO::where |= IO::mstdout;
  alarmlist = PROBE_LISTS::alarm[mode];
  plotlist  = PROBE_LISTS::plot[mode];
  printlist = PROBE_LISTS::print[mode];
  storelist = PROBE_LISTS::store[mode];
  IO::ploton = IO::plotset  &&  plotlist.count() > 0;
  uic = loop = reverse = cont = trace = FALSE;
  worstcase = wNONE;
  for (;;){
    if (cmd.argparse(REPEAT,
	"*",		aFFUNCTION, times,
    	"ACMAx",	aENUM,	    &worstcase,	  wMAXAC,
	"ACMIn",	aENUM,	    &worstcase,	  wMINAC,
	"Ambient",	aODOUBLE,   &temp,	  OPT::tempamb,
	"By",		aFFUNCTION, by,
	"Continue",	aENUM,	    &cont,	  TRUE,
    	"DCMAx",	aENUM,	    &worstcase,	  wMAXDC,
	"DCMIn",	aENUM,	    &worstcase,	  wMINDC,
	"Decade",	aFFUNCTION, decade,
	"LAg",		aENUM,	    &worstcase,   wLAG,
	"LEad",		aENUM,	    &worstcase,   wLEAD,
	"LOop",		aENUM,	    &loop,	  TRUE,
	"MAx",		aENUM,	    &worstcase,   wMAXDC,
	"MIn",		aENUM,	    &worstcase,   wMINDC,
	"NOPlot",	aENUM,	    &IO::ploton,  FALSE,
	"PLot",		aENUM,	    &IO::ploton,  TRUE,
	"Reftemp",	aODOUBLE,   &temp,	  OPT::tnom,
	"REverse",	aENUM,	    &reverse,	  TRUE,
	"SEnsitivity",	aENUM,	    &worstcase,   wSENS,
	"Temperature",	aODOUBLE,   &temp,	  -ABS_ZERO,
	"TRace",	aFINT,	    &trace,
	"TImes",	aFFUNCTION, times,
	"WAtch",	aENUM,	    &trace,	  tITERATION,
	"")){
	;	
    }else if (cmd.is_float()){
      by(cmd);
    }else if (outset(cmd,"","")){
      ;
    }else{
      cmd.check(bWARNING);
      break;
    }
  }
  initio(IO::where,(FILE*)NULL);
  if (worstcase == wRAND   ||   worstcase == wWORST)
    IO::ploton = FALSE;
}
/*--------------------------------------------------------------------------*/
/*static*/ void DCOP::by(CS& cmd)
{
  This->step[0] = cmd.ctof();
  This->linswp[0] = TRUE;
  if (This->step[0] == 0.)
    This->step[0] = This->stop[0] - This->start[0];
}
/*--------------------------------------------------------------------------*/
/*static*/ void DCOP::decade(CS& cmd)
{
  double junk = cmd.ctopf();
  if (junk == 0.)
    junk = 1.;
  junk = pow(10., 1./junk);
  This->step[0] = junk;
  This->linswp[0] = FALSE;
}
/*--------------------------------------------------------------------------*/
/*static*/ void DCOP::times(CS& cmd)
{
  This->step[0] = cmd.ctopf();
  This->linswp[0] = FALSE;
  if (This->step[0] == 0.  &&  This->start[0] != 0.)
    This->step[0] = This->stop[0] / This->start[0];
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
