/* u_timer.cc
 *$Header: /al/acs/src/RCS/u_timer.cc,v 9.28 95/11/04 15:32:09 al Exp $
 * Time a command, or whatever
 */
/*--------------------------------------------------------------------------*/
#include "error.h"
#include "io.h"
#include "u_timer.h"
/*--------------------------------------------------------------------------*/
//		TIMER::TIMER();
//		TIMER::TIMER(const char*);
//	void	TIMER::fullreset();
//	void	TIMER::reset();
//	void	TIMER::zstart();
//	void	TIMER::start();
//	void	TIMER::stop();
//	void	TIMER::check();
//	void	TIMER::print();
//	TIMER&	TIMER::operator=(const TIMER&);
	TIMER	operator-(const TIMER&,const TIMER&);
/*--------------------------------------------------------------------------*/
extern char e_int[];
/*--------------------------------------------------------------------------*/
TIMER::TIMER()
{
  fullreset();
}
/*--------------------------------------------------------------------------*/
TIMER::TIMER(const char* label)
{
  strncpy(name, label, LABELEN);
  name[LABELEN] = '\0';
  fullreset();
}
/*--------------------------------------------------------------------------*/
void TIMER::fullreset()
{
  total_user   = 0.;
  total_system = 0.;
  reset();
}
/*--------------------------------------------------------------------------*/
void TIMER::reset()
{
  last_user   = 0.;
  last_system = 0.;
  ref_user    = 0.;
  ref_system  = 0.;
  running = FALSE;
}
/*--------------------------------------------------------------------------*/
void TIMER::zstart()
{
  reset();
  start();
}
/*--------------------------------------------------------------------------*/
void TIMER::start()
{
  if (running){
    error(bWARNING, e_int, "clock already running");
    check();
  }else{
    struct rusage x;
    getrusage(RUSAGE_SELF,&x);
    ref_user =
      (double)(x.ru_utime.tv_sec) + (double)(x.ru_utime.tv_usec)*1e-6; 
    ref_system =
      (double)(x.ru_stime.tv_sec) + (double)(x.ru_stime.tv_usec)*1e-6; 
    running = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
void TIMER::stop()
{
  if (!running){
    error(bWARNING, e_int, "clock not running");
  }else{
    struct rusage x;
    double utime, stime;
    double runtime;
    getrusage(RUSAGE_SELF,&x);
    
    utime=(double)(x.ru_utime.tv_sec)+(double)(x.ru_utime.tv_usec)*1e-6; 
    runtime = utime - ref_user;
    ref_user	=  0.;
    last_user	+= runtime;
    total_user	+= runtime;
    
    stime=(double)(x.ru_stime.tv_sec)+(double)(x.ru_stime.tv_usec)*1e-6; 
    runtime = stime - ref_system;
    ref_system   =  0.;
    last_system	 += runtime;
    total_system += runtime;
    running = FALSE;
  }
}
/*--------------------------------------------------------------------------*/
void TIMER::check()
{
  if (running){
    stop();
    start();
  }
}
/*--------------------------------------------------------------------------*/
void TIMER::print()
{
  mprintf(IO::mstdout, "%10s %8.2f %8.2f %8.2f   %8.2f %8.2f %8.2f\n", name,
	  last_user,  last_system,  last_user  + last_system,
	  total_user, total_system, total_user + total_system);
}
/*--------------------------------------------------------------------------*/
TIMER& TIMER::operator=(const TIMER& x)
{
  last_user    = x.last_user;
  last_system  = x.last_system;
  ref_user     = x.ref_user;
  ref_system   = x.ref_system;
  total_user   = x.total_user;
  total_system = x.total_system;
  running      = x.running;
  // but don't copy the name
  return *this;
}
/*--------------------------------------------------------------------------*/
TIMER operator-(const TIMER& x, const TIMER& y)
{
  TIMER z("temp");
  z.last_user    = x.last_user    - y.last_user;
  z.last_system  = x.last_system  - y.last_system;
  z.ref_user     = 0.;	// when did the difference start running?
  z.ref_system   = 0.;
  z.total_user   = x.total_user   - y.total_user;
  z.total_system = x.total_system - y.total_system;
  z.running      = FALSE;
  // but don't copy the name
  return z;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
