.TH libtws 3 "08 November 1986"
.SH NAME
libtws \- alternate date and time routines including parsing
.SH SYNOPSIS
.nf
.fc ^ ~
.ta \w'char *dtimezone( offset, flags );  'u
include "tws.h"
.PP
^struct tws *dlocaltime( clock );~^/* local clock into tws */
long *clock;
.PP
^struct tws *gmtime( clock );~^/* GMT clock into tws */
long *clock;
.PP
^char *dtime( clock );~^/* clock into string */
long *clock;
.PP
^long twclock( t );~^/* tws into clock */
struct tws *t;
.PP
^long twjuliandate( t );~^/* tws into Julian day number */
struct tws *t;
.PP
^struct tws *dparsetime( str );~^/* string into tws */
char *str;
.PP
^char *dctime( t );~^/* tws into string */
struct tws *t;
.PP
^char *dasctime( t, flags );~^/* tws into string */
struct tws *t;
int flags;
.PP
^char *dtimezone( offset, flags );~^/* timezone into string */
int offset, flags;
.PP
^char *dtwszone( t );~^/* tws's timezone into string */
struct tws *t;
.PP
^char *dtimemow( );~^/* current time into string */
.PP
^struct tws *dtwstime( );~^/* current time into tws */
.PP
^void twscopy( tot, fromt );~^/* copy a tws */
struct tws *tot, *fromt;
.PP
^int twsort( t1, t2 );~^/* compare two tws's */
struct tws *t1, *t2;
.PP
^long twsubtract( t1, t2 );~^/* seconds between t2 and t1 */
struct tws *t1, *t2;
.fi
.SH DESCRIPTION
.I Libtws
is a fairly complete date/time library.
Unlike the standard Unix date/time routines,
.I libtws
will parse date/time strings into internal form.
The format for specifying date/time strings is pretty loose - basically
the same as the format for date/times in network mail.
.PP
Most of the routines do not use the Unix(R) "clock" time
format, and therefore are not limited to dates after 01 January 1970.
In particular, twsubtract() lets you subtract two dates without
converting them to "clock" form.
.SH "SEE\ ALSO"
.IR ctime(3),
.IR time(3)
.SH AUTHOR
Most of
.I libtws
came from version 6.5 of the MH message
handling system, courtesy of Marshall Rose.
Some improvements (?) were added by Jef Poskanzer.
.SH BUGS
The return values point to static data whose contents are overwritten
by the next call.
.PP
The basic Unix time format (clock) only goes back to 1970, limiting
applications somewhat.
