;-*-emacs-lisp-*-

(provide 'vm-init)

;; Autoloads as per README

(autoload 'vm "vm" "Start VM on your primary inbox." t)
(autoload 'vm-other-frame "vm" "Like `vm' but starts in another frame." t)
(autoload 'vm-visit-folder "vm" "Start VM on an arbitrary folder." t)
(autoload 'vm-visit-virtual-folder "vm" "Visit a VM virtual folder." t)
(autoload 'vm-mode "vm" "Run VM major mode on a buffer" t)
(autoload 'vm-mail "vm" "Send a mail message using VM." t)
(autoload 'vm-submit-bug-report "vm" "Send a bug report about VM." t)

;; Fixes for Debian

(setq vm-pop-md5-program "md5sum")
(setq vm-toolbar-pixmap-directory "/usr/lib/emacs/site-lisp/vm/etc")
(setq load-path (cons "/usr/lib/emacs/site-lisp/vm" load-path))

;; Useful stuff

; From: kyle_jones@wonderworks.com (Kyle Jones)
; Sender: info-vm-request@uunet.uu.net
; To: carney@gvc.dec.com
; Cc: info-vm@uunet.uu.net
; Subject: filename completion in FCC:
; Date: Sun, 6 Aug 1995 13:24:08 -0400
;
; Stephen Carney writes:
; > Is it possible to have filename completion in the FCC field of
; > the message header?
;
; This might be worth adding to VM.

(require 'comint)

(defun mail-mode-smart-tab ()
  (interactive)
  (if (save-excursion
	(beginning-of-line)
	(looking-at "FCC: "))
      (comint-dynamic-complete)
    (tab-to-tab-stop)))

(add-hook 'mail-setup-hook
	  '(lambda () (local-set-key "\t" 'mail-mode-smart-tab)))
