/************************************************************************
 * utils.c -- various utilities for rpncalc				*
 *									*
 * A little RPN (Reverse Polish Notation) calculator,                   *
 * rudimentary emulating a HP 28S. 					*
 * 								        *
 * rpncalc is (c) David Frey, 1993, 1994, 1995				*
 *								        * 
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *									* 
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *									* 
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *									* 
 ************************************************************************/

/* $Id: utils.c,v 1.0 1995/12/31 18:19:34 david Rel $
 * $Log: utils.c,v $
 * Revision 1.0  1995/12/31 18:19:34  david
 * Initial revision
 *
 * Revision 1.0  1995/11/25 20:02:25  david
 * Initial revision
 * */

#include <stdio.h>
#include <stdlib.h>

void *xmalloc(size_t size)	/* safe malloc */
{
  void *ptr;

  ptr=malloc(size);
  if (ptr == NULL) 
  {
    perror("Out of memory!"); 
    exit(1); 
  }

  return ptr;
}

void *xrealloc(void *ptr, size_t size)
{
  ptr=realloc(ptr, size);
  if (ptr == NULL) 
  {
    perror("Out of memory!"); 
    exit(1); 
  }

  return ptr;
}
