/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
* 	 
*	    Copyright (C) 1995 Matthias Ettrich
*
*======================================================*/

#include <forms.h>
#include <stdlib.h>

#if defined(sgi) && !defined(__GNUC__)
#include <bstring.h>
#endif

#include "config.h"
#include "credits.h"
#include "paths.h"
#include "credits_form.h"

/* extern */
extern char * system_lyxdir;

/**** Forms and Objects ****/

static FD_form_credits *fd_form_credits = NULL;

void CreditsOKCB(FL_OBJECT *, long) {
      fl_hide_form(fd_form_credits->form_credits);
      fl_free_form(fd_form_credits->form_credits);
      fd_form_credits->form_credits = NULL;
}

/*---------------------------------------*/
/* read credits from file and display them */
void ShowCredits()
{
   char * real_file;
   char buffer[256];
   FILE *file;
   
   /* generate the credits form if it doesn't exist */
   
   if (!fd_form_credits || !fd_form_credits->form_credits) {
   
      /* read the credits into the browser */ 
      
      /* try file LYX_DIR/CREDITS */ 
      real_file = AddName (NULL, system_lyxdir, "CREDITS");
      fd_form_credits = create_form_form_credits();

      if (!fl_load_browser(fd_form_credits->browser_credits, real_file)) {
	 fl_add_browser_line(fd_form_credits->browser_credits, "ERROR: LyX wasn't able to read $(LYXDIR)/CREDITS");
	 fl_add_browser_line(fd_form_credits->browser_credits, "");
	 fl_add_browser_line(fd_form_credits->browser_credits, "Please install correctly to estimate the great");
	 fl_add_browser_line(fd_form_credits->browser_credits, "amount of work other people have done for the LyX project.");
	 
      }
      
      if (fd_form_credits->form_credits->visible) {
	      fl_raise_form(fd_form_credits->form_credits);
      } else
	fl_show_form(fd_form_credits->form_credits,
		     FL_PLACE_CENTER | FL_FREE_SIZE,FL_FULLBORDER,
		     "Credits");
      return;
      
      if (!(file = fopen(real_file, "r"))) {
	 /* default credits */
	 fl_add_browser_line(fd_form_credits->browser_credits, "ERROR: LyX wasn't able to read $(LYXDIR)/CREDITS");
	 fl_add_browser_line(fd_form_credits->browser_credits, "");
	 fl_add_browser_line(fd_form_credits->browser_credits, "Please install correctly to estimate the great");
	 fl_add_browser_line(fd_form_credits->browser_credits, "amount of work other people have done for the LyX project.");
      }
      else  {
	 while (!feof(file)) {
	    BZERO(buffer, sizeof(buffer));
	    if ((fgets(buffer, sizeof(buffer), file)!=NULL)) {
	       fl_add_browser_line(fd_form_credits->browser_credits, buffer);
	    }
	 }
	 fclose(file);
      }
      delete real_file;
   }
}

