// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 * 	 
 *	    Copyright (C) 1995 Matthias Ettrich
 *
 *======================================================*/
#ifndef _LYXINSET_H
#define _LYXINSET_H

#include <stdio.h>
#include <X11/Xlib.h>
#include "lyxfont.h"

/* insets */ 
class Inset {
public:
  virtual ~Inset(){};
   
  virtual int Ascent(LyXFont font)=0;
  virtual int Descent(LyXFont font)=0;
  virtual int Width(LyXFont font)=0;
  virtual LyXFont ConvertFont(LyXFont font);
  virtual void Draw(LyXFont font, unsigned long  pm, int baseline, float &x)=0;
  virtual void Edit(int, int);
  virtual char Editable();
  virtual char AutoDelete();
  virtual void Write(FILE *file)=0;
  virtual void Read(FILE *file)=0;
  virtual int Latex(FILE *file)=0; // returns the number of rows (\n's) of generated tex code
  virtual char Deletable();
  virtual Inset* Clone()=0;

  /* returns LyX code associated with the inset. Used for TOC, ...) */
  virtual char LyxCode();

  // used for autocorrection
  virtual Bool IsEqual(Inset* /*other*/){
    return False;
  }


  /* returns true to override begin and end inset in file */
  virtual char DirectWrite();

  // Returns true if the inset should be centered alone
  virtual char Display() { return 0; }  
 
  // Changes the display state of the inset
  virtual void SetDisplay(bool) {  }  
};


//  Updatable Insets. These insets can be locked and receive
//  directly user interaction. Currently used only for mathed.
//  Note that all pure methods from Inset class are pure here too.
//  [Alejandro 080596] 

 /* Extracted from Matthias notes:
  * 
  * An inset can simple call LockInset in it's edit call and *ONLY* 
  * in it's edit call.
  *
  * Unlocking is either done by LyX or the inset itself with a 
  * UnlockInset-call
  *
  * During the lock, all button and keyboard events will be modified
  * and send to the inset through the following inset-features. Note that
  * Inset::InsetUnlock will be called from inside UnlockInset. It is meant
  * to contain the code for restoring the menus and things like this.
  * 
  * If a inset wishes any redraw and/or update it just has to call
  * UpdateInset(this).
  * 
  * It's is completly irrelevant, where the inset is. UpdateInset will
  * find it in any paragraph in any buffer. 
  * Of course the_locking_inset and the insets in the current paragraph/buffer
  *  are checked first, so no performance problem should occur.
  */

 class UpdatableInset: public Inset {
  public:
    virtual ~UpdatableInset() { };
    
    virtual char Editable();
   
    // may call ToggleLockedInsetCursor
    virtual void ToggleInsetCursor();
    bool cursor_visible;
  
    virtual void InsetButtonPress(int x, int y, int button);
    virtual void InsetButtonRelease(int x, int y, int button);
   
    virtual void InsetKeyPress(XKeyEvent *ev);
    virtual void InsetMotionNotify(int x, int y, int state);
    virtual void InsetUnlock();
   
    //  An updatable inset could handle lyx editing commands
    virtual char *LocalDispatch(int, char*) { return NULL; };
};


#endif

