// -*- C++ -*-
//  Generalized simple lexical analizer.
//  It can be used for simple syntax parsers, like lyxrc,
//  texclass and others to come.   [asierra30/03/96]
//
//   (C) 1996 Lyx Team.
#ifndef LYXLEX_H
#define LYXLEX_H

//#define LEX_MAX_BUFF 255

// Lex basic codes
#define LEX_UNDEF  -1
#define LEX_FEOF   -2
#define LEX_DATA   -3
#define LEX_TOKEN  -4

struct keyword_item {
   char* tag;
   short code;
};

class LyXLexClass { 
 public:
   LyXLexClass(keyword_item*, int);
   ~LyXLexClass() { };
   bool IsOK();
   void setFile(const char* filename);
   int lex();                  //  returns a lex code
   bool next(void);            //  just read the next token

   int GetLineNo() { return lineno; }
   int GetInteger();
   bool GetBool();
   float GetFloat();
   char* GetString(char *prev=NULL);
   bool EatLine();
   int FindToken(const char* string[]);
   
   char *text(void) {  return &buff[0]; }
	void pushTable(keyword_item*, int);
	void popTable();
	void printTable();
 protected:

	enum{ LEX_MAX_BUFF = 255 };
	
	struct pushed_table {
		pushed_table(){
			next=NULL;
			table_elem=NULL;
		}
		pushed_table *next;
		keyword_item *table_elem;
		int table_siz;
	};
	
   FILE *file;
   int lineno;
   keyword_item *table;
   int no_items;
   char buff[LEX_MAX_BUFF];
   pushed_table *pushed;
   int search_kw(char *);
   short status;
};


inline
bool LyXLexClass::IsOK()
{
   return (file && !feof(file));
 }

#endif
