// -*- C++ -*-
/* ======================================================================= *\
    File   : lyxserver.h, $Id: lyxserver.h,v 1.2 1996/05/22 00:58:29 larsbj Exp $
    Author : chb, 2.Nov.1995
    Docu   : see lyxserver.C
    Purpose: prototypes for the lyxserver LyX subsystem
\* ======================================================================= */

#ifndef _LYXSERVER_H_
#define _LYXSERVER_H_

#include <unistd.h>

/* --- i/o pipes --------------------------------------------------------- */

class lyxcomm
{
 public:
   int infd;
   int outfd;
   char *pipename;

 public:
   lyxcomm()
   {
      infd = outfd = -1; pipename = "";
   }
  ~lyxcomm()
   {
      if(infd > -1)
      {
         close(infd);
         char *tmp = new char[strlen(pipename)+4];
         strcpy(tmp, pipename);
         strcat(tmp, ".in");
         unlink(tmp);
         delete tmp;
      }
      if(outfd > -1)
      {
         close(outfd);
         char *tmp = new char[strlen(pipename)+5];
         strcpy(tmp, pipename);
         strcat(tmp, ".out");
         unlink(tmp);
         delete tmp;
      }
   }
};

extern lyxcomm lyxpipes;

/* --- prototypes -------------------------------------------------------- */

void LyxServerInit();
void LyxNotifyClient(char *);
void ServerCallback(int fd, void *clientdata);

#endif /* _LYXSERVER_H_ */

/* === End of File: lyxserver.h ========================================== */
