/*
 * gltt graphics library
 * Copyright (C) 1998 Stephane Rehel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FTGlyphPolygonizer_h
#define __FTGlyphPolygonizer_h

#ifndef __GLTTboolean_h
#include "GLTTboolean.h"
#endif

struct _TT_Glyph_Metrics;
typedef struct _TT_Glyph_Metrics TT_Glyph_Metrics;
struct _TT_Outline;
typedef struct _TT_Outline TT_Outline;

class FTGlyph;

/////////////////////////////////////////////////////////////////////////////

class FTGlyphPolygonizer
{
public:
  struct POINT
    {
    double x, y;
    };

protected:
  FTGlyph* glyph;

  TT_Glyph_Metrics* metrics;
  TT_Outline* outline;

  // needed distance between two bezier curve evaluations (in pixels)
  double precision;

  int nContours;
  int cur_contour;

public:
  FTGlyphPolygonizer();

  virtual ~FTGlyphPolygonizer();

  GLTTboolean init( FTGlyph* _glyph );

  void setPrecision( double _precision );

  int getNContours() const
    {
    return nContours;
    }

  // 0 <= c < nContours
  GLTTboolean getContour( int c );

  int getNContourPoints() const
    {
    return nPoints;
    }

  // 0 <= i < nPoints
  POINT* getContourPoint( int i ) const;

  // 0 <= i < nPoints
  void getContourPoint( int i, double& x, double& y ) const;

  double getBearingX() const;
  double getBearingY() const;
  double getAdvance() const;

private:
  void add_point( double x, double y );
  int nPoints;
  POINT* points;
  int max_points;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __FTGlyphPolygonizer_h
