#include <syscall.h>
#include <sys/socket.h>
#include <sys/socketcall.h>

#ifdef __SVR4_I386_ABI_L1__
#define socketcall __socketcall
#else
static inline
_syscall2(long,socketcall,int,call,unsigned long *,args);
#endif

int
listen(int sockfd, int backlog)
{
	unsigned long args[2];

	args[0] = sockfd;
	args[1] = backlog;
	return socketcall(SYS_LISTEN, args);
}

#ifdef __ELF__
#ifdef __GNUC__
int listen(int, int) __attribute ((weak));
#else
#pragma weak listen
#endif   /* __GNUC__ */
#endif   /* __ELF__ */
