//=======================================================================
//@V@:Note: This file generated by vgen V1.00 (10:45:42 AM 12 Sep 1996).
//	dinocmdw.cpp:	Source for DinoCmdWindow class
//=======================================================================

#include <v/vnotice.h>	// for vNoticeDialog
#include <v/vkeys.h>	// to map keys

#include "dinocmdw.h"	// our header
#include "dinocnv.h"

//	Start defines for the main window with 100

//@V@:BeginIDs
    enum {
	m_FirstCmd = 100, // Dummy Command
	lblSpin,	// label for spin
	sldSpeed,	// speed of spin
	btnStep,
	lblTestStat,	// Status Bar test
	blkLast		// Last item
      };
//@V@:EndIDs

//@V@:BeginPulldownMenu FileMenu
    static vMenu FileMenu[] =
      {
	{"E&xit", M_Exit, isSens, notChk, noKeyLbl, noKey, noSub},
	{NULL}
      };
//@V@:EndPulldownMenu


//@V@:BeginMenu StandardMenu
    static vMenu StandardMenu[] =
      {
	{"&File", M_File, isSens, notUsed, notUsed, noKey, &FileMenu[0]},
	{NULL}
      };
//@V@:EndMenu

//@V@:BeginCmdPane ToolBar
    static CommandObject ToolBar[] =
      {
	{C_Button,M_Exit,0,"Quit",NoList,CA_None,isSens,NoFrame,0,0},
	{C_Label,lblSpin,0,"Spin Speed:",NoList,CA_None,isSens,NoFrame,0,0},
	{C_Slider,sldSpeed,0,"",NoList,CA_Horizontal,isSens,NoFrame,0,0},
	{C_Button,btnStep,0,"Step",NoList,CA_None,isSens,NoFrame,0,0},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };
//@V@:EndCmdPane

//@V@:BeginStatPane StatBar
    static vStatus StatBar[] =
      {
	{"OpenGL/V Demo Program", lblTestStat, CA_NoBorder, isSens, 0},
	{0,0,0,0,0}
      };
//@V@:EndStatPane

//====================>>> DinoTimer::TimerTick <<<====================
  void DinoTimer::TimerTick()
  {
    cmdw->DinoCanvas->Spin();
  }

//====================>>> DinoCmdWindow::DinoCmdWindow <<<====================
  DinoCmdWindow::DinoCmdWindow(char* name, int height, int width) :
    vCmdWindow(name, height, width)
  {
    UserDebug1(Constructor,"DinoCmdWindow::DinoCmdWindow(%s) Constructor\n",name)

    // The Menu Bar
    DinoMenu = new vMenuPane(StandardMenu);
    AddPane(DinoMenu);

    // The Command Pane
    DinoCmdPane = new vCommandPane(ToolBar);
    AddPane(DinoCmdPane);

    // The Canvas
    DinoCanvas = new DinoCanvasPane(vGL_RGB | vGL_Depth | vGL_DoubleBuffer);
    AddPane(DinoCanvas);

    // The Status Bar
    DinoStatus = new vStatusPane(StatBar);
    AddPane(DinoStatus);

    _timer = new DinoTimer(this);             // create timer
    _spinSpeed = 0;

    // Show Window

    ShowWindow();

  }

//====================>>> DinoCmdWindow::~DinoCmdWindow <<<====================
  DinoCmdWindow::~DinoCmdWindow()
  {
    UserDebug(Destructor,"DinoCmdWindow::~DinoCmdWindow() destructor\n")

    // Now put a delete for each new in the constructor.

    delete DinoMenu;
    delete DinoCanvas;
    delete DinoCmdPane;
    delete DinoStatus;
  }

//====================>>> DinoCmdWindow::KeyIn <<<====================
  void DinoCmdWindow::KeyIn(vKey keysym, unsigned int shift)
  {
    vCmdWindow::KeyIn(keysym, shift);
  }

//====================>>> DinoCmdWindow::WindowCommand <<<====================
  void DinoCmdWindow::WindowCommand(ItemVal id, ItemVal val, CmdType cType)
  {
    // Default: route menu and toolbar commands here


    UserDebug1(CmdEvents,"dinoCmdWindow:WindowCommand(%d)\n",id)

    switch (id)
      {
	//@V@:Case M_Exit
	case M_Exit:
	  {
	    theApp->Exit();
	    break;
	  }	//@V@:EndCase


	//@V@:Case btnTestTool
	case sldSpeed:
	  {
	    if (val != 0)			// Start spinning
	      {
		_timer->TimerStop();
		_timer->TimerSet((100-val)*2);
 	      }
	    else
	      {
		_timer->TimerStop();
	      }

	    break;
	  }	//@V@:EndCase


	case btnStep:
	  {
	    if (GetValue(sldSpeed) != 0)
	      {
		_timer->TimerStop();
		SetValue(sldSpeed,0,Value);
	      }
	    DinoCanvas->Spin();
	    break;
 	  }

	default:		// route unhandled commands up
	  {
	    vCmdWindow::WindowCommand(id, val, cType);
	    break;
	  }
      }
  }
