//=======================================================================
//@V@:Note: This file generated by vgen V1.00 (10:45:42 AM 12 Sep 1996).
//	dinocnv.cpp:	Source for DinoCanvasPane class
//=======================================================================

#include "dinocnv.h"


/* Dino drawing code Copyright (c) Mark J. Kilgard, 1996. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#include <math.h>


GLfloat angle = -150;   /* in degrees */
GLdouble bodyWidth = 2.0;


typedef enum {
  RESERVED, BODY_SIDE, BODY_EDGE, BODY_WHOLE, ARM_SIDE, ARM_EDGE, ARM_WHOLE,
  LEG_SIDE, LEG_EDGE, LEG_WHOLE, EYE_SIDE, EYE_EDGE, EYE_WHOLE, DINOSAUR
} displayLists;

void extrudeSolidFromPolygon(GLfloat data[][2], unsigned int dataSize,
  GLdouble thickness, GLuint side, GLuint edge, GLuint whole);

void extrudeSolidFromPolygon(GLfloat data[][2], unsigned int dataSize,
  GLdouble thickness, GLuint side, GLuint edge, GLuint whole);

GLfloat body[][2] = { {0, 3}, {1, 1}, {5, 1}, {8, 4}, {10, 4}, {11, 5},
  {11, 11.5}, {13, 12}, {13, 13}, {10, 13.5}, {13, 14}, {13, 15}, {11, 16},
  {8, 16}, {7, 15}, {7, 13}, {8, 12}, {7, 11}, {6, 6}, {4, 3}, {3, 2},
  {1, 2} };
GLfloat arm[][2] = { {8, 10}, {9, 9}, {10, 9}, {13, 8}, {14, 9}, {16, 9},
  {15, 9.5}, {16, 10}, {15, 10}, {15.5, 11}, {14.5, 10}, {14, 11}, {14, 10},
  {13, 9}, {11, 11}, {9, 11} };
GLfloat leg[][2] = { {8, 6}, {8, 4}, {9, 3}, {9, 2}, {8, 1}, {8, 0.5}, {9, 0},
  {12, 0}, {10, 1}, {10, 2}, {12, 4}, {11, 6}, {10, 7}, {9, 7} };
GLfloat eye[][2] = { {8.75, 15}, {9, 14.7}, {9.6, 14.7}, {10.1, 15},
  {9.6, 15.25}, {9, 15.25} };
GLfloat skinColor[] = {0.1, 1.0, 0.1, 1.0};   /* Green */
GLfloat eyeColor[] = {1.0, 0.2, 0.2, 1.0};    /* Red */

void
makeDinosaur(void)
{
  GLfloat bodyWidth = 3.0;

  extrudeSolidFromPolygon(body, sizeof(body), bodyWidth,
    BODY_SIDE, BODY_EDGE, BODY_WHOLE);
  extrudeSolidFromPolygon(arm, sizeof(arm), bodyWidth / 4,
    ARM_SIDE, ARM_EDGE, ARM_WHOLE);
  extrudeSolidFromPolygon(leg, sizeof(leg), bodyWidth / 2,
    LEG_SIDE, LEG_EDGE, LEG_WHOLE);
  extrudeSolidFromPolygon(eye, sizeof(eye), bodyWidth + 0.2,
    EYE_SIDE, EYE_EDGE, EYE_WHOLE);
  glNewList(DINOSAUR, GL_COMPILE);
    glMaterialfv(GL_FRONT, GL_DIFFUSE, skinColor);
    glCallList(BODY_WHOLE);
    glPushMatrix();
      glTranslatef(0.0, 0.0, bodyWidth);
      glCallList(ARM_WHOLE);
      glCallList(LEG_WHOLE);
      glTranslatef(0.0, 0.0, -bodyWidth - bodyWidth / 4);
      glCallList(ARM_WHOLE);
      glTranslatef(0.0, 0.0, -bodyWidth / 4);
      glCallList(LEG_WHOLE);
      glTranslatef(0.0, 0.0, bodyWidth / 2 - 0.1);
      glMaterialfv(GL_FRONT, GL_DIFFUSE, eyeColor);
      glCallList(EYE_WHOLE);
    glPopMatrix();
  glEndList();
}

void
extrudeSolidFromPolygon(GLfloat data[][2], unsigned int dataSize,
  GLdouble thickness, GLuint side, GLuint edge, GLuint whole)
{
  static GLUtriangulatorObj *tobj = NULL;
  GLdouble vertex[3], dx, dy, len;
  int i;
  int count = dataSize / (2 * sizeof(GLfloat));

  if (tobj == NULL) {
    tobj = gluNewTess();  /* create and initialize a GLU
                             polygon tessellation object */
    gluTessCallback(tobj, GLU_BEGIN, glBegin);
    gluTessCallback(tobj, GLU_VERTEX, glVertex2fv);  /* tricky */
    gluTessCallback(tobj, GLU_END, glEnd);
  }
  glNewList(side, GL_COMPILE);
    glShadeModel(GL_SMOOTH);  /* smooth minimizes seeing
                                 tessellation */
    gluBeginPolygon(tobj);
    for (i = 0; i < count; i++) {
      vertex[0] = data[i][0];
      vertex[1] = data[i][1];
      vertex[2] = 0;
      gluTessVertex(tobj, vertex, &data[i]);
    }
    gluEndPolygon(tobj);
  glEndList();
  glNewList(edge, GL_COMPILE);
    glShadeModel(GL_FLAT);  /* flat shade keeps angular hands
                               from being "smoothed" */
    glBegin(GL_QUAD_STRIP);
    for (i = 0; i <= count; i++) {
      /* mod function handles closing the edge */
      glVertex3f(data[i % count][0], data[i % count][1], 0.0);
      glVertex3f(data[i % count][0], data[i % count][1], thickness);
      /* Calculate a unit normal by dividing by Euclidean
         distance.  We could be lazy and use glEnable(GL_NORMALIZE)
	 so we could pass in arbitrary normals for a very slight
	 performance hit. */
      dx = data[(i + 1) % count][1] - data[i % count][1];
      dy = data[i % count][0] - data[(i + 1) % count][0];
      len = sqrt(dx * dx + dy * dy);
      glNormal3f(dx / len, dy / len, 0.0);
    }
    glEnd();
  glEndList();
  glNewList(whole, GL_COMPILE);
    glFrontFace(GL_CW);
    glCallList(edge);
    glNormal3f(0.0, 0.0, -1.0);  /* constant normal for side */
    glCallList(side);
    glPushMatrix();
      glTranslatef(0.0, 0.0, thickness);
      glFrontFace(GL_CCW);
      glNormal3f(0.0, 0.0, 1.0);  /* reverse normal for other side */
      glCallList(side);
    glPopMatrix();
  glEndList();
}

GLfloat lightZeroPosition[] = {10.0, 4.0, 10.0, 1.0};
GLfloat lightZeroColor[] = {0.8, 1.0, 0.8, 1.0}; /* green-tinted */
GLfloat lightOnePosition[] = {-1.0, -2.0, 1.0, 0.0};
GLfloat lightOneColor[] = {0.6, 0.3, 0.2, 1.0};  /* red-tinted */

void
contextInit(void)
{
  glEnable(GL_CULL_FACE);  /* Up to 50% better perfomance than no
                              back-face culling. */
  glEnable(GL_DEPTH_TEST); /* Enable depth buffering. */

  glLightModeli(GL_LIGHT_MODEL_LOCAL_VIEWER, 1);
  glLightfv(GL_LIGHT0, GL_POSITION, lightZeroPosition);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, lightZeroColor);
  glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 0.1);
  glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.05);
  glLightfv(GL_LIGHT1, GL_POSITION, lightOnePosition);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, lightOneColor);

  /* Enable both lights. */
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glEnable(GL_LIGHTING);

  /* Set up projection transform. */
  glMatrixMode(GL_PROJECTION);
  gluPerspective(
    40.0,               /* Field of view in degree */
    1.0,                /* Aspect ratio */
    1.0,                /* Z near */
    40.0);              /* Z far */

  /* Now, change to modelview. */
  glMatrixMode(GL_MODELVIEW);
  gluLookAt(
    0.0, 0.0, 30.0,     /* Eye is at (0,0,30) */
    0.0, 0.0, 0.0,      /* Center is at (0,0,0) */
    0.0, 1.0, 0.);      /* Up is in positive Y direction */
  glPushMatrix();       /* Dummy push so we can pop on model
                           recalc. */
}

  static int initDone = 0;

//===================>>> DinoCanvasPane::DinoCanvasPane <<<====================
  DinoCanvasPane::DinoCanvasPane(unsigned int glmode) : vBaseGLCanvasPane(glmode)
  {
  }

//===================>>> DinoCanvasPane::~DinoCanvasPane <<<====================
  DinoCanvasPane::~DinoCanvasPane()
  {
  }

//==================>>> DinoCanvasPane::graphicsInit <<<========================
  void DinoCanvasPane::graphicsInit(void)
  {
    vBaseGLCanvasPane::graphicsInit();	// Always call the superclass first!

    makeDinosaur();
    contextInit();

    glPopMatrix();    /* Pop old rotated matrix (or dummy
    matrix if first time). */
    glPushMatrix();
    glRotatef(angle, 0.0, 1.0, 0.0);
    glTranslatef(-8, -8, -bodyWidth / 2);

    initDone = 1;
  }

//======================>>> DinoCanvasPane::Spin <<<========================
  void DinoCanvasPane::Spin()
  {
    vglMakeCurrent();

    // Code from glxdino:
    glPopMatrix();    /* Pop old rotated matrix (or dummy
    matrix if first time). */
    glPushMatrix();
    angle -= 10;
    glRotatef(angle, 0.0, 1.0, 0.0);
    glTranslatef(-8, -8, -bodyWidth / 2);
    // End glxdino code

    Redraw(0,0,0,0);
  }

//======================>>> DinoCanvasPane::HPage <<<========================
  void DinoCanvasPane::HPage(int shown, int top)
  {
    vBaseGLCanvasPane::HPage(shown, top);
  }

//======================>>> DinoCanvasPane::VPage <<<========================
  void DinoCanvasPane::VPage(int shown, int top)
  {
    vBaseGLCanvasPane::VPage(shown, top);
  }

//=======================>>> DinoCanvasPane::HScroll <<<======================
  void DinoCanvasPane::HScroll(int step)
  {
    vBaseGLCanvasPane::HScroll(step);
  }

//======================>>> DinoCanvasPane::VScroll <<<======================
  void DinoCanvasPane::VScroll(int step)
  {
    vBaseGLCanvasPane::VScroll(step);
  }

//======================>>> DinoCanvasPane::MouseDown <<<======================
  void DinoCanvasPane::MouseDown(int X, int Y, int button)
  {
    vBaseGLCanvasPane::MouseDown(X,Y,button);
  }

//========================>>> DinoCanvasPane::MouseUp <<<======================
  void DinoCanvasPane::MouseUp(int X, int Y, int button)
  {
    vBaseGLCanvasPane::MouseUp(X,Y,button);
  }

//======================>>> DinoCanvasPane::MouseMove <<<======================
  void DinoCanvasPane::MouseMove(int x, int y, int button)
  {
    vBaseGLCanvasPane::MouseMove(x,y,button);
  }

//=========================>>> DinoCanvasPane::Redraw <<<======================
  void DinoCanvasPane::Redraw(int x, int y, int w, int h)
  {

    static inRedraw = 0;

    if (inRedraw || !initDone)	// Don't know if i need this or not...
 	return;

    inRedraw = 1;

    vglMakeCurrent();

    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glCallList(DINOSAUR);

    vglFlush();

    inRedraw = 0;

  }

//======================>>> DinoCanvasPane::Resize <<<======================
  void DinoCanvasPane::Resize(int w, int h)
  {
    vBaseGLCanvasPane::Resize(w,h);
  }
