
static char rcsid[] = "@(#)$Id: remail.c,v 5.13 1993/09/27 01:51:38 syd Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 5.13 $   $State: Exp $
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** For those cases when you want to have a message continue along
    to another person in such a way as they end up receiving it with
    the return address the person YOU received the mail from (does
    this comment make any sense yet?)...

**/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

extern int errno;

char *error_description();
extern void display_to();

static void remail_sent P_((FILE *fd, char * title, struct run_state *rs,
			    int ret, int exit_stat));

int
remail()
{
	/** remail a message... returns TRUE if new foot needed ... **/
	
	FILE *mailfd;
	char entered[VERY_LONG_STRING], expanded[VERY_LONG_STRING];
	char *filename, buffer[VERY_LONG_STRING], ch;
	char *mailerflags[20], **argv;
	int mf_idx = 0;
	int  err;
	extern char *tempnam();

	entered[0] = '\0';

	get_to(entered, expanded, 
	       sizeof entered, sizeof expanded);
	if (strlen(entered) == 0)
	  return(0);

	display_to(expanded);

	if((filename=tempnam(temp_dir, "snd.")) == NULL) {
	  dprint(1, (debugfile, "couldn't make temp file nam! (remail)\n"));
	  sprintf(buffer, catgets(elm_msg_cat, ElmSet, ElmCouldntMakeTempFileName,
		"Sorry - couldn't make file temp file name."));
	  set_error(buffer);
	  return(1);
	}

        if ((mailfd = safeopen_rdwr(filename)) == NULL) {
	  err = errno;
	  dprint(1, (debugfile, "couldn't open temp file %s! (remail)\n", 
		  filename));
	  dprint(1, (debugfile, "** %s **\n", error_description(err)));
	  sprintf(buffer, catgets(elm_msg_cat, ElmSet, ElmCouldntOpenForWriting,
			"Sorry - couldn't open file %s for writing (%s)."),
		  error_description(err));
	  set_error(buffer);
	  free(filename);
	  return(1);
	}

	/** now let's copy the message into the newly opened
	    buffer... **/

	(void) elm_chown(filename, userid, groupid);

#ifdef MMDF
	if (strcmp(submitmail, mailer) == 0)
	  do_mmdf_addresses(mailfd, strip_parens(strip_commas(expanded)));
#endif /* MMDF */

	copy_message(mailfile,headers[current-1],
		     "", mailfd, CM_REMOTE | CM_MMDF_HEAD | CM_REMAIL);

	/** Got the messsage, now let's ensure the person really wants to 
	    remail it... **/

	ClearLine(elm_LINES-1);
	ClearLine(elm_LINES);
	MCsprintf(buffer, catgets(elm_msg_cat, ElmSet, ElmSureYouWantToRemail,
	    "Are you sure you want to remail this message (%c/%c)? "),
	    *def_ans_yes, *def_ans_no);
	fflush(stdin);
	ch = want_to(buffer, *def_ans_yes, elm_LINES-1, 0);
	if (ch == *def_ans_no) { /* another day, another No... */
	  set_error(catgets(elm_msg_cat, ElmSet, ElmBounceCancelled,
		"Bounce of message canceled."));
	  (void) unlink(filename);
	  free(filename);
	  fclose(mailfd);
	  return(1);
	}

	mailerflags[mf_idx++] = mailer;
	
	if (strcmp(sendmail, mailer) == 0
#ifdef SITE_HIDING
	    && ! is_a_hidden_user(username)
#endif
	    ) {
	  mailerflags[mf_idx++] = "-oi";
	  mailerflags[mf_idx++] = "-oem";
	  if (sendmail_verbose)
	    mailerflags[mf_idx++] = "-v";
	  if (metoo) 
	    mailerflags[mf_idx++] = "-om";
	  
	} else if (strcmp(submitmail, mailer) == 0) {
	  mailerflags[mf_idx++] = "-mlrnv";
	} else if (strcmp(execmail, mailer) == 0) {
	  if (sendmail_verbose)
	    mailerflags[mf_idx++] = "-d";
	  if (metoo)
	    mailerflags[mf_idx++] = "-m";
	} 
	
#ifdef MIME
	{
	  struct header_rec *current_header = headers[current-1];
	  if (current_header -> status & MIME_MESSAGE) {
	    int encoding = current_header->mime_rec.encoding;

	    if (encoding == ENCODING_BINARY && 
		!(headers[current-1]->binary)) {
	      dprint(2,(debugfile,
			"Remail: resets encoding=BINARY to encoding=8BIT\n"));
	      encoding = ENCODING_8BIT;
	    }

#ifdef USE_8BITMIME
	  if (encoding == ENCODING_8BIT)
	    mailerflags[mf_idx++] = "-B8BITMIME";
#endif
#ifdef USE_BINARYMIME
          if (encoding == ENCODING_BINARY)
            /* With -BBINARYMIME lines must terminate with \r\n
             * Unix's \n is _NOT_ sufficient - K E H              */
	    mailerflags[mf_idx++] = "-BBINARYMIME";
#endif
	  }
	}
#endif

	mailerflags[mf_idx] = NULL;

	if (strcmp(submitmail, mailer) == 0)
	  argv = mailerflags;
	else {
	  char **argvt = argv_from_to(expanded);
	  argv = join_argv(mailerflags,argvt);
	  free(argvt);
	}

	{
	  struct run_state RS;
	  int options = SY_ENV_SHELL;
	  int ret;

	  if (!sendmail_verbose)
	    options |= SY_NOTTY;

	  fseek (mailfd, 0, 0);
#ifdef _POSIX_VERSION
 	  fflush(mailfd);  /* Synzronize underlying file descriptor */
#else
 	  seek(fileno(mailfd),0,0);
#endif

	  ret=start_run(&RS, options, argv, fileno(mailfd),-1);
	  if (ret) {
	    int exit_code;
	    int backgrounded = 0;
	    char title[80];

	    sprintf(title, "Remail to %.50s...",expanded);

	    ret = run_already_done(&RS,&exit_code);
	    if (0 == ret) {
	      error(catgets(elm_msg_cat, ElmSet, ElmResendingMail,
			    "Resending mail..."));

	      fflush(stdout);

#ifdef BACKGROUD_PROCESSES       /* We assume POSIX in here */
	      if (background_wait_time) {
		int tmp;
		dprint(4, (debugfile, 
			   "Sleeping ( %d seconds ) for completion!\n",
			   background_wait_time));
		tmp = sleep(background_wait_time);  
		/* POSIX sleep returns time in left on
		 * interrupt -- when sendmail terminates
		 * we will get interrupt (SIGCHLD signal)
		 */
		if (tmp > 0) {
		  dprint(4, (debugfile, 
			     " -- sleeping interrupted, %d seconds left!\n",
			     tmp));
		} else if (tmp < 0) {
		  dprint(4, (debugfile, 
			     " -- sleeping failed?\n",
			     tmp));
		}
		ret = run_already_done(&RS,&exit_code);
		if (0 == ret) 
		  ret = maybe_background(&RS,&exit_code,
					 mailfd,title,remail_sent);
		if (0 == ret) {
		  error(
			      catgets(elm_msg_cat, ElmSet, 
				      ElmResendingMailBackground,
				      "Resending mail... in background"));
		  fflush(stdout);
		  backgrounded = 1;
		}
  	      } else
#endif
	      ret = wait_end(&RS,&exit_code);
	    }
	    if (!backgrounded)
	      remail_sent(mailfd,title,&RS,ret,exit_code);	    

	  } else {
	    if (RS.save_errno)
	      error2("Failed: %.30s: %.40s",
		     argv[0],error_description(RS.save_errno));
	    else
	      error1("Can't start %.30s",argv[0]);
	  }
	}
	if (argv != mailerflags)
	  free(argv);

	fclose(mailfd);
	unlink(filename);
    	free(filename);

	return(1);
}

static void remail_sent (fd,title,rs,ret,exit_code)
     FILE *fd; 
     char * title;
     struct run_state *rs;
     int ret; 
     int exit_code;
{
  char very_long_buffer[90];
  lower_prompt(title);

  if (ret < 0) 
    error1("%.30s fail: Signal?",mailer);
  else if (ret > 0) {
    if (rs->save_errno)
      error2("Failed: %.30s: %.40s",
	     mailer,error_description(rs->save_errno));
    else if (exit_code) {
      char very_long_buffer[200];
      sprintf(very_long_buffer, catgets(elm_msg_cat, ElmSet, 
					ElmMailerReturnedError,
					"mailer returned error status %d"), 
	      exit_code);
      error(very_long_buffer);
    } else
      error(catgets(elm_msg_cat, ElmSet, ElmMailResent, "Mail resent."));
  } else {
    error2("%.30s lost: %.40s",
	   mailer,error_description(rs->save_errno));
  }
}

#ifdef MMDF
do_mmdf_addresses(dest_file,buffer)
FILE *dest_file;
char *buffer;
{
	char old[VERY_LONG_STRING], first[VERY_LONG_STRING], 
		rest[VERY_LONG_STRING];

	strfcpy(old,buffer, sizeof old);
	split_word(old, first, rest);
	while (strcmp(first, "") != 0) {
	  fprintf(dest_file, "%s\n", first);
	  strfcpy(old, rest, sizeof old);
	  split_word(old, first, rest);
	}
	fprintf(dest_file, "\n");
}
#endif /* MMDF */
