;;; mew-win32.el --- Settings for Mew on Win32

;; Author:  Shuichi Kitaguchi <kit@Mew.org>
;; Created: Dec 05, 1997
;; Revised: Feb 04, 1998

;;; Code:

(defconst mew-win32-version "mew-win32.el 0.20")

;; Win32 programs.
(setq mew-w32-exec         "fiber.exe")

;; programs.
(setq mew-prog-mime-encode "mewencode.exe")
(setq mew-prog-mime-decode "mewdecode.exe")
(setq mew-prog-tar         "tar.exe")
(setq mew-prog-compress    "compress.exe")
(setq mew-prog-gzip        "gzip.exe")
(setq mew-prog-shell       shell-file-name)

(setq mew-prog-pgpe        "pgp.exe")
(setq mew-prog-pgps        "pgp.exe")
(setq mew-prog-pgpv        "pgp.exe")
(setq mew-prog-pgpk        "pgp.exe")

(setq mew-prog-utime       "utime.exe")
(setq mew-touch-folder-p   t)

(setq mew-prog-uncompface  "uncompface.exe")

(setq mew-prog-text/html     mew-w32-exec)
(setq mew-prog-text/html-arg nil)
(setq mew-ext-prog-url       mew-w32-exec)
(setq mew-ext-prog-url-args  nil)


;; browse-url.
(defvar mew-w32-browse-url-button [mouse-2]) ; mouse button
(setq browse-url-regexp "\\(\\([^-A-Za-z0-9!_.%]\\|^\\)[-A-Za-z0-9._!%]+@[A-Za-z0-9][-A-Za-z0-9._!]+[A-Za-z0-9]\\)\\|\\(\\b\\(s?https?\\|ftp\\|file\\|gopher\\|news\\|telnet\\|wais\\|mailto\\):\\(//[-a-zA-Z0-9_.]+:[0-9]*\\)?[-a-zA-Z0-9_=?#$@~`%&*+|\\/.,]*[-a-zA-Z0-9_=#$@~`%&*+|\\/]+\\)")
(defun browse-url-or-mew (url)
  (interactive)
  "browse-url or mew-send."
  (message "Starting browse-url... or mew-send...")
  (cond
   ((string-match "^mailto:" url)
    (mew-send (substring url 7 nil)))
   ((string-match "^\\(s?https?\\|ftp\\|file\\|gopher\\|news\\|telnet\\|wais\\):" url)
    (apply (function start-process)
	   (format "*mew %s*" mew-ext-prog-url)
	   mew-buffer-tmp mew-ext-prog-url
	   (append mew-ext-prog-url-args (list url))))
   (t (progn
	(string-match "\\([A-Za-z0-9]\\)" url)
	(mew-send (substring url (match-beginning 1) nil))))))
(setq browse-url-browser-function 'browse-url-or-mew)
(add-hook 'mew-init-hook
	  (lambda ()
	    (progn 
	      (define-key mew-message-mode-map mew-w32-browse-url-button 'browse-url-at-mouse)
	      )))
;; if you want to use browse-url-at-mouse in global-map, uncomment this.
;; (define-key global-map [S-mouse-2] 'browse-url-at-mouse)


;; Emacs version dependent variables.
(cond
; ((string-match "XEmacs\\|Lucid" emacs-version)	; XEmacs?
;  (setq mew-prog-shell-arg  shell-command-switch)
  
;  (setq mew-cs-noconv-eol 'raw-text))

 ((eq 20 emacs-major-version)		; Meadow
  (setq mew-prog-shell-arg  shell-command-switch)
  
  (setq mew-cs-noconv-eol 'raw-text)
  
  (require 'mw32script)
  (mw32script-init))
 (t					; Mule for Win32
  (setq mew-prog-shell-arg  shell-command-option)
  
  (make-coding-system
   '*crlf2lf* 4
   ?= "No conversion." nil
   '([1 23 47 346 13 18 250 10 18 1881 5 4421 19 10
	47 772 5892 49 58 0 0 14 772 49 22] .
	[1 4 14 775 22]))
  (setq mew-cs-noconv-eol *crlf2lf*)
  
  (require 'win32-script)
  (define-process-argument-editing
    "/[^./]+$"
    'script-process-argument-editing-function 'last)))


(defvar mew-prog-plain '(mew-mime-text/plain () nil))
(defvar mew-prog-html '(mew-mime-text/html () nil))
(defvar mew-prog-text '(mew-mime-text/plain () nil))
(defvar mew-prog-audio (list mew-w32-exec () t))
(defvar mew-prog-gif (list mew-w32-exec () t))
(defvar mew-prog-jpeg (list mew-w32-exec () t))
(defvar mew-prog-xwd (list mew-w32-exec () t))
(defvar mew-prog-xbm (list mew-w32-exec () t))
(defvar mew-prog-bmp (list mew-w32-exec () t))
(defvar mew-prog-image (list mew-w32-exec () t))
(defvar mew-prog-mpeg (list mew-w32-exec () t))
(defvar mew-prog-rfc822 '(mew-mime-message/rfc822 () nil))
(defvar mew-prog-external-body '(mew-mime-external-body () nil))
(defvar mew-prog-delivery-status '(mew-mime-text/plain () nil))
(defvar mew-prog-postscript (list mew-w32-exec () t))
(defvar mew-prog-pgp-keys '(mew-mime-pgp-keys () nil))
(defvar mew-prog-octet-stream (list mew-w32-exec () t))

(provide 'mew-win32)

;;; Copyright Notice:

;; Copyright (C) 1996, 1997, 1998 Mew developing team.
;; All rights reserved.

;; Redistribution and use in source and binary forms, with or without
;; modification, are permitted provided that the following conditions
;; are met:
;; 
;; 1. Redistributions of source code must retain the above copyright
;;    notice, this list of conditions and the following disclaimer.
;; 2. Redistributions in binary form must reproduce the above copyright
;;    notice, this list of conditions and the following disclaimer in the
;;    documentation and/or other materials provided with the distribution.
;; 3. All advertising materials mentioning features or use of this software
;;    must display the following acknowledgement:
;;       This product includes software developed by 
;;       Mew developing team and its contributors.
;; 4. Neither the name of the team nor the names of its contributors
;;    may be used to endorse or promote products derived from this software
;;    without specific prior written permission.
;; 
;; THIS SOFTWARE IS PROVIDED BY THE TEAM AND CONTRIBUTORS ``AS IS'' AND
;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;; PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE TEAM OR CONTRIBUTORS BE
;; LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
;; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
;; SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
;; BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
;; OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
;; IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

;;; mew-win32.el ends here
