/*  VER 147   TAB P   $Id: request.c,v 1.2 1997/08/14 13:39:45 src Exp $
 *
 *  keep track of outstanding NNTP requests
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h"

/*
 *  outstanding request descriptor
 */
struct req {
    int (*req_fn)();
    long req_where;
} ;

struct req req_queue[REQ_MAX];
int req_n;
int req_head;
int req_tail;

/* 
 *  get status line from NNTP
 *  return false if trouble
 */
static int 
get_status(void)
{
    char status[NNTP_STRLEN+1];
    struct req *rp;

    if (req_n == 0) return 1; /* nothing to do */
    --req_n;
    rp = &(req_queue[req_tail]);
    if (++req_tail >= REQ_MAX) req_tail = 0;

    /* get status */
    if (!get_server_nntp(status, sizeof(status))) {
	/* timeout */
	return 0;
    }

    return (*rp->req_fn)(status, rp->req_where);
}

/* 
 *  send a request
 *  return false if trouble
 */
int 
put_request(char *request, int (*fn)(), long where)
{
    struct req *rp;
    int req_max = REQ_MAX;

    if (window) req_max = window > REQ_MAX ? req_max : window;
    else req_max = 1;

    while (req_n >= req_max) {
	/* request queue is full, must read */
	if (!get_status()) return 0;
    }

    rp = &(req_queue[req_head]);
    rp->req_fn	  = fn;
    rp->req_where = where;

    ++req_n;
    if (++req_head >= REQ_MAX) req_head = 0;

    if (!put_server_msg(request)) return 0;

    if (window == 0) return flush_request(); /* don't leave requests */

    return 1;
}

/* 
 *  flush request queue
 *  return false if trouble
 */
int 
flush_request(void)
{
    while (req_n > 0) {
	/* request queue is full, must read */
	if (!get_status()) return 0;
    }
    return 1;
}
