/*  VER 028   TAB P   $Id: util.c,v 1.2 1997/08/14 13:39:46 src Exp $
 *
 *  file utilities     
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "stat.h"

/*
 *  the name of the news home directory
 */
char *
news_home(void)
{				
    return (newshome && newshome[0]) ? newshome : NEWSHOME;
}

/*
 *  append the contents of a file to another file
 *  returns 0 on error, 1 if all OK
 */
int 
append_file(FILE *f,char *name,FILE *af)
{				
    int n;
    char buf[1024];

    if (fseek(f,0L,2) != 0) {
	log_msg(L_ERRno,"can't seek to end of \"%s\"", name);
	return 0;
    }

    while ((n = fread(buf,1,sizeof(buf),af)) > 0) {
	if (fwrite(buf,1,n,f) != n) {
	    /* append failed */
	    log_msg(L_ERR,"can't append to \"%s\"", name);
	    return 0;
	}
    }

    if (fflush(f) != 0) {
	log_msg(L_ERRno,"can't flush \"%s\"", name);
	return 0;
    }
    if (fseek(f,0L,0) != 0) {
	log_msg(L_ERRno,"can't seek to start of \"%s\"", name);
	return 0;
    }
    return 1;
}

/*
 *  rename a file 
 *  returns 0 on error
 */
int 
rename_file(char *from,char *to)
{
    if (rename(from,to) == EOF) {
	log_msg(L_ERRno,"can't rename \"%s\" to \"%s\"", from,to);
	return 0;
    }
    return 1;
}

/*
 *  find how old a file is, in seconds
 */
time_t
what_date(FILE *f,char *name)
{
    struct stat st;

    /* verify that it is a regular file */
    if (fstat(fileno(f),&st) < 0) {
	log_msg(L_ERRno,"can't fstat \"%s\"", name);
	return 0;
    }
    return st.st_mtime;
}

/*
 *  find how old a file is, in seconds
 */
time_t
how_old(FILE *f,char *name)
{
    time_t now;
    time(&now);

    return now - what_date(f,name);
}

/*
 *  check if it is a regular file
 */
int 
is_regular(FILE *f, char *name)
{
    struct stat st;

    /* verify that it is a regular file */
    if (fstat(fileno(f),&st) < 0) {
	log_msg(L_ERRno,"can't fstat \"%s\"", name);
	return 0;
    }
    /* BUG: both of these must be set: S_IRUSR S_IWUSR */
    if (!S_ISREG(st.st_mode)) { 
	log_msg(L_ERR,"\"%s\" is not a regular file", name);
	return 0;
    }
    return 1;
}

/*
 *  build a file name, with a fixed default choice as well as a
 *  first prioroty alternative 
 *  both names may be absolute or relative paths
 */
void 
build_alt_filename(char *where, char *home, char *fixed, char *alt)
{				
    char *name = (alt && alt[0]) ? alt : fixed;

    if (name[0]=='/' || name[0]=='.') {
	build_filename(where,name,NULL,NULL,NULL);
    } else {
	build_filename(where,home,"/",name,NULL);
    }
}

/*
 *  build a file name, max length PATH_MAX
 *  argument is a list of up to arguments, padded with NULL to make 4
 *  NOTE: a NULL-terminated argument list would have been neater,
 *	  but it is simply not worth the effort to make it portable
 */
void 
build_filename(char *where,char *arg1,char *arg2,char *arg3,char *arg4)
{				
    int len = 0;
    int n;
    char **argp;
    char *argv[5];

    argv[0] = arg1;
    argv[1] = arg2;
    argv[2] = arg3;
    argv[3] = arg4;
    argv[4] = NULL;

    for (argp = argv; *argp; ++argp) {
	if ((len += (n=strlen(*argp))) >= PATH_MAX) {
	    log_msg(L_ERR,"file name longer than %d chars", PATH_MAX-1);
	    unlock_exit(1);
	}
	strcpy(where+len-n,*argp);
    }
}
 
/*
 *  convert time to text string, local time
 *  return static pointer
 *  "Wed Apr 10 11:00:00 1996"
 */
char *
text_time(time_t t)
{
    static char buf[50];
    char *p;

    strcpy(buf,asctime(localtime(&t)));
    /* remove trailing newline */
    if ((p=strchr(buf,'\n'))) *p = '\0';

    return buf;
}
