/*
 * GTimer
 *
 * Copyright:
 *	(C) 1998 Craig Knudsen, cknudsen@radix.net
 *	See accompanying file "COPYING".
 * 
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 * 
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 * 
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the
 *	Free Software Foundation, Inc., 59 Temple Place,
 *	Suite 330, Boston, MA  02111-1307, USA
 *
 * Description:
 *	Helps you keep track of time spent on different tasks.
 *
 * Author:
 *	Craig Knudsen, cknudsen@radix.net, http://www.radix.net/~cknudsen
 *
 * Home Page:
 *	http://www.radix.net/~cknudsen/gtimer/
 *
 * History:
 *	05-Apr-1998	Changed release to 0.96
 *	24-Mar-1998	Changed release to 0.95
 *	18-Mar-1998	Changed release to 0.94
 *	13-Mar-1998	Changed release to 0.93
 *	10-Mar-1998	Changed release to 0.92
 *	10-Mar-1998	Changed release to 0.91
 *	25-Feb-1998	Created
 *
 ****************************************************************************/

#ifndef _GTIMER_H
#define _GTIMER_H

#define GTIMER_VERSION	"0.96"
#define GTIMER_VERSION_DATE	"05 Apr 1998"
#define GTIMER_URL		"http://www.radix.net/~cknudsen/gtimer/"
#define GTIMER_COPYRIGHT	"Copyright (C) 1998 Craig Knudsen"

#define GTIMER_STATUS_ID	"status-update"

typedef enum {
  CONFIRM_ABOUT,
  CONFIRM_ERROR,
  CONFIRM_WARNING,
  CONFIRM_CONFIRM,
  CONFIRM_MESSAGE
} enum_confirm_type;

typedef enum {
  REPORT_TYPE_DAILY,
  REPORT_TYPE_WEEKLY,
  REPORT_TYPE_MONTHLY,
  REPORT_TYPE_YEARLY,
  REPORT_TYPE_TOTAL
} report_type;

typedef struct {
  Task *task;
  TaskTimeEntry *todays_entry;
  int timer_on;
  time_t on_since;
  time_t total;			/* except for today */
  int name_updated;		/* flag to update name on next draw */
  int new_task;			/* flat to add this to the clist */
  char last_total[15];
  time_t last_total_int;
  char last_today[15];
  time_t last_today_int;
  int last_on;			/* was the icon drawn last time? */
  int selected;			/* item is selected */
  int moved;			/* item was moved */
} TaskData;

void save_all ();

void update_list ();

GtkWidget *create_edit_window ( TaskData *taskdata );

GtkWidget *create_annotate_window ( TaskData *taskdata );

GtkWidget *create_report_window ( report_type type );

GtkWidget *create_confirm_window (
  enum_confirm_type type,
  char *title,
  char *text,
  char *ok_text,
  char *cancel_text,
  void (*ok_callback)(),
  void (*cancel_callback)(),
  char *callback_data
);
  


#endif /* _GTIMER_H */

