/* Ruari Diff, a program to compare a Packages file and /var/lib/dpkg/status */
/* Copyright (C) 1997, James Troup <jjtroup@comp.brad.ac.uk> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "error.h"
#include "init.h"
#include "hash.h"
#include "vercmp.h"
#include "utils.h"
#include "main.h"

/* The following causes "common.h" to produce definitions of all the global
   variables, rather than just "extern" declarations of them. */
#define GLOBAL
#include "common.h"

int
main (int argc, char **argv)
{

  int option_index;		/* Where the options end and the files start */

  FILE *packages_fp, *dpkgout_fp;
  long packages_length, dpkgout_length;
  char *packages_buffer, *dpkgout_buffer;		
  int p, d;
  char p_package[PACKAGE_NAME_LENGTH];
  char dpkgout_package[PACKAGE_NAME_LENGTH];
  char p_version_string[PACKAGE_NAME_LENGTH];
  char d_version_string[PACKAGE_NAME_LENGTH];
  char status_string[PACKAGE_NAME_LENGTH];
  char priority[PACKAGE_NAME_LENGTH];
  char section[PACKAGE_NAME_LENGTH];

  struct package_info *hashed_package_info; 

  int debug = 0; /*DBG_SHOW_OLDER | DBG_LEVEL_1;*/

  program_name = argv[0];

  option_index = parse_opt (argc, argv);
  
  open_file (argv[option_index], packages_fp, &packages_buffer, &packages_length); 
  option_index++;
  open_file (argv[option_index], dpkgout_fp, &dpkgout_buffer, &dpkgout_length); 

  create_hash_table ();

  p = 0;

  while (p < packages_length)
    {

      if (packages_buffer[p] == 'P')
	{
	  read_line (packages_buffer, &p, p_package);
	  
	  if (debug & DBG_LEVEL_1)
	    fprintf (stderr, "Readline: \"\%s\"\n", p_package); 

 	  if (!(strncmp ("Package: ", p_package, 9))) 
	    {
	      if (debug & DBG_LEVEL_1)
		fprintf (stderr, "Searching for package \"%s\"\n", p_package+9);

/* 	      fprintf (stderr, "main: trying to get Version:\n"); */
	      get_blah (packages_buffer, &p, p_version_string, "Version: ", packages_length, p_package+9, 9);
/* 	      fprintf (stderr, "main: found \"%s\"\n", p_version_string); */
/* 	      fprintf (stderr, "main: trying to get Priority:\n"); */
	      get_blah (packages_buffer, &p, priority, "Priority: ", packages_length, p_package+9, 10);
/*  	      fprintf (stderr, "main: found \"%s\"\n", priority); */
/* 	      fprintf (stderr, "main: trying to get Section:\n"); */
	      get_blah (packages_buffer, &p, section, "Section: ", packages_length, p_package+9, 9);
/* 	      fprintf (stderr, "main: found \"%s\"\n", section); */

	      /* If no Priority or Section was found, ensure the
	       * output is sensible */

	      if (priority[0] == '\0')
		strcpy (priority+10, "-");
	      if (section[0] == '\0')
		strcpy (section+9, "none");

	      add_to_hash_table (p_package+9, p_version_string+9, priority+10, section+9);
	    }
	}
      else
	{
	  if (debug & DBG_LEVEL_1)
	    fprintf (stderr, "First Char was %c\n", packages_buffer[p]); 
        }
      skip_line(packages_buffer, &p);

    }

  d = 0;

  while (d < dpkgout_length)
    {

      if (dpkgout_buffer[d] == 'P')
	{
	  read_line (dpkgout_buffer, &d, dpkgout_package);
	  
  	  if (!(strncmp ("Package: ", dpkgout_package, 9)))  
 	    { 
 	      get_blah (dpkgout_buffer, &d, status_string, "Status: ", dpkgout_length, dpkgout_package+9, 7); 
	      
	      if ((strstr (status_string, " installed")) != NULL)
		{
		  get_blah (dpkgout_buffer, &d, d_version_string, "Version: ", dpkgout_length, dpkgout_package+9, 9);

		  if (debug & DBG_LEVEL_1)
		    fprintf (stderr, "Trying to retrieve %s (%s) from hash table:", 
			     dpkgout_package, d_version_string); 
		  
		  hashed_package_info = get_from_hash_table (dpkgout_package+9);
		  if (hashed_package_info == NULL)
		    printf ("%s not found\n", dpkgout_package+9);
		  else
		    {
		      if (debug & DBG_LEVEL_1)
			fprintf (stderr, "suceeded : %s (%s) [%s] {%s}\n", 
				 hashed_package_info->package_name, 
				 hashed_package_info->version, 
				 hashed_package_info->priority, 
				 hashed_package_info->section); 
		      compare_versions (d_version_string, hashed_package_info); 
		    }

		}
 	    }
	}
      else
	skip_line(dpkgout_buffer, &d);
    }
  
  destroy_hash_table ();
  free (packages_buffer);
  return (0);
      
}
